/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;

public class ResolveVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    public static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "java.io.", "java.net.", "java.util.", "groovy.lang.", "groovy.util."};
    private CompilationUnit compilationUnit;
    private Map cachedClasses = new HashMap();
    private static final Object NO_CLASS = new Object();
    private static final Object SCRIPT = new Object();
    private SourceUnit source;
    private VariableScope currentScope;
    private boolean isTopLevelProperty = true;
    private boolean inPropertyExpression = false;
    private boolean inClosure = false;
    private boolean isSpecialConstructorCall = false;
    private Map genericParameterNames = new HashMap();
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$PropertyExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$ClassNode;

    public ResolveVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        this.source = source;
        this.visitClass(node);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Map oldPNames = this.genericParameterNames;
        this.genericParameterNames = new HashMap(this.genericParameterNames);
        this.resolveGenericsHeader(node.getGenericsTypes());
        Parameter[] paras = node.getParameters();
        for (int i = 0; i < paras.length; ++i) {
            Parameter p = paras[i];
            p.setInitialExpression(this.transform(p.getInitialExpression()));
            this.resolveOrFail(p.getType(), p.getType());
            this.visitAnnotations(p);
        }
        ClassNode[] exceptions = node.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            ClassNode t = exceptions[i];
            this.resolveOrFail(t, node);
        }
        this.resolveOrFail(node.getReturnType(), node);
        super.visitConstructorOrMethod(node, isConstructor);
        this.genericParameterNames = oldPNames;
        this.currentScope = oldScope;
    }

    public void visitField(FieldNode node) {
        ClassNode t = node.getType();
        this.resolveOrFail(t, node);
        super.visitField(node);
    }

    public void visitProperty(PropertyNode node) {
        ClassNode t = node.getType();
        this.resolveOrFail(t, node);
        super.visitProperty(node);
    }

    private boolean resolveToInner(ClassNode type) {
        int len;
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        String saved = name = type.getName();
        while ((len = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, len) + "$" + name.substring(len + 1);
            type.setName(name);
            if (!this.resolve(type)) continue;
            return true;
        }
        if (this.resolveToInnerEnum(type)) {
            return true;
        }
        type.setName(saved);
        return false;
    }

    private boolean resolveToInnerEnum(ClassNode type) {
        String name = type.getName();
        if (this.currentClass != type && !_String.contains((String)name, (CharSequence)".")) {
            Class<?> clazz = type.getClass();
            Class<?> clazz2 = class$org$codehaus$groovy$ast$ClassNode;
            if (clazz2 == null) {
                clazz2 = class$org$codehaus$groovy$ast$ClassNode = new ClassNode[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) {
                type.setName(this.currentClass.getName() + "$" + name);
                if (this.resolve(type)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        if (this.resolve(type)) {
            return;
        }
        if (this.resolveToInner(type)) {
            return;
        }
        this.addError("unable to resolve class " + type.getName() + " " + msg, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node, boolean prefereImports) {
        this.resolveGenericsTypes(type.getGenericsTypes());
        if (prefereImports && this.resolveAliasFromModule(type)) {
            return;
        }
        this.resolveOrFail(type, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node) {
        this.resolveOrFail(type, "", node);
    }

    private boolean resolve(ClassNode type) {
        return this.resolve(type, true, true, true);
    }

    private boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        if (type.isResolved() || type.isPrimaryClassNode()) {
            return true;
        }
        this.resolveGenericsTypes(type.getGenericsTypes());
        if (type.isArray()) {
            ClassNode element = type.getComponentType();
            boolean resolved = this.resolve(element, testModuleImports, testDefaultImports, testStaticInnerClasses);
            if (resolved) {
                ClassNode cn = element.makeArray();
                type.setRedirect(cn);
            }
            return resolved;
        }
        if (this.currentClass == type) {
            return true;
        }
        if (this.genericParameterNames.get(type.getName()) != null) {
            GenericsType gt = (GenericsType)this.genericParameterNames.get(type.getName());
            type.setRedirect(gt.getType());
            type.setGenericsTypes(new GenericsType[]{gt});
            type.setGenericsPlaceHolder(true);
            return true;
        }
        if (this.currentClass.getNameWithoutPackage().equals(type.getName())) {
            type.setRedirect(this.currentClass);
            return true;
        }
        return this.resolveFromModule(type, testModuleImports) || this.resolveFromCompileUnit(type) || this.resolveFromDefaultImports(type, testDefaultImports) || this.resolveFromStaticInnerClasses(type, testStaticInnerClasses) || this.resolveFromClassCache(type) || this.resolveToClass(type) || this.resolveToScript(type);
    }

    private boolean resolveFromClassCache(ClassNode type) {
        String name = type.getName();
        Object val = this.cachedClasses.get(name);
        if (val == null || val == NO_CLASS) {
            return false;
        }
        this.setClass(type, (Class)val);
        return true;
    }

    private long getTimeStamp(Class cls) {
        return Verifier.getTimestamp(cls);
    }

    private boolean isSourceNewer(URL source, Class cls) {
        try {
            long lastMod;
            if (source.getProtocol().equals("file")) {
                String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
                File file = new File(path);
                lastMod = file.lastModified();
            } else {
                URLConnection conn = source.openConnection();
                lastMod = conn.getLastModified();
                conn.getInputStream().close();
            }
            return lastMod > this.getTimeStamp(cls);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean resolveToScript(ClassNode type) {
        String name = type.getName();
        if (type instanceof LowerCaseClass) {
            this.cachedClasses.put(name, NO_CLASS);
        }
        if (this.cachedClasses.get(name) == NO_CLASS) {
            return false;
        }
        if (this.cachedClasses.get(name) == SCRIPT) {
            this.cachedClasses.put(name, NO_CLASS);
        }
        if (name.startsWith("java.")) {
            return type.isResolved();
        }
        if (name.indexOf(36) != -1) {
            return type.isResolved();
        }
        ModuleNode module = this.currentClass.getModule();
        if (module.hasPackageName() && name.indexOf(46) == -1) {
            return type.isResolved();
        }
        GroovyClassLoader gcl = this.compilationUnit.getClassLoader();
        URL url = null;
        try {
            url = gcl.getResourceLoader().loadGroovySource(name);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url != null) {
            if (type.isResolved()) {
                Class cls = type.getTypeClass();
                if (!this.isSourceNewer(url, cls)) {
                    return true;
                }
                this.cachedClasses.remove(type.getName());
                type.setRedirect(null);
            }
            SourceUnit su = this.compilationUnit.addSource(url);
            this.currentClass.getCompileUnit().addClassNodeToCompile(type, su);
            return true;
        }
        return type.isResolved();
    }

    private String replaceLastPoint(String name) {
        int lastPoint = name.lastIndexOf(46);
        name = name.substring(0, lastPoint) + "$" + name.substring(lastPoint + 1);
        return name;
    }

    private boolean resolveFromStaticInnerClasses(ClassNode type, boolean testStaticInnerClasses) {
        if (type instanceof LowerCaseClass) {
            return false;
        }
        if (testStaticInnerClasses &= type.hasPackageName()) {
            if (type instanceof ConstructedClassWithPackage) {
                ConstructedClassWithPackage tmp = (ConstructedClassWithPackage)type;
                String name = ((ConstructedClassWithPackage)type).className;
                tmp.className = this.replaceLastPoint(name);
                if (this.resolve(tmp, false, true, true)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                tmp.className = name;
            } else {
                String name = type.getName();
                String replacedPointType = this.replaceLastPoint(name);
                type.setName(replacedPointType);
                if (this.resolve(type, false, true, true)) {
                    return true;
                }
                type.setName(name);
            }
        }
        return false;
    }

    private boolean resolveFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        testDefaultImports &= !type.hasPackageName();
        if (testDefaultImports &= !(type instanceof LowerCaseClass)) {
            int size = DEFAULT_IMPORTS.length;
            for (int i = 0; i < size; ++i) {
                String packagePrefix = DEFAULT_IMPORTS[i];
                String name = type.getName();
                ConstructedClassWithPackage tmp = new ConstructedClassWithPackage(packagePrefix, name);
                if (!this.resolve(tmp, false, false, false)) continue;
                type.setRedirect(tmp.redirect());
                return true;
            }
            String name = type.getName();
            if (name.equals("BigInteger")) {
                type.setRedirect(ClassHelper.BigInteger_TYPE);
                return true;
            }
            if (name.equals("BigDecimal")) {
                type.setRedirect(ClassHelper.BigDecimal_TYPE);
                return true;
            }
        }
        return false;
    }

    private boolean resolveFromCompileUnit(ClassNode type) {
        CompileUnit compileUnit = this.currentClass.getCompileUnit();
        if (compileUnit == null) {
            return false;
        }
        ClassNode cuClass = compileUnit.getClass(type.getName());
        if (cuClass != null) {
            if (type != cuClass) {
                type.setRedirect(cuClass);
            }
            return true;
        }
        return false;
    }

    private void setClass(ClassNode n, Class cls) {
        ClassNode cn = ClassHelper.make(cls);
        n.setRedirect(cn);
    }

    private void ambiguousClass(ClassNode type, ClassNode iType, String name) {
        if (type.getName().equals(iType.getName())) {
            this.addError("reference to " + name + " is ambiguous, both class " + type.getName() + " and " + iType.getName() + " match", type);
        } else {
            type.setRedirect(iType);
        }
    }

    private boolean resolveAliasFromModule(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String pname = name = type.getName();
        int index = name.length();
        do {
            ClassNode aliasedNode;
            if ((aliasedNode = module.getImport(pname = name.substring(0, index))) == null) continue;
            if (pname.length() == name.length()) {
                type.setRedirect(aliasedNode);
                return true;
            }
            String className = aliasedNode.getNameWithoutPackage() + '$' + name.substring(pname.length() + 1).replace('.', '$');
            ConstructedClassWithPackage tmp = new ConstructedClassWithPackage(aliasedNode.getPackageName() + ".", className);
            if (!this.resolve(tmp, true, true, false)) continue;
            type.setRedirect(tmp.redirect());
            return true;
        } while ((index = pname.lastIndexOf(46)) != -1);
        return false;
    }

    private boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        if (type instanceof LowerCaseClass) {
            return this.resolveAliasFromModule(type);
        }
        String name = type.getName();
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        boolean newNameUsed = false;
        if (!type.hasPackageName() && module.hasPackageName() && !(type instanceof ConstructedClassWithPackage)) {
            type.setName(module.getPackageName() + name);
            newNameUsed = true;
        }
        List moduleClasses = module.getClasses();
        Iterator iter = moduleClasses.iterator();
        while (iter.hasNext()) {
            ClassNode mClass = (ClassNode)iter.next();
            if (!mClass.getName().equals(type.getName())) continue;
            if (mClass != type) {
                type.setRedirect(mClass);
            }
            return true;
        }
        if (newNameUsed) {
            type.setName(name);
        }
        if (testModuleImports) {
            ConstructedClassWithPackage tmp;
            if (this.resolveAliasFromModule(type)) {
                return true;
            }
            if (module.hasPackageName() && this.resolve(tmp = new ConstructedClassWithPackage(module.getPackageName(), name), false, false, false)) {
                type.setRedirect(tmp.redirect());
                return true;
            }
            List packages = module.getImportPackages();
            Iterator iter2 = packages.iterator();
            while (iter2.hasNext()) {
                String packagePrefix = (String)iter2.next();
                ConstructedClassWithPackage tmp2 = new ConstructedClassWithPackage(packagePrefix, name);
                if (!this.resolve(tmp2, false, false, true)) continue;
                this.ambiguousClass(type, tmp2, name);
                type.setRedirect(tmp2.redirect());
                return true;
            }
        }
        return false;
    }

    private boolean resolveToClass(ClassNode type) {
        Class cls;
        Object cached;
        String name = type.getName();
        if (type instanceof LowerCaseClass) {
            this.cachedClasses.put(name, NO_CLASS);
        }
        if ((cached = this.cachedClasses.get(name)) == NO_CLASS) {
            return false;
        }
        if (cached == SCRIPT) {
            throw new GroovyBugError("name " + name + " was marked as script, but was not resolved as such");
        }
        if (cached != null) {
            return true;
        }
        if (this.currentClass.getModule().hasPackageName() && name.indexOf(46) == -1) {
            return false;
        }
        GroovyClassLoader loader = this.compilationUnit.getClassLoader();
        try {
            cls = loader.loadClass(name, false, true);
        }
        catch (ClassNotFoundException cnfe) {
            this.cachedClasses.put(name, SCRIPT);
            return false;
        }
        catch (CompilationFailedException cfe) {
            this.compilationUnit.getErrorCollector().addErrorAndContinue(new ExceptionMessage(cfe, true, this.source));
            return false;
        }
        if (cls == null) {
            return false;
        }
        this.cachedClasses.put(name, cls);
        this.setClass(type, cls);
        return cls.getClassLoader() == loader;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        Expression ret = null;
        if (exp instanceof VariableExpression) {
            ret = this.transformVariableExpression((VariableExpression)exp);
        } else {
            Class<?> clazz = exp.getClass();
            Class<?> clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
            if (clazz2 == null) {
                clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression = new PropertyExpression[0].getClass().getComponentType();
            }
            if (clazz == clazz2) {
                ret = this.transformPropertyExpression((PropertyExpression)exp);
            } else if (exp instanceof DeclarationExpression) {
                ret = this.transformDeclarationExpression((DeclarationExpression)exp);
            } else if (exp instanceof BinaryExpression) {
                ret = this.transformBinaryExpression((BinaryExpression)exp);
            } else if (exp instanceof MethodCallExpression) {
                ret = this.transformMethodCallExpression((MethodCallExpression)exp);
            } else if (exp instanceof ClosureExpression) {
                ret = this.transformClosureExpression((ClosureExpression)exp);
            } else if (exp instanceof ConstructorCallExpression) {
                ret = this.transformConstructorCallExpression((ConstructorCallExpression)exp);
            } else if (exp instanceof AnnotationConstantExpression) {
                ret = this.transformAnnotationConstantExpression((AnnotationConstantExpression)exp);
            } else {
                this.resolveOrFail(exp.getType(), exp);
                ret = exp.transformExpression(this);
            }
        }
        if (ret != null && ret != exp) {
            ret.setSourcePosition(exp);
        }
        return ret;
    }

    private String lookupClassName(PropertyExpression pe) {
        boolean doInitialClassTest = true;
        String name = "";
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)it;
                if (ve.isSuperExpression() || ve.isThisExpression()) {
                    return null;
                }
                String varName = ve.getName();
                if (doInitialClassTest) {
                    if (!this.testVanillaNameForClass(varName)) {
                        return null;
                    }
                    doInitialClassTest = false;
                    name = varName;
                    break;
                }
                name = varName + "." + name;
                break;
            }
            Class<?> clazz = it.getClass();
            Class<?> clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
            if (clazz2 == null) {
                clazz2 = new PropertyExpression[0].getClass().getComponentType();
            }
            if (clazz != clazz2) {
                return null;
            }
            PropertyExpression current = it;
            String propertyPart = current.getPropertyAsString();
            if (propertyPart == null || propertyPart.equals("class")) {
                return null;
            }
            if (doInitialClassTest) {
                if (!this.testVanillaNameForClass(propertyPart)) {
                    return null;
                }
                doInitialClassTest = false;
                name = propertyPart;
                continue;
            }
            name = propertyPart + "." + name;
        }
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    private Expression correctClassClassChain(PropertyExpression pe) {
        LinkedList<PropertyExpression> stack = new LinkedList<PropertyExpression>();
        ClassExpression found = null;
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof ClassExpression) {
                found = (ClassExpression)it;
                break;
            }
            Class<?> clazz = it.getClass();
            Class<?> clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
            if (clazz2 == null) {
                clazz2 = new PropertyExpression[0].getClass().getComponentType();
            }
            if (clazz != clazz2) {
                return pe;
            }
            stack.addFirst((PropertyExpression)it);
        }
        if (found == null) {
            return pe;
        }
        if (stack.isEmpty()) {
            return pe;
        }
        Object stackElement = stack.removeFirst();
        Class<?> clazz = stackElement.getClass();
        Class<?> clazz3 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
        if (clazz3 == null) {
            clazz3 = class$org$codehaus$groovy$ast$expr$PropertyExpression = new PropertyExpression[0].getClass().getComponentType();
        }
        if (clazz != clazz3) {
            return pe;
        }
        PropertyExpression classPropertyExpression = (PropertyExpression)stackElement;
        String propertyNamePart = classPropertyExpression.getPropertyAsString();
        if (propertyNamePart == null || !propertyNamePart.equals("class")) {
            return pe;
        }
        found.setSourcePosition(classPropertyExpression);
        if (stack.isEmpty()) {
            return found;
        }
        stackElement = stack.removeFirst();
        Class<?> clazz4 = stackElement.getClass();
        Class<?> clazz5 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
        if (clazz5 == null) {
            clazz5 = class$org$codehaus$groovy$ast$expr$PropertyExpression = new PropertyExpression[0].getClass().getComponentType();
        }
        if (clazz4 != clazz5) {
            return pe;
        }
        PropertyExpression classPropertyExpressionContainer = (PropertyExpression)stackElement;
        classPropertyExpressionContainer.setObjectExpression(found);
        return pe;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        ClassExpression ce;
        ClassNode type;
        ClassNode type2;
        boolean itlp = this.isTopLevelProperty;
        boolean ipe = this.inPropertyExpression;
        Expression objectExpression = pe.getObjectExpression();
        this.inPropertyExpression = true;
        Class<?> clazz = objectExpression.getClass();
        Class<?> clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
        if (clazz2 == null) {
            clazz2 = class$org$codehaus$groovy$ast$expr$PropertyExpression = new PropertyExpression[0].getClass().getComponentType();
        }
        this.isTopLevelProperty = clazz != clazz2;
        objectExpression = this.transform(objectExpression);
        this.inPropertyExpression = false;
        Expression property = this.transform(pe.getProperty());
        this.isTopLevelProperty = itlp;
        this.inPropertyExpression = ipe;
        boolean spreadSafe = pe.isSpreadSafe();
        PropertyExpression old = pe;
        pe = new PropertyExpression(objectExpression, property, pe.isSafe());
        pe.setSpreadSafe(spreadSafe);
        pe.setSourcePosition(old);
        String className = this.lookupClassName(pe);
        if (className != null && this.resolve(type2 = ClassHelper.make(className))) {
            ClassExpression ret = new ClassExpression(type2);
            ret.setSourcePosition(pe);
            return ret;
        }
        if (objectExpression instanceof ClassExpression && pe.getPropertyAsString() != null && this.resolve(type = ClassHelper.make((ce = (ClassExpression)objectExpression).getType().getName() + "$" + pe.getPropertyAsString()), false, false, false)) {
            ClassExpression ret = new ClassExpression(type);
            ret.setSourcePosition(ce);
            return ret;
        }
        Expression ret = pe;
        if (this.isTopLevelProperty) {
            ret = this.correctClassClassChain(pe);
        }
        return ret;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            String name = ve.getName();
            ClassNode t = ClassHelper.make(name);
            boolean isClass = t.isResolved();
            if (!isClass) {
                if (Character.isLowerCase(name.charAt(0))) {
                    t = new LowerCaseClass(name);
                }
                if (!(isClass = this.resolve(t))) {
                    isClass = this.resolveToInnerEnum(t);
                }
            }
            if (isClass) {
                for (VariableScope scope = this.currentScope; scope != null && !scope.isRoot() && !scope.isRoot() && scope.removeReferencedClassVariable(ve.getName()) != null; scope = scope.getParent()) {
                }
                ClassExpression ce = new ClassExpression(t);
                ce.setSourcePosition(ve);
                return ce;
            }
        }
        this.resolveOrFail(ve.getType(), ve);
        return ve;
    }

    private boolean testVanillaNameForClass(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !Character.isLowerCase(name.charAt(0));
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        ListExpression list;
        Expression left = this.transform(be.getLeftExpression());
        int type = be.getOperation().getType();
        if ((type == 1100 || type == 100) && left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            String error = "you tried to assign a value to the class '" + ce.getType().getName() + "'";
            if (ce.getType().isScript()) {
                error = error + ". Do you have a script with this name?";
            }
            this.addError(error, be.getLeftExpression());
            return be;
        }
        if (left instanceof ClassExpression && be.getRightExpression() instanceof ListExpression && (list = (ListExpression)be.getRightExpression()).getExpressions().isEmpty()) {
            return new ClassExpression(left.getType().makeArray());
        }
        Expression right = this.transform(be.getRightExpression());
        be.setLeftExpression(left);
        be.setRightExpression(right);
        return be;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        Statement code;
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Parameter[] paras = ce.getParameters();
        if (paras != null) {
            for (int i = 0; i < paras.length; ++i) {
                Expression initialVal;
                ClassNode t = paras[i].getType();
                this.resolveOrFail(t, ce);
                if (!paras[i].hasInitialExpression() || !((initialVal = paras[i].getInitialExpression()) instanceof Expression)) continue;
                this.transform(initialVal);
            }
        }
        if ((code = ce.getCode()) != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        ClassNode type = cce.getType();
        this.resolveOrFail(type, cce);
        this.isSpecialConstructorCall = cce.isSpecialCall();
        Expression ret = cce.transformExpression(this);
        this.isSpecialConstructorCall = false;
        return ret;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        MethodCallExpression result = new MethodCallExpression(object, method, args);
        result.setSafe(mce.isSafe());
        result.setImplicitThis(mce.isImplicitThis());
        result.setSpreadSafe(mce.isSpreadSafe());
        result.setSourcePosition(mce);
        return result;
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        Expression oldLeft = de.getLeftExpression();
        Expression left = this.transform(oldLeft);
        if (left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to the class " + ce.getType().getName(), oldLeft);
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            return de;
        }
        DeclarationExpression newDeclExpr = new DeclarationExpression(left, de.getOperation(), right);
        newDeclExpr.setSourcePosition(de);
        return newDeclExpr;
    }

    protected Expression transformAnnotationConstantExpression(AnnotationConstantExpression ace) {
        AnnotationNode an = (AnnotationNode)ace.getValue();
        ClassNode type = an.getClassNode();
        this.resolveOrFail(type, ", unable to find class for annotation", an);
        Iterator iter = an.getMembers().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry member = iter.next();
            Expression memberValue = (Expression)member.getValue();
            member.setValue(this.transform(memberValue));
        }
        return ace;
    }

    public void visitAnnotations(AnnotatedNode node) {
        List annotations = node.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn()) continue;
            ClassNode type = an.getClassNode();
            this.resolveOrFail(type, ",  unable to find class for annotation", an);
            Iterator iter = an.getMembers().entrySet().iterator();
            while (iter.hasNext()) {
                PropertyExpression pe;
                Map.Entry member = iter.next();
                Expression memberValue = (Expression)member.getValue();
                Expression newValue = this.transform(memberValue);
                member.setValue(newValue);
                if (!(newValue instanceof PropertyExpression) || (pe = (PropertyExpression)newValue).getObjectExpression() instanceof ClassExpression) continue;
                this.addError("unable to find class for enum", pe.getObjectExpression());
            }
        }
    }

    public void visitClass(ClassNode node) {
        ClassNode sn;
        ClassNode oldNode = this.currentClass;
        this.currentClass = node;
        this.resolveGenericsHeader(node.getGenericsTypes());
        ModuleNode module = node.getModule();
        if (!module.hasImportsResolved()) {
            ClassNode type;
            List l = module.getImports();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                ImportNode element = (ImportNode)iter.next();
                type = element.getType();
                if (this.resolve(type, false, false, true)) continue;
                this.addError("unable to resolve class " + type.getName(), type);
            }
            Map importPackages = module.getStaticImportClasses();
            Iterator iter2 = importPackages.values().iterator();
            while (iter2.hasNext()) {
                type = (ClassNode)iter2.next();
                if (this.resolve(type, false, false, true)) continue;
                if (type.getPackageName() == null && node.getPackageName() != null) {
                    String oldTypeName = type.getName();
                    type.setName(node.getPackageName() + "." + oldTypeName);
                    if (this.resolve(type, false, false, true)) continue;
                    type.setName(oldTypeName);
                }
                this.addError("unable to resolve class " + type.getName(), type);
            }
            iter2 = module.getStaticImportAliases().values().iterator();
            while (iter2.hasNext()) {
                type = (ClassNode)iter2.next();
                if (this.resolve(type, true, true, true)) continue;
                this.addError("unable to resolve class " + type.getName(), type);
            }
            iter2 = module.getStaticImportClasses().values().iterator();
            while (iter2.hasNext()) {
                type = (ClassNode)iter2.next();
                if (this.resolve(type, true, true, true)) continue;
                this.addError("unable to resolve class " + type.getName(), type);
            }
            module.setImportsResolved(true);
        }
        if ((sn = node.getUnresolvedSuperClass()) != null) {
            this.resolveOrFail(sn, node, true);
        }
        ClassNode[] interfaces = node.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.resolveOrFail(interfaces[i], node, true);
        }
        super.visitClass(node);
        this.currentClass = oldNode;
    }

    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), cs);
        if (cs.getExceptionType() == ClassHelper.DYNAMIC_TYPE) {
            Parameter parameter = cs.getVariable();
            Class<?> clazz = class$java$lang$Exception;
            if (clazz == null) {
                clazz = class$java$lang$Exception = new Exception[0].getClass().getComponentType();
            }
            parameter.setType(ClassHelper.make(clazz));
        }
        super.visitCatchStatement(cs);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.resolveOrFail(forLoop.getVariableType(), forLoop);
        super.visitForLoop(forLoop);
    }

    public void visitBlockStatement(BlockStatement block) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = block.getVariableScope();
        super.visitBlockStatement(block);
        this.currentScope = oldScope;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private void resolveGenericsTypes(GenericsType[] types) {
        if (types == null) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        for (int i = 0; i < types.length; ++i) {
            this.resolveGenericsType(types[i]);
        }
    }

    private void resolveGenericsHeader(GenericsType[] types) {
        if (types == null) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        for (int i = 0; i < types.length; ++i) {
            ClassNode type = types[i].getType();
            String name = type.getName();
            ClassNode[] bounds = types[i].getUpperBounds();
            if (bounds != null) {
                boolean nameAdded = false;
                for (int j = 0; j < bounds.length; ++j) {
                    ClassNode upperBound = bounds[j];
                    if (!nameAdded && upperBound != null || !this.resolve(type)) {
                        this.genericParameterNames.put(name, types[i]);
                        types[i].setPlaceholder(true);
                        type.setRedirect(upperBound);
                        nameAdded = true;
                    }
                    this.resolveOrFail(upperBound, type);
                }
                continue;
            }
            this.genericParameterNames.put(name, types[i]);
            type.setRedirect(ClassHelper.OBJECT_TYPE);
            types[i].setPlaceholder(true);
        }
    }

    private void resolveGenericsType(GenericsType genericsType) {
        if (genericsType.isResolved()) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        ClassNode type = genericsType.getType();
        String name = type.getName();
        ClassNode[] bounds = genericsType.getUpperBounds();
        if (!this.genericParameterNames.containsKey(name)) {
            if (bounds != null) {
                for (int j = 0; j < bounds.length; ++j) {
                    ClassNode upperBound = bounds[j];
                    this.resolveOrFail(upperBound, genericsType);
                    type.setRedirect(upperBound);
                    this.resolveGenericsTypes(upperBound.getGenericsTypes());
                }
            } else if (genericsType.isWildcard()) {
                type.setRedirect(ClassHelper.OBJECT_TYPE);
            } else {
                this.resolveOrFail(type, genericsType);
            }
        } else {
            GenericsType gt = (GenericsType)this.genericParameterNames.get(name);
            type.setRedirect(gt.getType());
            genericsType.setPlaceholder(true);
        }
        if (genericsType.getLowerBound() != null) {
            this.resolveOrFail(genericsType.getLowerBound(), genericsType);
        }
        this.resolveGenericsTypes(type.getGenericsTypes());
        genericsType.setResolved(true);
    }

    private static class LowerCaseClass
    extends ClassNode {
        String className;

        public LowerCaseClass(String name) {
            super(name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.className = name;
        }

        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.className;
        }

        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return false;
        }

        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedClassWithPackage#setName should not be called");
        }
    }

    private static class ConstructedClassWithPackage
    extends ClassNode {
        String prefix;
        String className;

        public ConstructedClassWithPackage(String pkg, String name) {
            super(pkg + name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.prefix = pkg;
            this.className = name;
        }

        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.prefix + this.className;
        }

        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.className.indexOf(46) != -1;
        }

        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedClassWithPackage#setName should not be called");
        }
    }
}

