/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.util.TripleKeyHashMap;

public class ReflectionCache {
    private static Map primitiveTypesMap = new HashMap();
    static TripleKeyHashMap mopNames;
    static final CachedClass STRING_CLASS;
    public static final CachedClass OBJECT_CLASS;
    public static final CachedClass OBJECT_ARRAY_CLASS;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;

    public static Class autoboxType(Class type) {
        Class res = (Class)primitiveTypesMap.get(type);
        return res == null ? type : res;
    }

    public static String getMOPMethodName(CachedClass declaringClass, String name, boolean useThis) {
        TripleKeyHashMap.Entry mopNameEntry = mopNames.getOrPut(declaringClass, name, useThis);
        if (mopNameEntry.value == null) {
            mopNameEntry.value = (useThis ? "this$" : "super$") + declaringClass.getSuperClassDistance() + "$" + name;
        }
        return (String)mopNameEntry.value;
    }

    public static boolean isArray(Class klazz) {
        return klazz.getName().charAt(0) == '[';
    }

    static void setAssignableFrom(Class klazz, Class aClass) {
    }

    public static boolean isAssignableFrom(Class klazz, Class aClass) {
        if (klazz == aClass) {
            return true;
        }
        return klazz.isAssignableFrom(aClass);
    }

    static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static CachedClass getCachedClass(Class klazz) {
        if (klazz == null) {
            return null;
        }
        return ClassInfo.getClassInfo(klazz).getCachedClass();
    }

    static {
        Class<?> clazz = class$java$lang$Byte;
        if (clazz == null) {
            clazz = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Byte.TYPE, clazz);
        Class<?> clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Boolean.TYPE, clazz2);
        Class<?> clazz3 = class$java$lang$Character;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Character.TYPE, clazz3);
        Class<?> clazz4 = class$java$lang$Double;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Double.TYPE, clazz4);
        Class<?> clazz5 = class$java$lang$Float;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Float.TYPE, clazz5);
        Class<?> clazz6 = class$java$lang$Integer;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Integer.TYPE, clazz6);
        Class<?> clazz7 = class$java$lang$Long;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Long.TYPE, clazz7);
        Class<?> clazz8 = class$java$lang$Short;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        primitiveTypesMap.put(Short.TYPE, clazz8);
        mopNames = new TripleKeyHashMap();
        Class<?> clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        STRING_CLASS = ReflectionCache.getCachedClass(clazz9);
        Class<?> clazz10 = class$java$lang$Object;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OBJECT_CLASS = ReflectionCache.getCachedClass(clazz10);
        Class<?> clazz11 = array$Ljava$lang$Object;
        if (clazz11 == null) {
            clazz11 = array$Ljava$lang$Object = new Object[0].getClass();
        }
        OBJECT_ARRAY_CLASS = ReflectionCache.getCachedClass(clazz11);
    }
}

