/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.ConversionHandler;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyGenerator {
    public static final ProxyGenerator INSTANCE = new ProxyGenerator();
    private ClassLoader override = null;
    private boolean debug = false;
    private boolean emptyMethods = false;
    private List objectMethods;
    private List groovyObjectMethods;
    static /* synthetic */ Class class$groovy$lang$GroovyObjectSupport;
    static /* synthetic */ Class class$groovy$lang$GroovyObject;
    static /* synthetic */ Class class$groovy$util$ProxyGenerator;
    static /* synthetic */ Class class$java$lang$Object;

    public ProxyGenerator() {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        this.objectMethods = this.getInheritedMethods(clazz, new ArrayList<Method>());
        Class<?> clazz2 = class$groovy$lang$GroovyObject;
        if (clazz2 == null) {
            clazz2 = class$groovy$lang$GroovyObject = new GroovyObject[0].getClass().getComponentType();
        }
        this.groovyObjectMethods = this.getInheritedMethods(clazz2, new ArrayList<Method>());
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getEmptyMethods() {
        return this.emptyMethods;
    }

    public void setEmptyMethods(boolean emptyMethods) {
        this.emptyMethods = emptyMethods;
    }

    public ClassLoader getOverride() {
        return this.override;
    }

    public void setOverride(ClassLoader override) {
        this.override = override;
    }

    public Object instantiateAggregateFromBaseClass(Class clazz) {
        return this.instantiateAggregateFromBaseClass((Map)null, clazz);
    }

    public Object instantiateAggregateFromBaseClass(Map map, Class clazz) {
        return this.instantiateAggregateFromBaseClass(map, clazz, null);
    }

    public Object instantiateAggregateFromBaseClass(Closure cl, Class clazz) {
        HashMap<String, Closure> m = new HashMap<String, Closure>();
        m.put("*", cl);
        return this.instantiateAggregateFromBaseClass(m, clazz, null);
    }

    public Object instantiateAggregateFromBaseClass(Map map, Class clazz, Object[] constructorArgs) {
        return this.instantiateAggregate(map, null, clazz, constructorArgs);
    }

    public Object instantiateAggregateFromInterface(Class clazz) {
        return this.instantiateAggregateFromInterface(null, clazz);
    }

    public Object instantiateAggregateFromInterface(Map map, Class clazz) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(clazz);
        return this.instantiateAggregate(map, interfaces);
    }

    public Object instantiateAggregate(List interfaces) {
        return this.instantiateAggregate(null, interfaces);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces) {
        return this.instantiateAggregate(closureMap, interfaces, null);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces, Class clazz) {
        return this.instantiateAggregate(closureMap, interfaces, clazz, null);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces, Class clazz, Object[] constructorArgs) {
        ClassLoader cl;
        int i;
        Class<?> baseClass;
        Class<?> clazz2;
        Map map = new HashMap();
        if (closureMap != null) {
            map = closureMap;
        }
        List interfacesToImplement = new ArrayList();
        if (interfaces != null) {
            interfacesToImplement = interfaces;
        }
        if ((clazz2 = class$groovy$lang$GroovyObjectSupport) == null) {
            clazz2 = baseClass = (class$groovy$lang$GroovyObjectSupport = new GroovyObjectSupport[0].getClass().getComponentType());
        }
        if (clazz != null) {
            baseClass = clazz;
        }
        boolean hasArgs = constructorArgs != null && constructorArgs.length > 0;
        String name = new StringBuffer().append(this.shortName(baseClass.getName())).append("_groovyProxy").toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append("class ").append(name);
        if (clazz != null) {
            buffer.append(" extends ").append(baseClass.getName());
        }
        for (int i2 = 0; i2 < interfacesToImplement.size(); ++i2) {
            Class thisInterface = (Class)interfacesToImplement.get(i2);
            if (i2 == 0) {
                buffer.append(" implements ");
            } else {
                buffer.append(", ");
            }
            buffer.append(thisInterface.getName());
        }
        buffer.append(" {\n").append("    private closureMap\n    ");
        buffer.append(name).append("(map");
        if (hasArgs) {
            buffer.append(", args");
        }
        buffer.append(") {\n");
        buffer.append("        super(");
        if (hasArgs) {
            buffer.append("*args");
        }
        buffer.append(")\n");
        buffer.append("        this.closureMap = map\n");
        buffer.append("    }\n");
        HashMap<String, Method> selectedMethods = new HashMap<String, Method>();
        List<Method> publicAndProtectedMethods = this.getInheritedMethods(baseClass, new ArrayList<Method>());
        boolean closureIndicator = map.containsKey("*");
        for (Method method : publicAndProtectedMethods) {
            if (method.getName().indexOf(36) != -1 || Modifier.isFinal(method.getModifiers()) || ConversionHandler.isCoreObjectMethod(method) || this.containsEquivalentMethod(selectedMethods.values(), method) || !map.containsKey(method.getName()) && !closureIndicator) continue;
            selectedMethods.put(method.getName(), method);
            this.addOverridingMapCall(buffer, method, closureIndicator);
        }
        ArrayList<Method> interfaceMethods = new ArrayList<Method>();
        for (i = 0; i < interfacesToImplement.size(); ++i) {
            Class thisInterface = (Class)interfacesToImplement.get(i);
            this.getInheritedMethods(thisInterface, interfaceMethods);
        }
        for (i = 0; i < interfaceMethods.size(); ++i) {
            Method method = (Method)interfaceMethods.get(i);
            if (this.containsEquivalentMethod(publicAndProtectedMethods, method)) continue;
            selectedMethods.put(method.getName(), method);
            this.addMapOrDummyCall(map, buffer, method);
        }
        for (String methodName : map.keySet()) {
            if (methodName.indexOf(36) != -1 || methodName.indexOf(42) != -1 || selectedMethods.keySet().contains(methodName)) continue;
            this.addNewMapCall(buffer, methodName);
        }
        buffer.append("}\n").append("new ").append(name);
        buffer.append("(map");
        if (hasArgs) {
            buffer.append(", constructorArgs");
        }
        buffer.append(")");
        Binding binding = new Binding();
        binding.setVariable("map", map);
        binding.setVariable("constructorArgs", constructorArgs);
        ClassLoader classLoader = cl = this.override != null ? this.override : baseClass.getClassLoader();
        if (clazz == null && interfacesToImplement.size() > 0) {
            Class c = (Class)interfacesToImplement.get(0);
            cl = c.getClassLoader();
        }
        GroovyShell shell = new GroovyShell(cl, binding);
        if (this.debug) {
            System.out.println(new StringBuffer().append("proxy source:\n------------------\n").append(buffer.toString()).append("\n------------------").toString());
        }
        try {
            return shell.evaluate(buffer.toString());
        }
        catch (MultipleCompilationErrorsException err) {
            throw new GroovyRuntimeException(new StringBuffer().append("Error creating proxy: ").append(err.getMessage()).toString());
        }
    }

    public Object instantiateDelegate(Object delegate) {
        return this.instantiateDelegate(null, delegate);
    }

    public Object instantiateDelegate(List interfaces, Object delegate) {
        return this.instantiateDelegate(null, interfaces, delegate);
    }

    public Object instantiateDelegate(Map closureMap, List interfaces, Object delegate) {
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, null);
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate) {
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, delegate.getClass());
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate, Class baseClass) {
        String name = new StringBuffer().append(this.shortName(delegate.getClass().getName())).append("_delegateProxy").toString();
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, baseClass, name);
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate, Class baseClass, String name) {
        int i;
        Map map = new HashMap();
        if (closureMap != null) {
            map = closureMap;
        }
        ArrayList<String> selectedMethods = new ArrayList<String>();
        List interfacesToImplement = new ArrayList();
        if (interfaces != null) {
            interfacesToImplement = interfaces;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("import org.codehaus.groovy.runtime.InvokerHelper\nclass ").append(name);
        if (baseClass != null) {
            buffer.append(" extends ").append(baseClass.getName());
        }
        for (int i2 = 0; i2 < interfacesToImplement.size(); ++i2) {
            Class thisInterface = (Class)interfacesToImplement.get(i2);
            if (i2 == 0) {
                buffer.append(" implements ");
            } else {
                buffer.append(", ");
            }
            buffer.append(thisInterface.getName());
        }
        buffer.append(" {\n").append("    private delegate\n").append("    private closureMap\n    ");
        buffer.append(name).append("(map, delegate) {\n");
        buffer.append("        this.closureMap = map\n");
        buffer.append("        this.delegate = delegate\n");
        buffer.append("    }\n");
        ArrayList<Method> interfaceMethods = new ArrayList<Method>();
        for (i = 0; i < interfacesToImplement.size(); ++i) {
            Class thisInterface = (Class)interfacesToImplement.get(i);
            this.getInheritedMethods(thisInterface, interfaceMethods);
        }
        for (i = 0; i < interfaceMethods.size(); ++i) {
            Method method = (Method)interfaceMethods.get(i);
            if (this.containsEquivalentMethod(this.objectMethods, method) || this.containsEquivalentMethod(this.groovyObjectMethods, method)) continue;
            selectedMethods.add(method.getName());
            this.addWrappedCall(buffer, method, map);
        }
        List<Method> additionalMethods = this.getInheritedMethods(delegate.getClass(), new ArrayList<Method>());
        for (int i3 = 0; i3 < additionalMethods.size(); ++i3) {
            Method method = additionalMethods.get(i3);
            if (method.getName().indexOf(36) != -1 || this.containsEquivalentMethod(interfaceMethods, method) || this.containsEquivalentMethod(this.objectMethods, method) || this.containsEquivalentMethod(this.groovyObjectMethods, method)) continue;
            selectedMethods.add(method.getName());
            this.addWrappedCall(buffer, method, map);
        }
        for (String methodName : map.keySet()) {
            if (selectedMethods.contains(methodName)) continue;
            this.addNewMapCall(buffer, methodName);
        }
        buffer.append("}\n").append("new ").append(name);
        buffer.append("(map, delegate)");
        Binding binding = new Binding();
        binding.setVariable("map", map);
        binding.setVariable("delegate", delegate);
        ClassLoader cl = this.override != null ? this.override : delegate.getClass().getClassLoader();
        GroovyShell shell = new GroovyShell(cl, binding);
        if (this.debug) {
            System.out.println(new StringBuffer().append("proxy source:\n------------------\n").append(buffer.toString()).append("\n------------------").toString());
        }
        try {
            return shell.evaluate(buffer.toString());
        }
        catch (MultipleCompilationErrorsException err) {
            throw new GroovyRuntimeException(new StringBuffer().append("Error creating proxy: ").append(err.getMessage()).toString());
        }
    }

    private void addWrappedCall(StringBuffer buffer, Method method, Map map) {
        if (map.containsKey(method.getName())) {
            this.addOverridingMapCall(buffer, method, false);
        } else {
            Class[] parameterTypes = this.addMethodPrefix(buffer, method);
            this.addWrappedMethodBody(buffer, method, parameterTypes);
            this.addMethodSuffix(buffer);
        }
    }

    private boolean containsEquivalentMethod(Collection<Method> publicAndProtectedMethods, Method candidate) {
        for (Method method : publicAndProtectedMethods) {
            if (!candidate.getName().equals(method.getName()) || !candidate.getReturnType().equals(method.getReturnType()) || !this.hasMatchingParameterTypes(candidate, method)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchingParameterTypes(Method method, Method candidate) {
        Class<?>[] methodParamTypes;
        Class<?>[] candidateParamTypes = candidate.getParameterTypes();
        if (candidateParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (candidateParamTypes[i].equals(methodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private List<Method> getInheritedMethods(Class baseClass, List<Method> methods) {
        methods.addAll(DefaultGroovyMethods.toList(baseClass.getMethods()));
        for (Class currentClass = baseClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] protectedMethods = currentClass.getDeclaredMethods();
            for (int i = 0; i < protectedMethods.length; ++i) {
                Method method = protectedMethods[i];
                if (method.getName().indexOf(36) != -1 || !Modifier.isProtected(method.getModifiers()) || this.containsEquivalentMethod(methods, method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    private void addNewMapCall(StringBuffer buffer, String methodName) {
        buffer.append("    def ").append(methodName).append("(Object[] args) {\n").append("        this.@closureMap['").append(methodName).append("'] (*args)\n    }\n");
    }

    private void addOverridingMapCall(StringBuffer buffer, Method method, boolean closureIndicator) {
        Class[] parameterTypes = this.addMethodPrefix(buffer, method);
        this.addMethodBody(buffer, closureIndicator ? "*" : method.getName(), parameterTypes);
        this.addMethodSuffix(buffer);
    }

    private void addMapOrDummyCall(Map map, StringBuffer buffer, Method method) {
        Class[] parameterTypes = this.addMethodPrefix(buffer, method);
        if (map.containsKey(method.getName())) {
            this.addMethodBody(buffer, method.getName(), parameterTypes);
        } else if (!this.emptyMethods) {
            this.addUnsupportedBody(buffer);
        }
        this.addMethodSuffix(buffer);
    }

    private void addUnsupportedBody(StringBuffer buffer) {
        buffer.append("throw new UnsupportedOperationException()");
    }

    private Class[] addMethodPrefix(StringBuffer buffer, Method method) {
        buffer.append("    ").append(this.getSimpleName(method.getReturnType())).append(" ").append(method.getName()).append("(");
        Class[] parameterTypes = method.getParameterTypes();
        for (int parameterTypeIndex = 0; parameterTypeIndex < parameterTypes.length; ++parameterTypeIndex) {
            Class<?> parameter = parameterTypes[parameterTypeIndex];
            if (parameterTypeIndex != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getSimpleName(parameter)).append(" ").append("p").append(parameterTypeIndex);
        }
        buffer.append(") { ");
        return parameterTypes;
    }

    private void addMethodBody(StringBuffer buffer, String method, Class[] parameterTypes) {
        buffer.append("this.@closureMap['").append(method).append("'] (");
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append("p").append(j);
        }
        buffer.append(")");
    }

    private void addWrappedMethodBody(StringBuffer buffer, Method method, Class[] parameterTypes) {
        buffer.append("\n        Object[] args = [");
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append("p").append(j);
        }
        buffer.append("]\n        ");
        buffer.append("InvokerHelper.invokeMethod(delegate, '").append(method.getName()).append("', args)\n");
    }

    private void addMethodSuffix(StringBuffer buffer) {
        buffer.append("    }\n");
    }

    public String getSimpleName(Class c) {
        if (c.isArray()) {
            int dimension = 0;
            Class<?> componentClass = c;
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
                ++dimension;
            }
            return new StringBuffer().append(componentClass.getName().replaceAll("\\$", "\\.")).append(DefaultGroovyMethods.multiply("[]", (Number)_Integer.valueOf((int)dimension))).toString();
        }
        return c.getName().replaceAll("\\$", "\\.");
    }

    public String shortName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1, name.length());
    }

    private static void setMetaClass(MetaClass metaClass) {
        DelegatingMetaClass newMetaClass = new DelegatingMetaClass(metaClass){

            public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
                return InvokerHelper.invokeMethod(INSTANCE, methodName, arguments);
            }
        };
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        Class<?> clazz = class$groovy$util$ProxyGenerator;
        if (clazz == null) {
            clazz = class$groovy$util$ProxyGenerator = new ProxyGenerator[0].getClass().getComponentType();
        }
        metaClassRegistry.setMetaClass(clazz, newMetaClass);
    }

    static {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        Class<?> clazz = class$groovy$util$ProxyGenerator;
        if (clazz == null) {
            clazz = class$groovy$util$ProxyGenerator = new ProxyGenerator[0].getClass().getComponentType();
        }
        ProxyGenerator.setMetaClass(metaClassRegistry.getMetaClass(clazz));
    }
}

