/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.IFileNameFinder;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.ScriptTestAdapter;

public class AllTestSuite
extends TestSuite {
    public static final String SYSPROP_TEST_DIR = "groovy.test.dir";
    public static final String SYSPROP_TEST_PATTERN = "groovy.test.pattern";
    public static final String SYSPROP_TEST_EXCLUDES_PATTERN = "groovy.test.excludesPattern";
    private static final Logger LOG;
    private static final ClassLoader JAVA_LOADER;
    private static final GroovyClassLoader GROOVY_LOADER;
    private static final String[] EMPTY_ARGS;
    private static IFileNameFinder finder;
    static /* synthetic */ Class class$groovy$util$AllTestSuite;
    static /* synthetic */ Class class$groovy$lang$Script;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test suite() {
        String basedir = System.getProperty(SYSPROP_TEST_DIR, "./test/");
        String pattern = System.getProperty(SYSPROP_TEST_PATTERN, "**/*Test.groovy");
        String excludesPattern = System.getProperty(SYSPROP_TEST_EXCLUDES_PATTERN, "");
        return AllTestSuite.suite(basedir, pattern);
    }

    public static Test suite(String basedir, String pattern) {
        return AllTestSuite.suite(basedir, pattern, "");
    }

    public static Test suite(String basedir, String pattern, String excludesPattern) {
        AllTestSuite suite = new AllTestSuite();
        String fileName = "";
        try {
            List filenames = excludesPattern.length() > 0 ? finder.getFileNames(basedir, pattern, excludesPattern) : finder.getFileNames(basedir, pattern);
            Iterator iter = filenames.iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                LOG.finest("trying to load " + fileName);
                suite.loadTest(fileName);
            }
        }
        catch (CompilationFailedException e1) {
            e1.printStackTrace();
            throw new RuntimeException("CompilationFailedException when loading " + fileName, e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException when loading " + fileName, e2);
        }
        return suite;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void loadTest(String fileName) throws CompilationFailedException, IOException {
        Class type = this.compile(fileName);
        Class<?> clazz = class$junit$framework$Test;
        if (clazz == null) {
            clazz = class$junit$framework$Test = new Test[0].getClass().getComponentType();
        }
        if (!clazz.isAssignableFrom(type)) {
            Class<?> clazz2 = class$groovy$lang$Script;
            if (clazz2 == null) {
                clazz2 = class$groovy$lang$Script = new Script[0].getClass().getComponentType();
            }
            if (clazz2.isAssignableFrom(type)) {
                this.addTest(new ScriptTestAdapter(type, EMPTY_ARGS));
                return;
            }
        }
        this.addTestSuite(type);
    }

    protected Class compile(String fileName) throws CompilationFailedException, IOException {
        return GROOVY_LOADER.parseClass(new File(fileName));
    }

    static {
        Class<?> clazz = class$groovy$util$AllTestSuite;
        if (clazz == null) {
            clazz = class$groovy$util$AllTestSuite = new AllTestSuite[0].getClass().getComponentType();
        }
        LOG = Logger.getLogger(clazz.getName());
        Class<?> clazz2 = class$groovy$util$AllTestSuite;
        if (clazz2 == null) {
            clazz2 = class$groovy$util$AllTestSuite = new AllTestSuite[0].getClass().getComponentType();
        }
        JAVA_LOADER = clazz2.getClassLoader();
        GROOVY_LOADER = new GroovyClassLoader(JAVA_LOADER);
        EMPTY_ARGS = new String[0];
        finder = null;
        try {
            Class<?> finderClass = Class.forName("groovy.util.FileNameFinder");
            finder = (IFileNameFinder)finderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find and instantiate class FileNameFinder", e);
        }
    }
}

