/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.retrotranslator.runtime.java.lang._Class;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationCollectorCodeVisitor;
import org.codehaus.groovy.transform.GroovyASTTransformation;

public class ASTTransformationVisitor
extends ClassCodeVisitorSupport {
    private CompilePhase phase;
    private SourceUnit source;
    private List<ASTNode[]> targetNodes;
    private Map<ASTNode, List<ASTTransformation>> transforms;
    private Map<Class<? extends ASTTransformation>, ASTTransformation> transformInstances;
    static /* synthetic */ Class class$org$codehaus$groovy$transform$ASTTransformation;
    static /* synthetic */ Class class$org$codehaus$groovy$transform$GroovyASTTransformation;

    private ASTTransformationVisitor(CompilePhase phase) {
        this.phase = phase;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode classNode) {
        Map<Class<? extends ASTTransformation>, Set<ASTNode>> baseTransforms = classNode.getTransforms(this.phase);
        if (!baseTransforms.isEmpty()) {
            Iterator<Object> i$;
            this.transformInstances = new HashMap<Class<? extends ASTTransformation>, ASTTransformation>();
            Iterator<Object> i$2 = baseTransforms.keySet().iterator();
            while (i$2.hasNext()) {
                Class<? extends ASTTransformation> transformClass = i$2.next();
                try {
                    this.transformInstances.put(transformClass, transformClass.newInstance());
                }
                catch (InstantiationException e) {
                    this.source.getErrorCollector().addError(new SimpleMessage("Could not instantiate Transformation Processor " + transformClass, this.source));
                }
                catch (IllegalAccessException e) {
                    this.source.getErrorCollector().addError(new SimpleMessage("Could not instantiate Transformation Processor " + transformClass, this.source));
                }
            }
            this.transforms = new HashMap<ASTNode, List<ASTTransformation>>();
            i$2 = baseTransforms.entrySet().iterator();
            while (i$2.hasNext()) {
                Map.Entry entry = (Map.Entry)i$2.next();
                i$ = ((Set)entry.getValue()).iterator();
                while (i$.hasNext()) {
                    ASTNode node = (ASTNode)i$.next();
                    List<ASTTransformation> list = this.transforms.get(node);
                    if (list == null) {
                        list = new ArrayList<ASTTransformation>();
                        this.transforms.put(node, list);
                    }
                    list.add(this.transformInstances.get(entry.getKey()));
                }
            }
            this.targetNodes = new LinkedList<ASTNode[]>();
            super.visitClass(classNode);
            i$2 = this.targetNodes.iterator();
            while (i$2.hasNext()) {
                ASTNode[] node = (ASTNode[])i$2.next();
                i$ = this.transforms.get(node[0]).iterator();
                while (i$.hasNext()) {
                    ASTTransformation snt = (ASTTransformation)i$.next();
                    snt.visit(node, this.source);
                }
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        Iterator i$ = node.getAnnotations().iterator();
        while (i$.hasNext()) {
            AnnotationNode annotation = (AnnotationNode)i$.next();
            if (!this.transforms.containsKey(annotation)) continue;
            this.targetNodes.add(new ASTNode[]{annotation, node});
        }
    }

    public static void addPhaseOperations(CompilationUnit compilationUnit) {
        ASTTransformationVisitor.addGlobalTransforms(compilationUnit);
        compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                ASTTransformationCollectorCodeVisitor collector = new ASTTransformationCollectorCodeVisitor(source);
                collector.visitClass(classNode);
            }
        }, 4);
        CompilePhase[] arr$ = CompilePhase.values();
        int len$ = arr$.length;
        block3: for (int i$ = 0; i$ < len$; ++i$) {
            CompilePhase phase = arr$[i$];
            final ASTTransformationVisitor visitor = new ASTTransformationVisitor(phase);
            switch (4.$SwitchMap$org$codehaus$groovy$control$CompilePhase[phase.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    continue block3;
                }
                default: {
                    compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            visitor.source = source;
                            visitor.visitClass(classNode);
                        }
                    }, phase.getPhaseNumber());
                }
            }
        }
    }

    public static void addGlobalTransforms(CompilationUnit compilationUnit) {
        GroovyClassLoader cuLoader = compilationUnit.getClassLoader();
        LinkedHashMap<String, URL> globalTransformNames = new LinkedHashMap<String, URL>();
        try {
            Enumeration<URL> globalServices = cuLoader.getResources("META-INF/services/org.codehaus.groovy.transform.ASTTransformation");
            while (globalServices.hasMoreElements()) {
                String className;
                URL service = globalServices.nextElement();
                BufferedReader svcIn = new BufferedReader(new InputStreamReader(service.openStream()));
                try {
                    className = svcIn.readLine();
                }
                catch (IOException ioe) {
                    compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                    continue;
                }
                while (className != null) {
                    if (!className.startsWith("#") && className.length() > 0) {
                        if (globalTransformNames.containsKey(className)) {
                            if (!service.equals(globalTransformNames.get(className))) {
                                compilationUnit.getErrorCollector().addWarning(2, "The global transform for class " + className + " is defined in both " + ((URL)globalTransformNames.get(className)).toExternalForm() + " and " + service.toExternalForm() + " - the former definition will be used and the latter ignored.", null, null);
                            }
                        } else {
                            globalTransformNames.put(className, service);
                        }
                    }
                    try {
                        className = svcIn.readLine();
                    }
                    catch (IOException ioe) {
                        compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                    }
                }
            }
        }
        catch (IOException e) {
            compilationUnit.getErrorCollector().addError(new SimpleMessage("IO Exception attempting to load global transforms:" + e.getMessage(), null));
        }
        try {
            Class.forName("java.lang.annotation.Annotation");
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Global ASTTransformations are not enabled in retro builds of groovy.\n");
            sb.append("The following transformations will be ignored:");
            Iterator i$ = globalTransformNames.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = i$.next();
                sb.append('\t');
                sb.append((String)entry.getKey());
                sb.append('\n');
            }
            compilationUnit.getErrorCollector().addWarning(new WarningMessage(2, sb.toString(), null, null));
            return;
        }
        Iterator i$ = globalTransformNames.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            try {
                GroovyASTTransformation transformAnnotation;
                Class<?> gTransClass = cuLoader.loadClass((String)entry.getKey());
                Class<?> clazz = class$org$codehaus$groovy$transform$GroovyASTTransformation;
                if (clazz == null) {
                    clazz = new GroovyASTTransformation[0].getClass().getComponentType();
                }
                if ((transformAnnotation = (GroovyASTTransformation)_Class.getAnnotation(gTransClass, (Class)clazz)) == null) {
                    ErrorCollector errorCollector = compilationUnit.getErrorCollector();
                    StringBuffer stringBuffer = new StringBuffer().append("Transform Class ").append((String)entry.getKey()).append(" is specified as a global transform in ").append(((URL)entry.getValue()).toExternalForm()).append(" but it is not annotated by ");
                    Class<?> clazz2 = class$org$codehaus$groovy$transform$GroovyASTTransformation;
                    if (clazz2 == null) {
                        clazz2 = new GroovyASTTransformation[0].getClass().getComponentType();
                    }
                    errorCollector.addWarning(new WarningMessage(2, stringBuffer.append(clazz2.getName()).append(" the global tranform associated with it may fail and cause the compilation to fail.").toString(), null, null));
                    continue;
                }
                Class<?> clazz3 = class$org$codehaus$groovy$transform$ASTTransformation;
                if (clazz3 == null) {
                    clazz3 = new ASTTransformation[0].getClass().getComponentType();
                }
                if (clazz3.isAssignableFrom(gTransClass)) {
                    final ASTTransformation instance = (ASTTransformation)gTransClass.newInstance();
                    compilationUnit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                        public void call(SourceUnit source) throws CompilationFailedException {
                            instance.visit(new ASTNode[]{source.getAST()}, source);
                        }
                    }, transformAnnotation.phase().getPhaseNumber());
                    continue;
                }
                compilationUnit.getErrorCollector().addError(new SimpleMessage("Transform Class " + (String)entry.getKey() + " specified at " + ((URL)entry.getValue()).toExternalForm() + " is not an ASTTransformation.", null));
            }
            catch (Exception e) {
                compilationUnit.getErrorCollector().addError(new SimpleMessage("Could not instantiate global transform class " + (String)entry.getKey() + " specified at " + ((URL)entry.getValue()).toExternalForm() + "  because of exception " + e.toString(), null));
            }
        }
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$org$codehaus$groovy$control$CompilePhase;

        static {
            $SwitchMap$org$codehaus$groovy$control$CompilePhase = new int[CompilePhase.values().length];
            try {
                4.$SwitchMap$org$codehaus$groovy$control$CompilePhase[CompilePhase.INITIALIZATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$codehaus$groovy$control$CompilePhase[CompilePhase.PARSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$codehaus$groovy$control$CompilePhase[CompilePhase.CONVERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

