/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class Util
implements SuffixConstants {
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final int DEFAULT_WRITING_SIZE = 1024;
    public static final String UTF_8 = "UTF-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = new String(CharOperation.NO_CHAR);
    public static final int[] EMPTY_INT_ARRAY = new int[0];

    public static String buildAllDirectoriesInto(String outputPath, String relativeFileName) throws IOException {
        String fileName;
        String outputDirPath;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        outputPath = outputPath.replace('/', fileSeparatorChar);
        int separatorIndex = (relativeFileName = relativeFileName.replace('/', fileSeparatorChar)).lastIndexOf(fileSeparatorChar);
        if (separatorIndex == -1) {
            if (outputPath.endsWith(fileSeparator)) {
                outputDirPath = outputPath.substring(0, outputPath.length() - 1);
                fileName = String.valueOf(outputPath) + relativeFileName;
            } else {
                outputDirPath = outputPath;
                fileName = String.valueOf(outputPath) + fileSeparator + relativeFileName;
            }
        } else if (outputPath.endsWith(fileSeparator)) {
            outputDirPath = String.valueOf(outputPath) + relativeFileName.substring(0, separatorIndex);
            fileName = String.valueOf(outputPath) + relativeFileName;
        } else {
            outputDirPath = String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(0, separatorIndex);
            fileName = String.valueOf(outputPath) + fileSeparator + relativeFileName;
        }
        File f = new File(outputDirPath);
        f.mkdirs();
        if (f.isDirectory()) {
            return fileName;
        }
        if (outputPath.endsWith(fileSeparator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        f = new File(outputPath);
        boolean checkFileType = false;
        if (f.exists()) {
            checkFileType = true;
        } else if (!f.mkdirs()) {
            if (f.exists()) {
                checkFileType = true;
            } else {
                throw new IOException(Messages.bind(Messages.output_notValidAll, f.getAbsolutePath()));
            }
        }
        if (checkFileType && !f.isDirectory()) {
            throw new IOException(Messages.bind(Messages.output_isFile, f.getAbsolutePath()));
        }
        StringBuffer outDir = new StringBuffer(outputPath);
        outDir.append(fileSeparator);
        StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
        String token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            f = new File(outDir.append(token).append(fileSeparator).toString());
            checkFileType = false;
            if (f.exists()) {
                checkFileType = true;
            } else if (!f.mkdir()) {
                if (f.exists()) {
                    checkFileType = true;
                } else {
                    throw new IOException(Messages.bind(Messages.output_notValid, outDir.substring(outputPath.length() + 1, outDir.length() - 1), outputPath));
                }
            }
            if (checkFileType && !f.isDirectory()) {
                throw new IOException(Messages.bind(Messages.output_isFile, f.getAbsolutePath()));
            }
            token = tokenizer.nextToken();
        }
        return outDir.append(token).toString();
    }

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    public static int computeOuterMostVisibility(TypeDeclaration typeDeclaration, int visibility) {
        while (typeDeclaration != null) {
            switch (typeDeclaration.modifiers & 7) {
                case 2: {
                    visibility = 2;
                    break;
                }
                case 0: {
                    if (visibility == 2) break;
                    visibility = 0;
                    break;
                }
                case 4: {
                    if (visibility != 1) break;
                    visibility = 4;
                }
            }
            typeDeclaration = typeDeclaration.enclosingType;
        }
        return visibility;
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
            return byArray;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            char[] cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
            return cArray;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static FileOutputStream getFileOutputStream(boolean generatePackagesStructure, String outputPath, String relativeFileName) throws IOException {
        if (generatePackagesStructure) {
            return new FileOutputStream(new File(Util.buildAllDirectoriesInto(outputPath, relativeFileName)));
        }
        String fileName = null;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        outputPath = outputPath.replace('/', fileSeparatorChar);
        int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
        if (indexOfPackageSeparator == -1) {
            fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName : String.valueOf(outputPath) + fileSeparator + relativeFileName;
        } else {
            int length = relativeFileName.length();
            fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName.substring(indexOfPackageSeparator + 1, length) : String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
        }
        return new FileOutputStream(new File(fileName));
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        BufferedReader reader = null;
        try {
            reader = encoding == null ? new BufferedReader(new InputStreamReader(stream)) : new BufferedReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            reader = new BufferedReader(new InputStreamReader(stream));
        }
        int totalRead = 0;
        char[] contents = length == -1 ? CharOperation.NO_CHAR : new char[length];
        while (true) {
            int amountRequested;
            if (totalRead < length) {
                amountRequested = length - totalRead;
            } else {
                int current = reader.read();
                if (current < 0) break;
                amountRequested = Math.max(stream.available(), 8192);
                if (totalRead + 1 + amountRequested > contents.length) {
                    char[] cArray = contents;
                    contents = new char[totalRead + 1 + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, totalRead);
                }
                contents[totalRead++] = (char)current;
            }
            int amountRead = reader.read(contents, totalRead, amountRequested);
            if (amountRead < 0) break;
            totalRead += amountRead;
        }
        int start = 0;
        if (totalRead > 0 && UTF_8.equals(encoding) && contents[0] == '\ufeff') {
            --totalRead;
            start = 1;
        }
        if (totalRead < contents.length) {
            char[] cArray = contents;
            contents = new char[totalRead];
            System.arraycopy(cArray, start, contents, 0, totalRead);
        }
        return contents;
    }

    public static String getExceptionSummary(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer buffer = stringWriter.getBuffer();
        StringBuffer exceptionBuffer = new StringBuffer(50);
        exceptionBuffer.append(exception.toString());
        int i = 0;
        int lineSep = 0;
        int max = buffer.length();
        int line2Start = 0;
        block4: while (i < max) {
            switch (buffer.charAt(i)) {
                case '\n': 
                case '\r': {
                    if (line2Start > 0) {
                        exceptionBuffer.append(' ').append(buffer.substring(line2Start, i));
                        break block4;
                    }
                    ++lineSep;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    if (lineSep <= 0) break;
                    line2Start = i;
                    lineSep = 0;
                }
            }
            ++i;
        }
        return exceptionBuffer.toString();
    }

    public static int getLineNumber(int position, int[] lineEnds, int g, int d) {
        if (lineEnds == null) {
            return 1;
        }
        if (d == -1) {
            return 1;
        }
        int m = g;
        while (g <= d) {
            m = g + (d - g) / 2;
            int start = lineEnds[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < lineEnds[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        InputStream stream = null;
        try {
            InputStream inputStream = zip.getInputStream(ze);
            if (inputStream == null) {
                throw new IOException("Invalid zip entry name : " + ze.getName());
            }
            stream = new BufferedInputStream(inputStream);
            byte[] byArray = Util.getInputStreamAsByteArray(stream, (int)ze.getSize());
            return byArray;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int hashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public static final boolean isPotentialZipArchive(String name) {
        int i;
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return false;
        }
        if (name.lastIndexOf(File.separatorChar) > lastDot) {
            return false;
        }
        int length = name.length();
        int extensionLength = length - lastDot - 1;
        if (extensionLength == "java".length()) {
            i = extensionLength - 1;
            while (i >= 0) {
                if (Character.toLowerCase(name.charAt(length - extensionLength + i)) != "java".charAt(i)) break;
                if (i == 0) {
                    return false;
                }
                --i;
            }
        }
        if (extensionLength == "class".length()) {
            i = extensionLength - 1;
            while (i >= 0) {
                if (Character.toLowerCase(name.charAt(length - extensionLength + i)) != "class".charAt(i)) {
                    return true;
                }
                --i;
            }
            return false;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_class[i] && c != SUFFIX_CLASS[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_class[suffixIndex = suffixLength - i - 1] && c != SUFFIX_CLASS[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!CharOperation.pathMatch(folderPattern, path, true, '/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_java[i] && c != SUFFIX_JAVA[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isJavaFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_java[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAVA[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void reverseQuickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(right + left) / 2];
        while (true) {
            if (CharOperation.compareTo(list[left], mid) > 0) {
                ++left;
                continue;
            }
            while (CharOperation.compareTo(mid, list[right]) > 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.reverseQuickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.reverseQuickSort(list, left, original_right);
        }
    }

    public static void reverseQuickSort(char[][] list, int left, int right, int[] result) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(right + left) / 2];
        while (true) {
            if (CharOperation.compareTo(list[left], mid) > 0) {
                ++left;
                continue;
            }
            while (CharOperation.compareTo(mid, list[right]) > 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                int temp = result[left];
                result[left] = result[right];
                result[right] = temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.reverseQuickSort(list, original_left, right, result);
        }
        if (left < original_right) {
            Util.reverseQuickSort(list, left, original_right, result);
        }
    }

    public static final int searchColumnNumber(int[] startLineIndexes, int lineNumber, int position) {
        switch (lineNumber) {
            case 1: {
                return position + 1;
            }
            case 2: {
                return position - startLineIndexes[0];
            }
        }
        int line = lineNumber - 2;
        int length = startLineIndexes.length;
        if (line >= length) {
            return position - startLineIndexes[length - 1];
        }
        return position - startLineIndexes[line];
    }

    public static Boolean toBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objects) {
        return Util.toString(objects, new Displayable(){

            public String displayString(Object o) {
                if (o == null) {
                    return "null";
                }
                return o.toString();
            }
        });
    }

    public static String toString(Object[] objects, Displayable renderer) {
        if (objects == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(renderer.displayString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static void writeToDisk(boolean generatePackagesStructure, String outputPath, String relativeFileName, ClassFile classFile) throws IOException {
        FileOutputStream file = Util.getFileOutputStream(generatePackagesStructure, outputPath, relativeFileName);
        BufferedOutputStream output = new BufferedOutputStream(file, 1024);
        try {
            output.write(classFile.header, 0, classFile.headerOffset);
            output.write(classFile.contents, 0, classFile.contentsOffset);
            output.flush();
        }
        finally {
            output.close();
        }
    }

    public static void recordNestedType(ClassFile classFile, TypeBinding typeBinding) {
        if (classFile.visitedTypes == null) {
            classFile.visitedTypes = new HashSet(3);
        } else if (classFile.visitedTypes.contains(typeBinding)) {
            return;
        }
        classFile.visitedTypes.add(typeBinding);
        if (typeBinding.isParameterizedType() && (typeBinding.tagBits & 0x800L) != 0L) {
            TypeBinding[] arguments;
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
            ReferenceBinding genericType = parameterizedTypeBinding.genericType();
            if ((genericType.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, genericType);
            }
            if ((arguments = parameterizedTypeBinding.arguments) != null) {
                int j = 0;
                int max2 = arguments.length;
                while (j < max2) {
                    TypeBinding argument = arguments[j];
                    if (argument.isWildcard()) {
                        ReferenceBinding[] superInterfaces;
                        ReferenceBinding superclass;
                        WildcardBinding wildcardBinding = (WildcardBinding)argument;
                        TypeBinding bound = wildcardBinding.bound;
                        if (bound != null && (bound.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, bound);
                        }
                        if ((superclass = wildcardBinding.superclass()) != null && (superclass.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, superclass);
                        }
                        if ((superInterfaces = wildcardBinding.superInterfaces()) != null) {
                            int k = 0;
                            int max3 = superInterfaces.length;
                            while (k < max3) {
                                ReferenceBinding superInterface = superInterfaces[k];
                                if ((superInterface.tagBits & 0x800L) != 0L) {
                                    Util.recordNestedType(classFile, superInterface);
                                }
                                ++k;
                            }
                        }
                    } else if ((argument.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, argument);
                    }
                    ++j;
                }
            }
        } else if (typeBinding.isTypeVariable() && (typeBinding.tagBits & 0x800L) != 0L) {
            TypeBinding[] upperBounds;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
            TypeBinding upperBound = typeVariableBinding.upperBound();
            if (upperBound != null && (upperBound.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, upperBound);
            }
            if ((upperBounds = typeVariableBinding.otherUpperBounds()) != null) {
                int k = 0;
                int max3 = upperBounds.length;
                while (k < max3) {
                    TypeBinding otherUpperBound = upperBounds[k];
                    if ((otherUpperBound.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, otherUpperBound);
                    }
                    ++k;
                }
            }
        } else if (typeBinding.isNestedType()) {
            classFile.recordInnerClasses(typeBinding);
        }
    }

    public static File getJavaHome() {
        File javaHomeFile;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && (javaHomeFile = new File(javaHome)).exists()) {
            return javaHomeFile;
        }
        return null;
    }

    public static void collectRunningVMBootclasspath(List bootclasspaths) {
        block9: {
            block8: {
                String javaversion = System.getProperty("java.version");
                if (javaversion != null && javaversion.equalsIgnoreCase("1.1.8")) {
                    throw new IllegalStateException();
                }
                String bootclasspathProperty = System.getProperty("sun.boot.class.path");
                if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
                    bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
                }
                if (bootclasspathProperty == null || bootclasspathProperty.length() == 0) break block8;
                StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    FileSystem.Classpath currentClasspath = FileSystem.getClasspath(token, null, null);
                    if (currentClasspath == null) continue;
                    bootclasspaths.add(currentClasspath);
                }
                break block9;
            }
            File javaHome = Util.getJavaHome();
            if (javaHome == null) break block9;
            File[] directoriesToCheck = null;
            directoriesToCheck = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(javaHome, "../Classes")} : new File[]{new File(javaHome, "lib")};
            File[][] systemLibrariesJars = Main.getLibrariesFiles(directoriesToCheck);
            if (systemLibrariesJars != null) {
                int i = 0;
                int max = systemLibrariesJars.length;
                while (i < max) {
                    File[] current = systemLibrariesJars[i];
                    if (current != null) {
                        int j = 0;
                        int max2 = current.length;
                        while (j < max2) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, false, null, null);
                            if (classpath != null) {
                                bootclasspaths.add(classpath);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

