/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFolderCompilationParticipant
extends CompilationParticipant {
    private static final PathLengthComparator comparator = new PathLengthComparator();
    private BuildContext[] compiledFiles;

    @Override
    public boolean isActive(IJavaProject project) {
        return GroovyNature.hasGroovyNature(project.getProject());
    }

    @Override
    public void buildStarting(BuildContext[] files, boolean isBatch) {
        this.compiledFiles = files;
    }

    @Override
    public void buildFinished(IJavaProject project) {
        try {
            if (this.compiledFiles == null || !ScriptFolderSelector.isEnabled()) {
                return;
            }
            try {
                ScriptFolderSelector selector = new ScriptFolderSelector();
                Map<IContainer, IContainer> sourceToOut = this.generateSourceToOut(project);
                BuildContext[] buildContextArray = this.compiledFiles;
                int n = this.compiledFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath filePath;
                    IContainer containingSourceFolder;
                    BuildContext compiledFile = buildContextArray[n2];
                    IFile file = compiledFile.getFile();
                    if (selector.getFileKind(file) == ScriptFolderSelector.FileKind.SCRIPT && (containingSourceFolder = this.findContainingSourceFolder(sourceToOut, filePath = file.getFullPath())) != null) {
                        IPath packagePath = this.findPackagePath(filePath, containingSourceFolder);
                        IContainer out = sourceToOut.get(containingSourceFolder);
                        this.copyFile(file, packagePath, out);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Util.log(e, "Error in Script folder compilation participant");
            }
        }
        finally {
            this.compiledFiles = null;
        }
    }

    private IPath findPackagePath(IPath filePath, IContainer containingSourceFolder) {
        IPath containerPath = containingSourceFolder.getFullPath();
        filePath = filePath.removeFirstSegments(containerPath.segmentCount());
        filePath = filePath.removeLastSegments(1);
        return filePath;
    }

    private IContainer findContainingSourceFolder(Map<IContainer, IContainer> sourceToOut, IPath filePath) {
        Set<IContainer> sourceFolders = sourceToOut.keySet();
        for (IContainer container : sourceFolders) {
            if (!container.getFullPath().isPrefixOf(filePath)) continue;
            return container;
        }
        return null;
    }

    private void copyFile(IFile file, IPath packagePath, IContainer outputFolder) throws CoreException {
        IContainer createdFolder = this.createFolder(packagePath, outputFolder, true);
        IFile toFile = createdFolder.getFile(new Path(file.getName()));
        if (toFile.exists()) {
            toFile.delete(true, null);
        }
        file.copy(toFile.getFullPath(), true, null);
        ResourceAttributes newAttrs = new ResourceAttributes();
        newAttrs.setReadOnly(false);
        newAttrs.setHidden(false);
        toFile.setResourceAttributes(newAttrs);
        toFile.setDerived(true, null);
        toFile.refreshLocal(0, null);
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder, boolean derived) throws CoreException {
        if (!outputFolder.exists() && outputFolder instanceof IFolder) {
            ((IFolder)outputFolder).create(true, true, null);
        }
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder, derived);
            folder.create(true, true, null);
            folder.setDerived(derived, null);
            folder.refreshLocal(0, null);
        }
        return folder;
    }

    private Map<IContainer, IContainer> generateSourceToOut(IJavaProject project) throws JavaModelException {
        IProject p = project.getProject();
        IWorkspaceRoot root = (IWorkspaceRoot)p.getParent();
        IClasspathEntry[] cp = project.getRawClasspath();
        IPath defaultOutPath = project.getOutputLocation();
        IContainer defaultOutContainer = defaultOutPath.segmentCount() > 1 ? root.getFolder(defaultOutPath) : p;
        TreeMap<IContainer, IContainer> sourceToOut = new TreeMap<IContainer, IContainer>(comparator);
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outPath;
            IContainer outContainer;
            IPath sourcePath;
            IContainer sourceContainer;
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getEntryKind() == 3 && !(sourceContainer = (sourcePath = cpe.getPath()).segmentCount() > 1 ? root.getFolder(sourcePath) : p).equals(outContainer = (outPath = cpe.getOutputLocation()) == null ? defaultOutContainer : (outPath.segmentCount() > 1 ? root.getFolder(outPath) : p))) {
                sourceToOut.put(sourceContainer, outContainer);
            }
            ++n2;
        }
        return sourceToOut;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PathLengthComparator
    implements Comparator<IContainer> {
        PathLengthComparator() {
        }

        @Override
        public int compare(IContainer c1, IContainer c2) {
            int len2;
            if (c1 == null) {
                if (c2 == null) {
                    return 0;
                }
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            int len1 = c1.getFullPath().segmentCount();
            if (len1 > (len2 = c2.getFullPath().segmentCount())) {
                return -1;
            }
            if (len1 == len2) {
                return c1.toString().compareTo(c2.toString());
            }
            return 1;
        }
    }
}

