/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.antlr.LocationSupport;
import org.codehaus.groovy.antlr.NoEscaper;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;

public class SourceBuffer {
    private final List lines = new ArrayList();
    private StringBuffer current;
    private final List<Integer> lineEndings = new ArrayList<Integer>();
    private UnicodeEscapingReader unescaper;
    private boolean prevWasCarriageReturn = false;
    private int col = 0;

    public SourceBuffer() {
        this.lineEndings.add(0);
        this.unescaper = new NoEscaper();
        this.current = new StringBuffer();
        this.lines.add(this.current);
    }

    public String getSnippet(LineColumn start, LineColumn end) {
        if (start == null || end == null) {
            return null;
        }
        if (start.equals(end)) {
            return null;
        }
        if (this.lines.size() == 1 && this.current.length() == 0) {
            return null;
        }
        int startLine = start.getLine();
        int startColumn = start.getColumn();
        int endLine = end.getLine();
        int endColumn = end.getColumn();
        if (startLine < 1) {
            startLine = 1;
        }
        if (endLine < 1) {
            endLine = 1;
        }
        if (startColumn < 1) {
            startColumn = 1;
        }
        if (endColumn < 1) {
            endColumn = 1;
        }
        if (startLine > this.lines.size()) {
            startLine = this.lines.size();
        }
        if (endLine > this.lines.size()) {
            endLine = this.lines.size();
        }
        StringBuffer snippet = new StringBuffer();
        int i = startLine - 1;
        while (i < endLine) {
            String line = ((StringBuffer)this.lines.get(i)).toString();
            if (startLine == endLine) {
                if (startColumn > line.length()) {
                    startColumn = line.length();
                }
                if (startColumn < 1) {
                    startColumn = 1;
                }
                if (endColumn > line.length()) {
                    endColumn = line.length() + 1;
                }
                if (endColumn < 1) {
                    endColumn = 1;
                }
                line = line.substring(startColumn - 1, endColumn - 1);
            } else {
                if (i == startLine - 1 && startColumn - 1 < line.length()) {
                    line = line.substring(startColumn - 1);
                }
                if (i == endLine - 1 && endColumn - 1 < line.length()) {
                    line = line.substring(0, endColumn - 1);
                }
            }
            snippet.append(line);
            ++i;
        }
        return snippet.toString();
    }

    public void setUnescaper(UnicodeEscapingReader unicodeEscapingReader) {
        this.unescaper = unicodeEscapingReader;
    }

    public void write(int c) {
        if (c != -1) {
            ++this.col;
            this.current.append((char)c);
        }
        if (c == 10) {
            if (!this.prevWasCarriageReturn) {
                this.current = new StringBuffer();
                this.lines.add(this.current);
                this.lineEndings.add(this.col + this.unescaper.getUnescapedUnicodeOffsetCount());
            } else {
                this.current = new StringBuffer();
                ((StringBuffer)this.lines.get(this.lines.size() - 1)).append('\n');
                this.lineEndings.remove(this.lineEndings.size() - 1);
                this.lineEndings.add(this.col + this.unescaper.getUnescapedUnicodeOffsetCount());
            }
        }
        if (c == 13) {
            this.current = new StringBuffer();
            this.lines.add(this.current);
            this.lineEndings.add(this.col + this.unescaper.getUnescapedUnicodeOffsetCount());
            this.prevWasCarriageReturn = true;
        } else {
            this.prevWasCarriageReturn = false;
        }
    }

    public LocationSupport getLocationSupport() {
        this.lineEndings.add(this.col + this.unescaper.getUnescapedUnicodeOffsetCount());
        int[] lineEndingsArray = new int[this.lineEndings.size()];
        int i = 0;
        int max = this.lineEndings.size();
        while (i < max) {
            lineEndingsArray[i] = this.lineEndings.get(i);
            ++i;
        }
        return new LocationSupport(lineEndingsArray);
    }
}

