/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.memoize;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import org.apache.groovy.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;

public final class LRUCache
implements MemoizeCache<Object, Object> {
    private final Map<Object, Object> cache;

    public LRUCache(int maxCacheSize) {
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(maxCacheSize).build();
    }

    @Override
    public Object put(Object key, Object value) {
        return this.cache.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpNullReferences() {
        Map<Object, Object> map = this.cache;
        synchronized (map) {
            Iterator<Map.Entry<Object, Object>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Object value = entry.getValue();
                if (!(value instanceof SoftReference) || ((SoftReference)value).get() != null) continue;
                iterator.remove();
            }
        }
    }
}

