/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.control.SourceUnit;

public class GenericsVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit source;

    public GenericsVisitor(SourceUnit source) {
        this.source = source;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode node) {
        ClassNode[] interfaces;
        boolean error = this.checkWildcard(node);
        if (error) {
            return;
        }
        boolean isAnon = node instanceof InnerClassNode && ((InnerClassNode)node).isAnonymous();
        this.checkGenericsUsage(node.getUnresolvedSuperClass(false), node.getSuperClass(), isAnon ? Boolean.valueOf(true) : null);
        for (ClassNode anInterface : interfaces = node.getInterfaces()) {
            this.checkGenericsUsage(anInterface, anInterface.redirect());
        }
        node.visitContents(this);
    }

    @Override
    public void visitField(FieldNode node) {
        ClassNode type = node.getType();
        this.checkGenericsUsage(type, type.redirect());
        super.visitField(node);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        ClassNode type = call.getType();
        boolean isAnon = type instanceof InnerClassNode && ((InnerClassNode)type).isAnonymous();
        this.checkGenericsUsage(type, type.redirect(), isAnon);
    }

    @Override
    public void visitMethod(MethodNode node) {
        Parameter[] parameters;
        for (Parameter param : parameters = node.getParameters()) {
            ClassNode paramType = param.getType();
            this.checkGenericsUsage(paramType, paramType.redirect());
        }
        ClassNode returnType = node.getReturnType();
        this.checkGenericsUsage(returnType, returnType.redirect());
        super.visitMethod(node);
    }

    private boolean checkWildcard(ClassNode cn) {
        ClassNode sn = cn.getUnresolvedSuperClass(false);
        if (sn == null) {
            return false;
        }
        GenericsType[] generics = sn.getGenericsTypes();
        if (generics == null) {
            return false;
        }
        boolean error = false;
        for (GenericsType generic : generics) {
            if (!generic.isWildcard()) continue;
            this.addError("A supertype may not specify a wildcard type", sn);
            error = true;
        }
        return error;
    }

    private void checkGenericsUsage(ClassNode n, ClassNode cn) {
        this.checkGenericsUsage(n, cn, null);
    }

    private void checkGenericsUsage(ClassNode n, ClassNode cn, Boolean isAnonInnerClass) {
        if (n.isGenericsPlaceHolder()) {
            return;
        }
        GenericsType[] nTypes = n.getGenericsTypes();
        GenericsType[] cnTypes = cn.getGenericsTypes();
        if (nTypes == null) {
            return;
        }
        if (cnTypes == null) {
            String message = "The class " + GenericsVisitor.getPrintName(n) + " (supplied with " + this.plural("type parameter", nTypes.length) + ") refers to the class " + GenericsVisitor.getPrintName(cn) + " which takes no parameters";
            if (nTypes.length == 0) {
                message = message + " (invalid Diamond <> usage?)";
            }
            this.addError(message, n);
            return;
        }
        if (nTypes.length != cnTypes.length) {
            String message;
            if (Boolean.FALSE.equals(isAnonInnerClass) && nTypes.length == 0) {
                return;
            }
            if (Boolean.TRUE.equals(isAnonInnerClass) && nTypes.length == 0) {
                message = "Cannot use diamond <> with anonymous inner classes";
            } else {
                message = "The class " + GenericsVisitor.getPrintName(n) + " (supplied with " + this.plural("type parameter", nTypes.length) + ") refers to the class " + GenericsVisitor.getPrintName(cn) + " which takes " + this.plural("parameter", cnTypes.length);
                if (nTypes.length == 0) {
                    message = message + " (invalid Diamond <> usage?)";
                }
            }
            this.addError(message, n);
            return;
        }
        for (int i = 0; i < nTypes.length; ++i) {
            ClassNode cnType;
            ClassNode nType = nTypes[i].getType();
            if (nType.isDerivedFrom(cnType = cnTypes[i].getType()) || cnType.isInterface() && nType.implementsInterface(cnType)) continue;
            this.addError("The type " + nTypes[i].getName() + " is not a valid substitute for the bounded parameter <" + GenericsVisitor.getPrintName(cnTypes[i]) + ">", n);
        }
    }

    private String plural(String orig, int count) {
        return "" + count + " " + (count == 1 ? orig : orig + "s");
    }

    private static String getPrintName(GenericsType gt) {
        String ret = gt.getName();
        ClassNode[] upperBounds = gt.getUpperBounds();
        ClassNode lowerBound = gt.getLowerBound();
        if (upperBounds != null) {
            if (upperBounds.length != 1 || !"java.lang.Object".equals(GenericsVisitor.getPrintName(upperBounds[0]))) {
                ret = ret + " extends ";
                for (int i = 0; i < upperBounds.length; ++i) {
                    ret = ret + GenericsVisitor.getPrintName(upperBounds[i]);
                    if (i + 1 >= upperBounds.length) continue;
                    ret = ret + " & ";
                }
            }
        } else if (lowerBound != null) {
            ret = ret + " super " + GenericsVisitor.getPrintName(lowerBound);
        }
        return ret;
    }

    private static String getPrintName(ClassNode cn) {
        String ret = cn.getName();
        GenericsType[] gts = cn.getGenericsTypes();
        if (gts != null) {
            ret = ret + "<";
            for (int i = 0; i < gts.length; ++i) {
                if (i != 0) {
                    ret = ret + ",";
                }
                ret = ret + GenericsVisitor.getPrintName(gts[i]);
            }
            ret = ret + ">";
        }
        return ret;
    }
}

