/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.TupleConstructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TupleConstructorASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = TupleConstructor.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode LHMAP_TYPE = ClassHelper.makeWithoutCaching(LinkedHashMap.class, false);
    private static final ClassNode HMAP_TYPE = ClassHelper.makeWithoutCaching(HashMap.class, false);
    private static final ClassNode CHECK_METHOD_TYPE = ClassHelper.make(ImmutableASTTransformation.class);
    private static final Map<Class<?>, Expression> primitivesInitialValues;

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean includeProperties = !this.memberHasValue(anno, "includeProperties", false);
            boolean includeSuperFields = this.memberHasValue(anno, "includeSuperFields", true);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean callSuper = this.memberHasValue(anno, "callSuper", true);
            boolean force = this.memberHasValue(anno, "force", true);
            boolean defaults = !this.memberHasValue(anno, "defaults", false);
            boolean useSetters = this.memberHasValue(anno, "useSetters", true);
            List<String> excludes = TupleConstructorASTTransformation.getMemberStringList(anno, "excludes");
            List<String> includes = TupleConstructorASTTransformation.getMemberStringList(anno, "includes");
            boolean allNames = this.memberHasValue(anno, "allNames", true);
            if (!this.checkIncludeExcludeUndefinedAware(anno, excludes, includes, MY_TYPE_NAME)) {
                return;
            }
            if (!this.checkPropertyList(cNode, includes, "includes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, false, includeSuperFields)) {
                return;
            }
            if (!this.checkPropertyList(cNode, excludes, "excludes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, false, includeSuperFields)) {
                return;
            }
            if (this.hasAnnotation(cNode, ImmutableASTTransformation.MY_TYPE)) {
                return;
            }
            Expression pre = anno.getMember("pre");
            if (pre != null && !(pre instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'pre'. Found " + pre, cNode);
                return;
            }
            Expression post = anno.getMember("post");
            if (post != null && !(post instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'post'. Found " + post, cNode);
                return;
            }
            TupleConstructorASTTransformation.createConstructor(this, cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, callSuper, force, excludes, includes, useSetters, defaults, allNames, this.sourceUnit, (ClosureExpression)pre, (ClosureExpression)post);
            if (pre != null) {
                anno.setMember("pre", new ClosureExpression(new Parameter[0], new EmptyStatement()));
            }
            if (post != null) {
                anno.setMember("post", new ClosureExpression(new Parameter[0], new EmptyStatement()));
            }
        }
    }

    public static void createConstructor(ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, boolean callSuper, boolean force, List<String> excludes, List<String> includes, boolean useSetters) {
        TupleConstructorASTTransformation.createConstructor(null, cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, callSuper, force, excludes, includes, useSetters, true);
    }

    public static void createConstructor(AbstractASTTransformation xform, ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, boolean callSuper, boolean force, List<String> excludes, List<String> includes, boolean useSetters, boolean defaults) {
        TupleConstructorASTTransformation.createConstructor(xform, cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, callSuper, force, excludes, includes, useSetters, defaults, false);
    }

    public static void createConstructor(AbstractASTTransformation xform, ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, boolean callSuper, boolean force, List<String> excludes, List<String> includes, boolean useSetters, boolean defaults, boolean allNames) {
        TupleConstructorASTTransformation.createConstructor(xform, cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, callSuper, force, excludes, includes, useSetters, defaults, false, null, null, null);
    }

    public static void createConstructor(AbstractASTTransformation xform, ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, boolean callSuper, boolean force, List<String> excludes, final List<String> includes, boolean useSetters, boolean defaults, boolean allNames, SourceUnit sourceUnit, ClosureExpression pre, ClosureExpression post) {
        String name;
        if (!cNode.getDeclaredConstructors().isEmpty() && !force) {
            return;
        }
        ArrayList<FieldNode> superList = new ArrayList<FieldNode>();
        if (includeSuperProperties) {
            superList.addAll(GeneralUtils.getSuperPropertyFields(cNode.getSuperClass()));
        }
        if (includeSuperFields) {
            superList.addAll(GeneralUtils.getSuperNonPropertyFields(cNode.getSuperClass()));
        }
        ArrayList<FieldNode> list = new ArrayList<FieldNode>();
        if (includeProperties) {
            list.addAll(GeneralUtils.getInstancePropertyFields(cNode));
        }
        if (includeFields) {
            list.addAll(GeneralUtils.getInstanceNonPropertyFields(cNode));
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ArrayList<Expression> superParams = new ArrayList<Expression>();
        BlockStatement preBody = new BlockStatement();
        boolean superInPre = false;
        if (pre != null && (superInPre = GeneralUtils.copyStatementsWithSuperAdjustment(pre, preBody)) && callSuper) {
            xform.addError("Error during " + MY_TYPE_NAME + " processing, can't have a super call in 'pre' closure and also 'callSuper' enabled", cNode);
        }
        BlockStatement body = new BlockStatement();
        for (FieldNode fNode : superList) {
            boolean hasSetter;
            name = fNode.getName();
            if (TupleConstructorASTTransformation.shouldSkipUndefinedAware(name, excludes, includes, allNames)) continue;
            params.add(TupleConstructorASTTransformation.createParam(fNode, name, defaults, xform));
            boolean bl = hasSetter = cNode.getProperty(name) != null && !fNode.isFinal();
            if (callSuper) {
                superParams.add(GeneralUtils.varX(name));
                continue;
            }
            if (superInPre) continue;
            if (useSetters && hasSetter) {
                body.addStatement(GeneralUtils.stmt(GeneralUtils.callThisX(GeneralUtils.getSetterName(name), GeneralUtils.varX(name))));
                continue;
            }
            body.addStatement(GeneralUtils.assignS(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name), GeneralUtils.varX(name)));
        }
        if (callSuper) {
            body.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER, GeneralUtils.args(superParams))));
        }
        if (!preBody.isEmpty()) {
            body.addStatements(preBody.getStatements());
        }
        for (FieldNode fNode : list) {
            boolean hasSetter;
            name = fNode.getName();
            if (TupleConstructorASTTransformation.shouldSkipUndefinedAware(name, excludes, includes, allNames)) continue;
            Parameter nextParam = TupleConstructorASTTransformation.createParam(fNode, name, defaults, xform);
            params.add(nextParam);
            boolean bl = hasSetter = cNode.getProperty(name) != null && !fNode.isFinal();
            if (useSetters && hasSetter) {
                body.addStatement(GeneralUtils.stmt(GeneralUtils.callThisX(GeneralUtils.getSetterName(name), GeneralUtils.varX(nextParam))));
                continue;
            }
            body.addStatement(GeneralUtils.assignS(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name), GeneralUtils.varX(nextParam)));
        }
        if (post != null) {
            body.addStatement(post.getCode());
        }
        if (includes != null) {
            Comparator<Parameter> includeComparator = new Comparator<Parameter>(){

                @Override
                public int compare(Parameter p1, Parameter p2) {
                    return new Integer(includes.indexOf(p1.getName())).compareTo(includes.indexOf(p2.getName()));
                }
            };
            Collections.sort(params, includeComparator);
        }
        cNode.addConstructor(new ConstructorNode(1, params.toArray(new Parameter[params.size()]), ClassNode.EMPTY_ARRAY, body));
        if (sourceUnit != null && !body.isEmpty()) {
            VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(sourceUnit);
            scopeVisitor.visitClass(cNode);
        }
        if (!params.isEmpty() && defaults) {
            ClassNode firstParam = ((Parameter)params.get(0)).getType();
            if (params.size() > 1 || firstParam.equals(ClassHelper.OBJECT_TYPE)) {
                String message = "The class " + cNode.getName() + " was incorrectly initialized via the map constructor with null.";
                if (firstParam.equals(ClassHelper.MAP_TYPE)) {
                    TupleConstructorASTTransformation.addMapConstructors(cNode, true, message);
                } else {
                    for (ClassNode candidate = HMAP_TYPE; candidate != null; candidate = candidate.getSuperClass()) {
                        if (!candidate.equals(firstParam)) continue;
                        TupleConstructorASTTransformation.addMapConstructors(cNode, true, message);
                        break;
                    }
                }
            }
        }
    }

    private static Parameter createParam(FieldNode fNode, String name, boolean defaults, AbstractASTTransformation xform) {
        Parameter param = new Parameter(fNode.getType(), name);
        if (defaults) {
            param.setInitialExpression(TupleConstructorASTTransformation.providedOrDefaultInitialValue(fNode));
        } else if (fNode.getInitialExpression() != null) {
            xform.addError("Error during " + MY_TYPE_NAME + " processing, default value processing disabled but default value found for '" + fNode.getName() + "'", fNode);
        }
        return param;
    }

    private static Expression providedOrDefaultInitialValue(FieldNode fNode) {
        Expression initialExp = fNode.getInitialExpression() != null ? fNode.getInitialExpression() : ConstantExpression.NULL;
        ClassNode paramType = fNode.getType();
        if (ClassHelper.isPrimitiveType(paramType) && initialExp.equals(ConstantExpression.NULL)) {
            initialExp = primitivesInitialValues.get(paramType.getTypeClass());
        }
        return initialExp;
    }

    public static void addMapConstructors(ClassNode cNode, boolean hasNoArg, String message) {
        Parameter[] parameters = GeneralUtils.params(new Parameter(LHMAP_TYPE, "__namedArgs"));
        BlockStatement code = new BlockStatement();
        VariableExpression namedArgs = GeneralUtils.varX("__namedArgs");
        namedArgs.setAccessedVariable(parameters[0]);
        code.addStatement(GeneralUtils.ifElseS(GeneralUtils.equalsNullX(namedArgs), TupleConstructorASTTransformation.illegalArgumentBlock(message), TupleConstructorASTTransformation.processArgsBlock(cNode, namedArgs)));
        ConstructorNode init = new ConstructorNode(1, parameters, ClassNode.EMPTY_ARRAY, code);
        cNode.addConstructor(init);
        if (!hasNoArg) {
            code = new BlockStatement();
            code.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS, GeneralUtils.ctorX(LHMAP_TYPE))));
            init = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
            cNode.addConstructor(init);
        }
    }

    private static BlockStatement illegalArgumentBlock(String message) {
        return GeneralUtils.block(GeneralUtils.throwS(GeneralUtils.ctorX(ClassHelper.make(IllegalArgumentException.class), GeneralUtils.args(GeneralUtils.constX(message)))));
    }

    private static BlockStatement processArgsBlock(ClassNode cNode, VariableExpression namedArgs) {
        BlockStatement block = new BlockStatement();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            Statement ifStatement = GeneralUtils.ifS((Expression)GeneralUtils.callX((Expression)namedArgs, "containsKey", (Expression)GeneralUtils.constX(pNode.getName())), GeneralUtils.assignS(GeneralUtils.varX(pNode), GeneralUtils.propX((Expression)namedArgs, pNode.getName())));
            block.addStatement(ifStatement);
        }
        block.addStatement(GeneralUtils.stmt(GeneralUtils.callX(CHECK_METHOD_TYPE, "checkPropNames", (Expression)GeneralUtils.args(GeneralUtils.varX("this"), namedArgs))));
        return block;
    }

    static {
        ConstantExpression zero = GeneralUtils.constX(0);
        ConstantExpression zeroDecimal = GeneralUtils.constX(0.0);
        primitivesInitialValues = new HashMap();
        primitivesInitialValues.put(Integer.TYPE, zero);
        primitivesInitialValues.put(Long.TYPE, zero);
        primitivesInitialValues.put(Short.TYPE, zero);
        primitivesInitialValues.put(Byte.TYPE, zero);
        primitivesInitialValues.put(Character.TYPE, zero);
        primitivesInitialValues.put(Float.TYPE, zeroDecimal);
        primitivesInitialValues.put(Double.TYPE, zeroDecimal);
        primitivesInitialValues.put(Boolean.TYPE, ConstantExpression.FALSE);
    }
}

