/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.Lazy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class DelegateASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = Delegate.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode DEPRECATED_TYPE = ClassHelper.make(Deprecated.class);
    private static final ClassNode GROOVYOBJECT_TYPE = ClassHelper.make(GroovyObject.class);
    private static final ClassNode LAZY_TYPE = ClassHelper.make(Lazy.class);
    private static final String MEMBER_DEPRECATED = "deprecated";
    private static final String MEMBER_INTERFACES = "interfaces";
    private static final String MEMBER_INCLUDES = "includes";
    private static final String MEMBER_EXCLUDES = "excludes";
    private static final String MEMBER_INCLUDE_TYPES = "includeTypes";
    private static final String MEMBER_EXCLUDE_TYPES = "excludeTypes";
    private static final String MEMBER_PARAMETER_ANNOTATIONS = "parameterAnnotations";
    private static final String MEMBER_METHOD_ANNOTATIONS = "methodAnnotations";
    private static final String MEMBER_ALL_NAMES = "allNames";

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        DelegateDescription delegate = null;
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            delegate = new DelegateDescription();
            delegate.delegate = fieldNode;
            delegate.annotation = node;
            delegate.name = fieldNode.getName();
            delegate.type = fieldNode.getType();
            delegate.owner = fieldNode.getOwner();
            delegate.getOp = GeneralUtils.varX(fieldNode);
            delegate.origin = "field";
        } else if (parent instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)parent;
            delegate = new DelegateDescription();
            delegate.delegate = methodNode;
            delegate.annotation = node;
            delegate.name = methodNode.getName();
            delegate.type = methodNode.getReturnType();
            delegate.owner = methodNode.getDeclaringClass();
            delegate.getOp = GeneralUtils.callThisX(delegate.name);
            delegate.origin = "method";
            if (methodNode.getParameters().length > 0) {
                this.addError("You can only delegate to methods that take no parameters, but " + delegate.name + " takes " + methodNode.getParameters().length + " parameters.", parent);
                return;
            }
        }
        if (delegate != null) {
            if (delegate.type.equals(ClassHelper.OBJECT_TYPE) || delegate.type.equals(GROOVYOBJECT_TYPE)) {
                this.addError(MY_TYPE_NAME + " " + delegate.origin + " '" + delegate.name + "' has an inappropriate type: " + delegate.type.getName() + ". Please add an explicit type but not java.lang.Object or groovy.lang.GroovyObject.", parent);
                return;
            }
            if (delegate.type.equals(delegate.owner)) {
                this.addError(MY_TYPE_NAME + " " + delegate.origin + " '" + delegate.name + "' has an inappropriate type: " + delegate.type.getName() + ". Delegation to own type not supported. Please use a different type.", parent);
                return;
            }
            List<MethodNode> delegateMethods = GeneralUtils.getAllMethods(delegate.type);
            for (ClassNode next : delegate.type.getAllInterfaces()) {
                delegateMethods.addAll(GeneralUtils.getAllMethods(next));
            }
            boolean skipInterfaces = this.memberHasValue(node, MEMBER_INTERFACES, false);
            boolean includeDeprecated = this.memberHasValue(node, MEMBER_DEPRECATED, true) || delegate.type.isInterface() && !skipInterfaces;
            boolean allNames = this.memberHasValue(node, MEMBER_ALL_NAMES, true);
            delegate.excludes = DelegateASTTransformation.getMemberStringList(node, MEMBER_EXCLUDES);
            delegate.includes = DelegateASTTransformation.getMemberStringList(node, MEMBER_INCLUDES);
            delegate.excludeTypes = this.getMemberClassList(node, MEMBER_EXCLUDE_TYPES);
            delegate.includeTypes = this.getMemberClassList(node, MEMBER_INCLUDE_TYPES);
            this.checkIncludeExcludeUndefinedAware(node, delegate.excludes, delegate.includes, delegate.excludeTypes, delegate.includeTypes, MY_TYPE_NAME);
            List<MethodNode> ownerMethods = GeneralUtils.getAllMethods(delegate.owner);
            for (MethodNode mn : delegateMethods) {
                this.addDelegateMethod(delegate, ownerMethods, mn, includeDeprecated, allNames);
            }
            for (PropertyNode prop : GeneralUtils.getAllProperties(delegate.type)) {
                if (prop.isStatic() || !prop.isPublic()) continue;
                String name = prop.getName();
                DelegateASTTransformation.addGetterIfNeeded(delegate, prop, name, allNames);
                DelegateASTTransformation.addSetterIfNeeded(delegate, prop, name, allNames);
            }
            if (skipInterfaces) {
                return;
            }
            Set<ClassNode> allInterfaces = GeneralUtils.getInterfacesAndSuperInterfaces(delegate.type);
            Set<ClassNode> ownerIfaces = delegate.owner.getAllInterfaces();
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(delegate.owner);
            genericsSpec = GenericsUtils.createGenericsSpec(delegate.type, genericsSpec);
            for (ClassNode iface : allInterfaces) {
                if (!Modifier.isPublic(iface.getModifiers()) || ownerIfaces.contains(iface)) continue;
                ClassNode[] ifaces = delegate.owner.getInterfaces();
                ClassNode[] newIfaces = new ClassNode[ifaces.length + 1];
                for (int i = 0; i < ifaces.length; ++i) {
                    newIfaces[i] = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, ifaces[i]);
                }
                newIfaces[ifaces.length] = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, iface);
                delegate.owner.setInterfaces(newIfaces);
            }
        }
    }

    private static void addSetterIfNeeded(DelegateDescription delegate, PropertyNode prop, String name, boolean allNames) {
        String setterName = "set" + Verifier.capitalize(name);
        if ((prop.getModifiers() & 0x10) == 0 && delegate.owner.getSetterMethod(setterName) == null && !DelegateASTTransformation.shouldSkipPropertyMethod(name, setterName, delegate.excludes, delegate.includes, allNames)) {
            delegate.owner.addMethod(setterName, 1, ClassHelper.VOID_TYPE, GeneralUtils.params(new Parameter(GenericsUtils.nonGeneric(prop.getType()), "value")), null, GeneralUtils.assignS(GeneralUtils.propX(delegate.getOp, name), GeneralUtils.varX("value")));
        }
    }

    private static void addGetterIfNeeded(DelegateDescription delegate, PropertyNode prop, String name, boolean allNames) {
        boolean isPrimBool = prop.getOriginType().equals(ClassHelper.boolean_TYPE);
        boolean willHaveGetAccessor = true;
        boolean willHaveIsAccessor = isPrimBool;
        String suffix = Verifier.capitalize(name);
        if (isPrimBool) {
            ClassNode cNode = prop.getDeclaringClass();
            if (cNode.getGetterMethod("is" + suffix) != null && cNode.getGetterMethod("get" + suffix) == null) {
                willHaveGetAccessor = false;
            }
            if (cNode.getGetterMethod("get" + suffix) != null && cNode.getGetterMethod("is" + suffix) == null) {
                willHaveIsAccessor = false;
            }
        }
        for (String prefix : new String[]{"get", "is"}) {
            String getterName = prefix + suffix;
            if (delegate.owner.getGetterMethod(getterName) != null || DelegateASTTransformation.shouldSkipPropertyMethod(name, getterName, delegate.excludes, delegate.includes, allNames) || (!prefix.equals("get") || !willHaveGetAccessor) && (!prefix.equals("is") || !willHaveIsAccessor)) continue;
            delegate.owner.addMethod(getterName, 1, GenericsUtils.nonGeneric(prop.getType()), Parameter.EMPTY_ARRAY, null, GeneralUtils.returnS(GeneralUtils.propX(delegate.getOp, name)));
        }
    }

    private static boolean shouldSkipPropertyMethod(String propertyName, String methodName, List<String> excludes, List<String> includes, boolean allNames) {
        return !allNames && DelegateASTTransformation.deemedInternalName(propertyName) || excludes != null && (excludes.contains(propertyName) || excludes.contains(methodName)) || includes != null && !includes.isEmpty() && !includes.contains(propertyName) && !includes.contains(methodName);
    }

    private void addDelegateMethod(DelegateDescription delegate, List<MethodNode> ownMethods, MethodNode candidate, boolean includeDeprecated, boolean allNames) {
        if (!candidate.isPublic() || candidate.isStatic() || 0 != (candidate.getModifiers() & 0x1000)) {
            return;
        }
        if (!candidate.getAnnotations(DEPRECATED_TYPE).isEmpty() && !includeDeprecated) {
            return;
        }
        if (DelegateASTTransformation.shouldSkip(candidate.getName(), delegate.excludes, delegate.includes, allNames)) {
            return;
        }
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(delegate.owner);
        genericsSpec = GenericsUtils.addMethodGenerics(candidate, genericsSpec);
        GenericsUtils.extractSuperClassGenerics(delegate.type, candidate.getDeclaringClass(), genericsSpec);
        if (delegate.excludeTypes != null && !delegate.excludeTypes.isEmpty() || delegate.includeTypes != null) {
            Iterator<MethodNode> correctedMethodNode = GenericsUtils.correctToGenericsSpec(genericsSpec, candidate);
            boolean checkReturn = delegate.type.getMethods().contains(candidate);
            if (DelegateASTTransformation.shouldSkipOnDescriptorUndefinedAware(checkReturn, genericsSpec, correctedMethodNode, delegate.excludeTypes, delegate.includeTypes)) {
                return;
            }
        }
        for (MethodNode mn : GROOVYOBJECT_TYPE.getMethods()) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor())) continue;
            return;
        }
        for (MethodNode mn : delegate.owner.getMethods()) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor())) continue;
            return;
        }
        MethodNode existingNode = null;
        for (MethodNode mn : ownMethods) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor()) || mn.isAbstract() || mn.isStatic()) continue;
            existingNode = mn;
            break;
        }
        if (existingNode == null || existingNode.getCode() == null) {
            ArgumentListExpression args = new ArgumentListExpression();
            Parameter[] params = candidate.getParameters();
            Parameter[] newParams = new Parameter[params.length];
            List<String> currentMethodGenPlaceholders = DelegateASTTransformation.genericPlaceholderNames(candidate);
            for (int i = 0; i < newParams.length; ++i) {
                ClassNode newParamType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, params[i].getType(), currentMethodGenPlaceholders);
                Parameter newParam = new Parameter(newParamType, DelegateASTTransformation.getParamName(params, i, delegate.name));
                newParam.setInitialExpression(params[i].getInitialExpression());
                if (this.memberHasValue(delegate.annotation, MEMBER_PARAMETER_ANNOTATIONS, true)) {
                    newParam.addAnnotations(this.copyAnnotatedNodeAnnotations(params[i], MY_TYPE_NAME));
                }
                newParams[i] = newParam;
                args.addExpression(GeneralUtils.varX(newParam));
            }
            boolean alsoLazy = !delegate.delegate.getAnnotations(LAZY_TYPE).isEmpty();
            MethodCallExpression mce = GeneralUtils.callX(alsoLazy ? GeneralUtils.propX((Expression)GeneralUtils.varX("this"), delegate.name.substring(1)) : delegate.getOp, candidate.getName(), (Expression)args);
            mce.setSourcePosition(delegate.delegate);
            ClassNode returnType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, candidate.getReturnType(), currentMethodGenPlaceholders);
            MethodNode newMethod = delegate.owner.addMethod(candidate.getName(), candidate.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, returnType, newParams, candidate.getExceptions(), GeneralUtils.stmt(mce));
            newMethod.setGenericsTypes(candidate.getGenericsTypes());
            if (this.memberHasValue(delegate.annotation, MEMBER_METHOD_ANNOTATIONS, true)) {
                newMethod.addAnnotations(this.copyAnnotatedNodeAnnotations(candidate, MY_TYPE_NAME));
            }
        }
    }

    private static List<String> genericPlaceholderNames(MethodNode candidate) {
        GenericsType[] candidateGenericsTypes = candidate.getGenericsTypes();
        ArrayList<String> names = new ArrayList<String>();
        if (candidateGenericsTypes != null) {
            for (GenericsType gt : candidateGenericsTypes) {
                names.add(gt.getName());
            }
        }
        return names;
    }

    private static String getParamName(Parameter[] params, int i, String fieldName) {
        String name = params[i].getName();
        while (name.equals(fieldName) || DelegateASTTransformation.clashesWithOtherParams(name, params, i)) {
            name = "_" + name;
        }
        return name;
    }

    private static boolean clashesWithOtherParams(String name, Parameter[] params, int i) {
        for (int j = 0; j < params.length; ++j) {
            if (i == j || !params[j].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    static class DelegateDescription {
        AnnotationNode annotation;
        AnnotatedNode delegate;
        String name;
        ClassNode type;
        ClassNode owner;
        Expression getOp;
        String origin;
        List<String> includes;
        List<String> excludes;
        List<ClassNode> includeTypes;
        List<ClassNode> excludeTypes;

        DelegateDescription() {
        }
    }
}

