/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

public class FinalVariableAnalyzer
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;
    private final VariableNotFinalCallback callback;
    private Set<VariableExpression> declaredFinalVariables = null;
    private boolean inAssignment = false;
    private final Deque<Map<Variable, VariableState>> assignmentTracker = new LinkedList<Map<Variable, VariableState>>();

    public FinalVariableAnalyzer(SourceUnit sourceUnit) {
        this(sourceUnit, null);
    }

    public FinalVariableAnalyzer(SourceUnit sourceUnit, VariableNotFinalCallback callback) {
        this.callback = callback;
        this.sourceUnit = sourceUnit;
        this.pushState();
    }

    private Map<Variable, VariableState> pushState() {
        StateMap state = new StateMap();
        this.assignmentTracker.add(state);
        return state;
    }

    private static Variable getTarget(Variable v) {
        if (v instanceof VariableExpression) {
            Variable t = ((VariableExpression)v).getAccessedVariable();
            if (t == v) {
                return t;
            }
            return FinalVariableAnalyzer.getTarget(t);
        }
        return v;
    }

    private Map<Variable, VariableState> popState() {
        return this.assignmentTracker.removeLast();
    }

    private Map<Variable, VariableState> getState() {
        return this.assignmentTracker.getLast();
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public boolean isEffectivelyFinal(Variable v) {
        VariableState state = this.getState().get(v);
        return v instanceof Parameter && state == null || state != null && state.isFinal();
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        Set<VariableExpression> old = this.declaredFinalVariables;
        this.declaredFinalVariables = new HashSet<VariableExpression>();
        super.visitBlockStatement(block);
        if (this.callback != null) {
            Map<Variable, VariableState> state = this.getState();
            for (VariableExpression declaredFinalVariable : this.declaredFinalVariables) {
                VariableState variableState = state.get(declaredFinalVariable.getAccessedVariable());
                if (variableState != null && variableState == VariableState.is_final) continue;
                this.callback.variableNotAlwaysInitialized(declaredFinalVariable);
            }
        }
        this.declaredFinalVariables = old;
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        VariableExpression var;
        boolean assignment = StaticTypeCheckingSupport.isAssignment(expression.getOperation().getType());
        boolean isDeclaration = expression instanceof DeclarationExpression;
        Expression leftExpression = expression.getLeftExpression();
        Expression rightExpression = expression.getRightExpression();
        if (isDeclaration && leftExpression instanceof VariableExpression && Modifier.isFinal((var = (VariableExpression)leftExpression).getModifiers())) {
            this.declaredFinalVariables.add(var);
        }
        leftExpression.visit(this);
        this.inAssignment = assignment;
        rightExpression.visit(this);
        this.inAssignment = false;
        if (assignment) {
            if (leftExpression instanceof Variable) {
                boolean uninitialized = isDeclaration && rightExpression == EmptyExpression.INSTANCE;
                this.recordAssignment((Variable)((Object)leftExpression), isDeclaration, uninitialized, false, expression);
            } else if (leftExpression instanceof TupleExpression) {
                TupleExpression te = (TupleExpression)leftExpression;
                for (Expression next : te.getExpressions()) {
                    if (!(next instanceof Variable)) continue;
                    this.recordAssignment((Variable)((Object)next), isDeclaration, false, false, next);
                }
            }
        }
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        boolean old = this.inAssignment;
        this.inAssignment = false;
        super.visitClosureExpression(expression);
        this.inAssignment = old;
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        this.inAssignment = expression.getExpression() instanceof VariableExpression;
        super.visitPrefixExpression(expression);
        this.inAssignment = false;
        this.checkPrePostfixOperation(expression.getExpression(), expression);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        this.inAssignment = expression.getExpression() instanceof VariableExpression;
        super.visitPostfixExpression(expression);
        this.inAssignment = false;
        this.checkPrePostfixOperation(expression.getExpression(), expression);
    }

    private void checkPrePostfixOperation(Expression variable, Expression originalExpression) {
        if (variable instanceof Variable) {
            Variable accessed;
            this.recordAssignment((Variable)((Object)variable), false, false, true, originalExpression);
            if (variable instanceof VariableExpression && (accessed = ((VariableExpression)variable).getAccessedVariable()) != variable) {
                this.recordAssignment(accessed, false, false, true, originalExpression);
            }
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        Variable key;
        Map<Variable, VariableState> state;
        VariableState variableState;
        super.visitVariableExpression(expression);
        if (this.inAssignment && (variableState = (state = this.getState()).get(key = expression.getAccessedVariable())) == VariableState.is_uninitialized) {
            variableState = VariableState.is_var;
            state.put(key, variableState);
        }
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        this.visitStatement(ifElse);
        ifElse.getBooleanExpression().visit(this);
        Map<Variable, VariableState> ifState = this.pushState();
        ifElse.getIfBlock().visit(this);
        this.popState();
        Statement elseBlock = ifElse.getElseBlock();
        Map<Variable, VariableState> elseState = this.pushState();
        if (elseBlock instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)elseBlock);
        } else {
            elseBlock.visit(this);
        }
        this.popState();
        Map<Variable, VariableState> curState = this.getState();
        HashSet<Variable> allVars = new HashSet<Variable>();
        allVars.addAll(curState.keySet());
        allVars.addAll(ifState.keySet());
        allVars.addAll(elseState.keySet());
        for (Variable var : allVars) {
            VariableState mergedIfElse;
            VariableState beforeValue = curState.get(var);
            VariableState ifValue = ifState.get(var);
            VariableState elseValue = elseState.get(var);
            VariableState variableState = mergedIfElse = ifValue != null && elseValue != null && ifValue.isFinal && elseValue.isFinal ? VariableState.is_final : VariableState.is_var;
            if (beforeValue == null) {
                curState.put(var, mergedIfElse);
                continue;
            }
            if (beforeValue == VariableState.is_uninitialized) {
                curState.put(var, mergedIfElse);
                continue;
            }
            if (ifValue == null && elseValue == null) continue;
            curState.put(var, VariableState.is_var);
        }
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.visitStatement(statement);
        HashMap<Variable, VariableState> beforeTryCatch = new HashMap<Variable, VariableState>(this.getState());
        statement.getTryStatement().visit(this);
        for (CatchStatement catchStatement : statement.getCatchStatements()) {
            catchStatement.visit(this);
        }
        Statement finallyStatement = statement.getFinallyStatement();
        HashMap<Variable, VariableState> afterTryCatchState = new HashMap<Variable, VariableState>(this.getState());
        if (finallyStatement instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)finallyStatement);
        } else {
            finallyStatement.visit(this);
        }
        HashMap<Variable, VariableState> afterFinally = new HashMap<Variable, VariableState>(this.getState());
        for (Map.Entry entry : afterFinally.entrySet()) {
            Variable var = (Variable)entry.getKey();
            VariableState afterFinallyState = (VariableState)((Object)entry.getValue());
            VariableState beforeTryCatchState = (VariableState)((Object)beforeTryCatch.get(var));
            if (afterFinallyState != VariableState.is_final || beforeTryCatchState == VariableState.is_final || afterTryCatchState.get(var) == beforeTryCatchState) continue;
            this.getState().put(var, beforeTryCatchState == null ? VariableState.is_uninitialized : beforeTryCatchState);
        }
    }

    private void recordAssignment(Variable var, boolean isDeclaration, boolean uninitialized, boolean forceVariable, Expression expression) {
        VariableState variableState;
        if (var == null) {
            return;
        }
        if (!isDeclaration && var.isClosureSharedVariable()) {
            this.getState().put(var, VariableState.is_var);
        }
        if ((variableState = this.getState().get(var)) == null) {
            VariableState variableState2 = variableState = uninitialized ? VariableState.is_uninitialized : VariableState.is_final;
            if (FinalVariableAnalyzer.getTarget(var) instanceof Parameter) {
                variableState = VariableState.is_var;
            }
        } else {
            variableState = variableState.getNext();
        }
        if (forceVariable) {
            variableState = VariableState.is_var;
        }
        this.getState().put(var, variableState);
        if (variableState == VariableState.is_var && this.callback != null) {
            this.callback.variableNotFinal(var, expression);
        }
    }

    private static class StateMap
    extends HashMap<Variable, VariableState> {
        private StateMap() {
        }

        @Override
        public VariableState get(Object key) {
            return (VariableState)((Object)super.get(FinalVariableAnalyzer.getTarget((Variable)key)));
        }

        @Override
        public VariableState put(Variable key, VariableState value) {
            return super.put(FinalVariableAnalyzer.getTarget(key), value);
        }
    }

    public static interface VariableNotFinalCallback {
        public void variableNotFinal(Variable var1, Expression var2);

        public void variableNotAlwaysInitialized(VariableExpression var1);
    }

    private static enum VariableState {
        is_uninitialized(false),
        is_final(true),
        is_var(false);

        private final boolean isFinal;

        private VariableState(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public VariableState getNext() {
            switch (this) {
                case is_uninitialized: {
                    return is_final;
                }
            }
            return is_var;
        }

        public boolean isFinal() {
            return this.isFinal;
        }
    }
}

