/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import groovyjarjarantlr.CharScanner;
import groovyjarjarantlr.Token;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.antlr.java.JavaLexer;
import org.codehaus.groovy.antlr.java.JavaTokenTypes;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class LexerFrame
extends JFrame
implements ActionListener {
    private final JSplitPane jSplitPane1 = new JSplitPane();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JScrollPane jScrollPane2 = new JScrollPane();
    private final JTextPane tokenPane = new HScrollableTextPane();
    private final JButton jbutton = new JButton("open");
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final JTextArea scriptPane = new JTextArea();
    private final Class lexerClass;
    private final Hashtable tokens = new Hashtable();
    private final Action loadFileAction = new AbstractAction("Open File..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser jfc = new JFileChooser();
            int response = jfc.showOpenDialog(LexerFrame.this);
            if (response != 0) {
                return;
            }
            LexerFrame.this.safeScanScript(jfc.getSelectedFile());
        }
    };

    public LexerFrame(Class lexerClass, Class tokenTypesClass) {
        this(lexerClass, tokenTypesClass, null);
    }

    public LexerFrame(Class lexerClass, Class tokenTypesClass, Reader reader) {
        super("Token Steam Viewer");
        this.lexerClass = lexerClass;
        try {
            this.jbInit(reader);
            this.setSize(500, 500);
            this.listTokens(tokenTypesClass);
            if (reader == null) {
                final JPopupMenu popup = new JPopupMenu();
                popup.add(this.loadFileAction);
                this.jbutton.setSize(30, 30);
                this.jbutton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        popup.show(LexerFrame.this.scriptPane, e.getX(), e.getY());
                    }
                });
            } else {
                this.safeScanScript(reader);
            }
            this.setDefaultCloseOperation(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LexerFrame groovyScriptFactory(String scriptText) {
        return new LexerFrame(GroovyLexer.class, GroovyTokenTypes.class, new StringReader(scriptText));
    }

    private void listTokens(Class tokenTypes) throws Exception {
        for (Field field : tokenTypes.getDeclaredFields()) {
            this.tokens.put(field.get(null), field.getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Token token = (Token)((JComponent)ae.getSource()).getClientProperty("token");
        if (token.getType() == 1) {
            this.scriptPane.select(0, 0);
            return;
        }
        try {
            int start = this.scriptPane.getLineStartOffset(token.getLine() - 1) + token.getColumn() - 1;
            this.scriptPane.select(start, start + token.getText().length());
            this.scriptPane.requestFocus();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void safeScanScript(File file) {
        try {
            this.scanScript(new StringReader(ResourceGroovyMethods.getText(file)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void safeScanScript(Reader reader) {
        try {
            this.scanScript(reader instanceof StringReader ? (StringReader)reader : new StringReader(IOGroovyMethods.getText(reader)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void scanScript(StringReader reader) throws Exception {
        Token token;
        this.scriptPane.read(reader, null);
        reader.reset();
        Constructor constructor = this.lexerClass.getConstructor(Reader.class);
        CharScanner lexer = (CharScanner)constructor.newInstance(reader);
        this.tokenPane.setEditable(true);
        this.tokenPane.setText("");
        int line = 1;
        ButtonGroup bg = new ButtonGroup();
        do {
            token = lexer.nextToken();
            JToggleButton tokenButton = new JToggleButton((String)this.tokens.get(token.getType()));
            bg.add(tokenButton);
            tokenButton.addActionListener(this);
            tokenButton.setToolTipText(token.getText());
            tokenButton.putClientProperty("token", token);
            tokenButton.setMargin(new Insets(0, 1, 0, 1));
            tokenButton.setFocusPainted(false);
            if (token.getLine() > line) {
                this.tokenPane.getDocument().insertString(this.tokenPane.getDocument().getLength(), "\n", null);
                line = token.getLine();
            }
            this.insertComponent(tokenButton);
        } while (token.getType() != 1);
        this.tokenPane.setEditable(false);
        this.tokenPane.setCaretPosition(0);
        reader.close();
    }

    private void insertComponent(JComponent comp) {
        try {
            this.tokenPane.getDocument().insertString(this.tokenPane.getDocument().getLength(), " ", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.tokenPane.setCaretPosition(this.tokenPane.getDocument().getLength() - 1);
        }
        catch (Exception ex) {
            this.tokenPane.setCaretPosition(0);
        }
        this.tokenPane.insertComponent(comp);
    }

    private void jbInit(Reader reader) throws Exception {
        Border border = BorderFactory.createEmptyBorder();
        this.jSplitPane1.setOrientation(0);
        this.tokenPane.setEditable(false);
        this.tokenPane.setText("");
        this.scriptPane.setFont(new Font("DialogInput", 0, 12));
        this.scriptPane.setEditable(false);
        this.scriptPane.setMargin(new Insets(5, 5, 5, 5));
        this.scriptPane.setText("");
        this.jScrollPane1.setBorder(border);
        this.jScrollPane2.setBorder(border);
        this.jSplitPane1.setMinimumSize(new Dimension(800, 600));
        this.mainPanel.add((Component)this.jSplitPane1, "Center");
        if (reader == null) {
            this.mainPanel.add((Component)this.jbutton, "North");
        }
        this.getContentPane().add(this.mainPanel);
        this.jSplitPane1.add((Component)this.jScrollPane1, "left");
        this.jScrollPane1.getViewport().add((Component)this.tokenPane, null);
        this.jSplitPane1.add((Component)this.jScrollPane2, "right");
        this.jScrollPane2.getViewport().add((Component)this.scriptPane, null);
        this.jScrollPane1.setColumnHeaderView(new JLabel(" Token Stream:"));
        this.jScrollPane2.setColumnHeaderView(new JLabel(" Input Script:"));
        this.jSplitPane1.setResizeWeight(0.5);
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        LexerFrame lexerFrame = null;
        if (args.length == 0) {
            lexerFrame = new LexerFrame(GroovyLexer.class, GroovyTokenTypes.class);
        } else if (args.length > 1) {
            System.err.println("usage: java LexerFrame [filename.ext]");
            System.exit(1);
        } else {
            String filename = args[0];
            lexerFrame = filename.endsWith(".java") ? new LexerFrame(JavaLexer.class, JavaTokenTypes.class, new FileReader(filename)) : new LexerFrame(GroovyLexer.class, GroovyTokenTypes.class, new FileReader(filename));
        }
        lexerFrame.setVisible(true);
    }

    private static class HScrollableTextPane
    extends JTextPane {
        private HScrollableTextPane() {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getSize().width < this.getParent().getSize().width;
        }

        @Override
        public void setSize(Dimension d) {
            if (d.width < this.getParent().getSize().width) {
                d.width = this.getParent().getSize().width;
            }
            super.setSize(d);
        }
    }
}

