/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.transform.stc.AbstractTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.trait.Traits;

public class TraitTypeCheckingExtension
extends AbstractTypeCheckingExtension {
    private static final List<MethodNode> NOTFOUND = Collections.emptyList();

    public TraitTypeCheckingExtension(StaticTypeCheckingVisitor typeCheckingVisitor) {
        super(typeCheckingVisitor);
    }

    @Override
    public void setup() {
    }

    @Override
    public List<MethodNode> handleMissingMethod(ClassNode receiver, String name, ArgumentListExpression argumentList, ClassNode[] argumentTypes, MethodCall call) {
        ClassNode firstArgType;
        String nameWithoutPrefix = Traits.getNameWithoutSuperTrait(name);
        if (nameWithoutPrefix != null && argumentTypes.length > 0 && ClassHelper.CLASS_Type.equals(firstArgType = argumentTypes[0]) && StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(firstArgType)) {
            return this.convertToDynamicCall(call, receiver, nameWithoutPrefix, argumentTypes);
        }
        return NOTFOUND;
    }

    private List<MethodNode> convertToDynamicCall(MethodCall call, ClassNode receiver, String name, ClassNode[] argumentTypes) {
        LinkedHashSet<ClassNode> traitsAsList = Traits.collectAllInterfacesReverseOrder(receiver, new LinkedHashSet<ClassNode>());
        ClassNode[] implementedTraits = traitsAsList.toArray(new ClassNode[traitsAsList.size()]);
        ClassNode currentTrait = argumentTypes[0].getGenericsTypes()[0].getType();
        ClassNode nextTrait = null;
        for (int i = 0; i < implementedTraits.length - 1; ++i) {
            ClassNode implementedTrait = implementedTraits[i];
            if (!implementedTrait.equals(currentTrait)) continue;
            nextTrait = implementedTraits[i + 1];
        }
        ClassNode[] newArgs = new ClassNode[argumentTypes.length - 1];
        System.arraycopy(argumentTypes, 1, newArgs, 0, newArgs.length);
        ClassNode inferredReturnType = this.inferTraitMethodReturnType(nextTrait, name, newArgs);
        return Arrays.asList(this.makeDynamic(call, inferredReturnType));
    }

    private ClassNode inferTraitMethodReturnType(ClassNode nextTrait, String methodName, ClassNode[] paramTypes) {
        List<MethodNode> candidates;
        ClassNode result = ClassHelper.OBJECT_TYPE;
        if (nextTrait != null && (candidates = this.typeCheckingVisitor.findMethod(nextTrait, methodName, paramTypes)).size() == 1) {
            result = candidates.get(0).getReturnType();
        }
        return result;
    }
}

