/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.BuilderASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

public class InitializerStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;

    @Override
    public void build(BuilderASTTransformation transform, ClassNode buildee, AnnotationNode anno) {
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        if (!this.getIncludeExclude(transform, anno, buildee, excludes, includes)) {
            return;
        }
        String prefix = transform.getMemberStringValue(anno, "prefix", "");
        if (this.unsupportedAttribute(transform, anno, "forClass")) {
            return;
        }
        String builderClassName = transform.getMemberStringValue(anno, "builderClassName", buildee.getName() + "Initializer");
        String buildMethodName = transform.getMemberStringValue(anno, "buildMethodName", "create");
        List<FieldNode> fields = GeneralUtils.getInstancePropertyFields(buildee);
        List<FieldNode> filteredFields = InitializerStrategy.selectFieldsFromExistingClass(fields, includes, excludes);
        int numFields = filteredFields.size();
        ClassNode builder = this.createInnerHelperClass(buildee, builderClassName, filteredFields);
        InitializerStrategy.createBuilderConstructors(builder, filteredFields);
        InitializerStrategy.createBuildeeConstructors(transform, buildee, builder, filteredFields);
        buildee.getModule().addClass(builder);
        buildee.addMethod(InitializerStrategy.createBuilderMethod(transform, anno, buildMethodName, builder, numFields));
        for (int i = 0; i < numFields; ++i) {
            builder.addField(InitializerStrategy.createFieldCopy(buildee, filteredFields.get(i)));
            builder.addMethod(this.createBuilderMethodForField(builder, filteredFields, prefix, i));
        }
        builder.addMethod(InitializerStrategy.createBuildMethod(builder, buildMethodName, filteredFields));
    }

    private ClassNode createInnerHelperClass(ClassNode buildee, String builderClassName, List<FieldNode> fields) {
        String fullName = buildee.getName() + "$" + builderClassName;
        int visibility = 4105;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 4105, ClassHelper.OBJECT_TYPE);
        GenericsType[] gtypes = new GenericsType[fields.size()];
        for (int i = 0; i < gtypes.length; ++i) {
            gtypes[i] = this.makePlaceholder(i);
        }
        builder.setGenericsTypes(gtypes);
        return builder;
    }

    private static MethodNode createBuilderMethod(BuilderASTTransformation transform, AnnotationNode anno, String buildMethodName, ClassNode builder, int numFields) {
        String builderMethodName = transform.getMemberStringValue(anno, "builderMethodName", "createInitializer");
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.returnS(GeneralUtils.callX(builder, buildMethodName)));
        int visibility = 4105;
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.unsetGenTypes(numFields));
        return new MethodNode(builderMethodName, 4105, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static GenericsType[] unsetGenTypes(int numFields) {
        GenericsType[] gtypes = new GenericsType[numFields];
        for (int i = 0; i < gtypes.length; ++i) {
            gtypes[i] = new GenericsType(ClassHelper.make(UNSET.class));
        }
        return gtypes;
    }

    private static GenericsType[] setGenTypes(int numFields) {
        GenericsType[] gtypes = new GenericsType[numFields];
        for (int i = 0; i < gtypes.length; ++i) {
            gtypes[i] = new GenericsType(ClassHelper.make(SET.class));
        }
        return gtypes;
    }

    private static void createBuilderConstructors(ClassNode builder, List<FieldNode> fields) {
        builder.addConstructor(2, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.ctorSuperS()));
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.ctorSuperS());
        InitializerStrategy.initializeFields(fields, body);
        builder.addConstructor(2, InitializerStrategy.getParams(fields), BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static void createBuildeeConstructors(BuilderASTTransformation transform, ClassNode buildee, ClassNode builder, List<FieldNode> fields) {
        ClassNode paramType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.setGenTypes(fields.size()));
        ArrayList<Expression> argsList = new ArrayList<Expression>();
        for (FieldNode fieldNode : fields) {
            argsList.add(GeneralUtils.propX((Expression)GeneralUtils.varX("initializer"), fieldNode.getName()));
        }
        ArgumentListExpression args = new ArgumentListExpression(argsList);
        buildee.addConstructor(4097, GeneralUtils.params(GeneralUtils.param(paramType, "initializer")), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.ctorThisS(args)));
        if (!transform.hasAnnotation(buildee, ImmutableASTTransformation.MY_TYPE)) {
            BlockStatement body = new BlockStatement();
            body.addStatement(GeneralUtils.ctorSuperS());
            InitializerStrategy.initializeFields(fields, body);
            buildee.addConstructor(4098, InitializerStrategy.getParams(fields), BuilderASTTransformation.NO_EXCEPTIONS, body);
        }
    }

    private static Parameter[] getParams(List<FieldNode> fields) {
        Parameter[] parameters = new Parameter[fields.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new Parameter(GenericsUtils.newClass(fields.get(i).getType()), fields.get(i).getName());
        }
        return parameters;
    }

    private static MethodNode createBuildMethod(ClassNode builder, String buildMethodName, List<FieldNode> fields) {
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.unsetGenTypes(fields.size()));
        return new MethodNode(buildMethodName, 9, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.ctorX(returnType))));
    }

    private MethodNode createBuilderMethodForField(ClassNode builder, List<FieldNode> fields, String prefix, int fieldPos) {
        String fieldName = fields.get(fieldPos).getName();
        String setterName = this.getSetterName(prefix, fieldName);
        GenericsType[] gtypes = new GenericsType[fields.size()];
        ArrayList<Expression> argList = new ArrayList<Expression>();
        for (int i = 0; i < fields.size(); ++i) {
            gtypes[i] = i == fieldPos ? new GenericsType(ClassHelper.make(SET.class)) : this.makePlaceholder(i);
            argList.add(i == fieldPos ? GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)) : GeneralUtils.varX(fields.get(i).getName()));
        }
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, gtypes);
        return new MethodNode(setterName, 1, returnType, GeneralUtils.params(GeneralUtils.param(fields.get(fieldPos).getType(), fieldName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)), GeneralUtils.varX(fieldName))), GeneralUtils.returnS(GeneralUtils.ctorX(returnType, GeneralUtils.args(argList)))));
    }

    private GenericsType makePlaceholder(int i) {
        ClassNode type = ClassHelper.makeWithoutCaching("T" + i);
        type.setRedirect(ClassHelper.OBJECT_TYPE);
        type.setGenericsPlaceHolder(true);
        return new GenericsType(type);
    }

    private static FieldNode createFieldCopy(ClassNode buildee, FieldNode fNode) {
        return new FieldNode(fNode.getName(), fNode.getModifiers(), ClassHelper.make(fNode.getType().getName()), buildee, DEFAULT_INITIAL_VALUE);
    }

    private static List<FieldNode> selectFieldsFromExistingClass(List<FieldNode> fieldNodes, List<String> includes, List<String> excludes) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (FieldNode fNode : fieldNodes) {
            if (AbstractASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
            fields.add(fNode);
        }
        return fields;
    }

    private static void initializeFields(List<FieldNode> fields, BlockStatement body) {
        for (FieldNode field : fields) {
            body.addStatement(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), field.getName()), GeneralUtils.varX(field))));
        }
    }

    public static abstract class UNSET {
    }

    public static abstract class SET {
    }
}

