/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoClone;
import groovy.transform.AutoCloneStyle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class AutoCloneASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = AutoClone.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode CLONEABLE_TYPE = ClassHelper.make(Cloneable.class);
    private static final ClassNode BAOS_TYPE = ClassHelper.make(ByteArrayOutputStream.class);
    private static final ClassNode BAIS_TYPE = ClassHelper.make(ByteArrayInputStream.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            cNode.addInterface(CLONEABLE_TYPE);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            AutoCloneStyle style = this.getStyle(anno, "style");
            List<String> excludes = this.getMemberList(anno, "excludes");
            List<FieldNode> list = GeneralUtils.getInstancePropertyFields(cNode);
            if (includeFields) {
                list.addAll(GeneralUtils.getInstanceNonPropertyFields(cNode));
            }
            if (style == null) {
                style = AutoCloneStyle.CLONE;
            }
            switch (style) {
                case COPY_CONSTRUCTOR: {
                    this.createCloneCopyConstructor(cNode, list, excludes);
                    break;
                }
                case SERIALIZATION: {
                    this.createCloneSerialization(cNode);
                    break;
                }
                case CLONE: {
                    this.createClone(cNode, list, excludes);
                    break;
                }
                case SIMPLE: {
                    this.createSimpleClone(cNode, list, excludes);
                }
            }
        }
    }

    private void createCloneSerialization(ClassNode cNode) {
        BlockStatement body = new BlockStatement();
        VariableExpression baos = GeneralUtils.varX("baos");
        body.addStatement(GeneralUtils.declS(baos, GeneralUtils.ctorX(BAOS_TYPE)));
        VariableExpression it = GeneralUtils.varX("it");
        ClosureExpression writeClosure = new ClosureExpression(Parameter.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.callX((Expression)it, "writeObject", (Expression)GeneralUtils.varX("this")))));
        writeClosure.setVariableScope(new VariableScope());
        body.addStatement(GeneralUtils.stmt(GeneralUtils.callX((Expression)baos, "withObjectOutputStream", (Expression)GeneralUtils.args(writeClosure))));
        VariableExpression bais = GeneralUtils.varX("bais");
        ConstructorCallExpression bytes = GeneralUtils.ctorX(BAIS_TYPE, GeneralUtils.args(GeneralUtils.callX(baos, "toByteArray")));
        body.addStatement(GeneralUtils.declS(bais, bytes));
        ClosureExpression readClosure = new ClosureExpression(new Parameter[0], GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.callX(it, "readObject"))));
        readClosure.setVariableScope(new VariableScope());
        MethodCallExpression klass = GeneralUtils.callThisX("getClass");
        MethodCallExpression classLoader = GeneralUtils.callX(klass, "getClassLoader");
        MethodCallExpression result = GeneralUtils.callX((Expression)bais, "withObjectInputStream", (Expression)GeneralUtils.args(classLoader, readClosure));
        body.addStatement(GeneralUtils.returnS(result));
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, exceptions, body);
    }

    private void createCloneCopyConstructor(ClassNode cNode, List<FieldNode> list, List<String> excludes) {
        boolean hasParent;
        BlockStatement initBody = new BlockStatement();
        if (cNode.getDeclaredConstructors().size() == 0) {
            initBody.addStatement(EmptyStatement.INSTANCE);
            cNode.addConstructor(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, initBody);
            initBody = new BlockStatement();
        }
        Parameter initParam = new Parameter(GenericsUtils.nonGeneric(cNode), "other");
        VariableExpression other = GeneralUtils.varX(initParam);
        boolean bl = hasParent = cNode.getSuperClass() != ClassHelper.OBJECT_TYPE;
        if (hasParent) {
            initBody.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER, other)));
        }
        for (FieldNode fieldNode : list) {
            String name = fieldNode.getName();
            if (excludes.contains(name)) continue;
            Expression direct = GeneralUtils.propX((Expression)other, name);
            MethodCallExpression cloned = GeneralUtils.callX(direct, "clone");
            Expression to = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name);
            Statement assignCloned = GeneralUtils.assignS(to, cloned);
            Statement assignDirect = GeneralUtils.assignS(to, direct);
            initBody.addStatement(GeneralUtils.ifElseS(GeneralUtils.isInstanceOfX(direct, CLONEABLE_TYPE), assignCloned, assignDirect));
        }
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addConstructor(4, GeneralUtils.params(initParam), ClassNode.EMPTY_ARRAY, initBody);
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, exceptions, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.ctorX(cNode, GeneralUtils.args(GeneralUtils.varX("this"))))));
    }

    private void createSimpleClone(ClassNode cNode, List<FieldNode> fieldNodes, List<String> excludes) {
        if (cNode.getDeclaredConstructors().size() == 0) {
            cNode.addConstructor(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GeneralUtils.block(EmptyStatement.INSTANCE));
        }
        BlockStatement cloneBody = new BlockStatement();
        VariableExpression result = GeneralUtils.varX("_result");
        ConstructorCallExpression noarg = GeneralUtils.ctorX(cNode);
        cloneBody.addStatement(GeneralUtils.declS(result, noarg));
        this.addSimpleCloneHelperMethod(cNode, fieldNodes, excludes);
        cloneBody.addStatement(GeneralUtils.stmt(GeneralUtils.callThisX("cloneOrCopyMembers", GeneralUtils.args(result))));
        cloneBody.addStatement(GeneralUtils.returnS(result));
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, exceptions, cloneBody);
    }

    private void addSimpleCloneHelperMethod(ClassNode cNode, List<FieldNode> fieldNodes, List<String> excludes) {
        Parameter methodParam = new Parameter(GenericsUtils.nonGeneric(cNode), "other");
        VariableExpression other = GeneralUtils.varX(methodParam);
        boolean hasParent = cNode.getSuperClass() != ClassHelper.OBJECT_TYPE;
        BlockStatement methodBody = new BlockStatement();
        if (hasParent) {
            methodBody.addStatement(GeneralUtils.stmt(GeneralUtils.callSuperX("cloneOrCopyMembers", GeneralUtils.args(other))));
        }
        for (FieldNode fieldNode : fieldNodes) {
            String name = fieldNode.getName();
            if (excludes.contains(name)) continue;
            Expression direct = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name);
            MethodCallExpression cloned = GeneralUtils.callX(direct, "clone");
            Expression to = GeneralUtils.propX((Expression)other, name);
            Statement assignCloned = GeneralUtils.assignS(to, cloned);
            Statement assignDirect = GeneralUtils.assignS(to, direct);
            methodBody.addStatement(GeneralUtils.ifElseS(GeneralUtils.isInstanceOfX(direct, CLONEABLE_TYPE), assignCloned, assignDirect));
        }
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("cloneOrCopyMembers", 4, ClassHelper.VOID_TYPE, GeneralUtils.params(methodParam), exceptions, methodBody);
    }

    private void createClone(ClassNode cNode, List<FieldNode> fieldNodes, List<String> excludes) {
        BlockStatement body = new BlockStatement();
        VariableExpression result = GeneralUtils.varX("_result");
        body.addStatement(GeneralUtils.declS(result, GeneralUtils.callSuperX("clone")));
        for (FieldNode fieldNode : fieldNodes) {
            if (excludes.contains(fieldNode.getName())) continue;
            VariableExpression fieldExpr = GeneralUtils.varX(fieldNode);
            MethodCallExpression from = GeneralUtils.callX(fieldExpr, "clone");
            Expression to = GeneralUtils.propX((Expression)result, fieldNode.getName());
            Statement doClone = GeneralUtils.assignS(to, from);
            body.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.isInstanceOfX(fieldExpr, CLONEABLE_TYPE), doClone));
        }
        body.addStatement(GeneralUtils.returnS(result));
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, exceptions, body);
    }

    private AutoCloneStyle getStyle(AnnotationNode node, String name) {
        ClassExpression ce;
        PropertyExpression prop;
        Expression oe;
        Expression member = node.getMember(name);
        if (member != null && member instanceof PropertyExpression && (oe = (prop = (PropertyExpression)member).getObjectExpression()) instanceof ClassExpression && (ce = (ClassExpression)oe).getType().getName().equals("groovy.transform.AutoCloneStyle")) {
            return AutoCloneStyle.valueOf(prop.getPropertyAsString());
        }
        return null;
    }
}

