/*
 * Decompiled with CFR 0.152.
 */
package groovy.text;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import groovy.xml.QName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.xml.sax.SAXException;

public class XmlTemplateEngine
extends TemplateEngine {
    private static int counter = 1;
    public static final String DEFAULT_INDENTATION = "  ";
    private final GroovyShell groovyShell;
    private final XmlParser xmlParser;
    private String indentation;

    public XmlTemplateEngine() throws SAXException, ParserConfigurationException {
        this(DEFAULT_INDENTATION, false);
    }

    public XmlTemplateEngine(String indentation, boolean validating) throws SAXException, ParserConfigurationException {
        this(new XmlParser(validating, true), new GroovyShell());
        this.xmlParser.setTrimWhitespace(true);
        this.setIndentation(indentation);
    }

    public XmlTemplateEngine(XmlParser xmlParser, ClassLoader parentLoader) {
        this(xmlParser, new GroovyShell(parentLoader));
    }

    public XmlTemplateEngine(XmlParser xmlParser, GroovyShell groovyShell) {
        this.groovyShell = groovyShell;
        this.xmlParser = xmlParser;
        this.setIndentation(DEFAULT_INDENTATION);
    }

    public Template createTemplate(Reader reader) throws CompilationFailedException, ClassNotFoundException, IOException {
        Script script;
        Node root;
        try {
            root = this.xmlParser.parse(reader);
        }
        catch (SAXException e) {
            throw new RuntimeException("Parsing XML source failed.", e);
        }
        if (root == null) {
            throw new IOException("Parsing XML source failed: root node is null.");
        }
        StringWriter writer = new StringWriter(1024);
        writer.write("/* Generated by XmlTemplateEngine */\n");
        new GspPrinter(new PrintWriter(writer), this.indentation).print(root);
        try {
            script = this.groovyShell.parse(writer.toString(), "XmlTemplateScript" + counter++ + ".groovy");
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Failed to parse template script (your template may contain an error or be trying to use expressions not currently supported): " + e.getMessage());
        }
        return new XmlTemplate(script);
    }

    public String getIndentation() {
        return this.indentation;
    }

    public void setIndentation(String indentation) {
        if (indentation == null) {
            indentation = DEFAULT_INDENTATION;
        }
        this.indentation = indentation;
    }

    public String toString() {
        return "XmlTemplateEngine";
    }

    private static class XmlWritable
    implements Writable {
        private final Binding binding;
        private final Script script;
        private WeakReference result;

        public XmlWritable(Script script, Binding binding) {
            this.script = script;
            this.binding = binding;
            this.result = new WeakReference<Object>(null);
        }

        public Writer writeTo(Writer out) {
            Script scriptObject = InvokerHelper.createScript(this.script.getClass(), this.binding);
            PrintWriter pw = new PrintWriter(out);
            scriptObject.setProperty("out", pw);
            scriptObject.run();
            pw.flush();
            return out;
        }

        public String toString() {
            if (this.result.get() != null) {
                return this.result.get().toString();
            }
            String string = this.writeTo(new StringWriter(1024)).toString();
            this.result = new WeakReference<String>(string);
            return string;
        }
    }

    private static class XmlTemplate
    implements Template {
        private final Script script;

        public XmlTemplate(Script script) {
            this.script = script;
        }

        public Writable make() {
            return this.make(new HashMap());
        }

        public Writable make(Map map) {
            if (map == null) {
                throw new IllegalArgumentException("map must not be null");
            }
            return new XmlWritable(this.script, new Binding(map));
        }
    }

    private static class GspPrinter
    extends XmlNodePrinter {
        public GspPrinter(PrintWriter out, String indent) {
            this(new IndentPrinter(out, indent));
        }

        public GspPrinter(IndentPrinter out) {
            super(out, "\\\"");
            this.setQuote("'");
        }

        protected void printGroovyTag(String tag, String text) {
            if (tag.equals("scriptlet")) {
                this.out.print(text);
                this.out.print("\n");
                return;
            }
            if (tag.equals("expression")) {
                this.printLineBegin();
                this.out.print("${");
                this.out.print(text);
                this.out.print("}");
                this.printLineEnd();
                return;
            }
            throw new RuntimeException("Unsupported 'gsp:' tag named \"" + tag + "\".");
        }

        protected void printSimpleItem(Object value) {
            this.printLineBegin();
            this.out.print(this.escapeSpecialChars(InvokerHelper.toString(value)));
            this.printLineEnd();
        }

        private String escapeSpecialChars(String s) {
            StringBuilder sb = new StringBuilder();
            boolean inGString = false;
            block8: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '$': {
                        sb.append("$");
                        if (i >= s.length() - 1 || s.charAt(i + 1) != '{') continue block8;
                        inGString = true;
                        continue block8;
                    }
                    case '<': {
                        this.append(sb, c, "&lt;", inGString);
                        continue block8;
                    }
                    case '>': {
                        this.append(sb, c, "&gt;", inGString);
                        continue block8;
                    }
                    case '\"': {
                        this.append(sb, c, "&quot;", inGString);
                        continue block8;
                    }
                    case '\'': {
                        this.append(sb, c, "&apos;", inGString);
                        continue block8;
                    }
                    case '}': {
                        sb.append(c);
                        inGString = false;
                        continue block8;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        private void append(StringBuilder sb, char plainChar, String xmlString, boolean inGString) {
            if (inGString) {
                sb.append(plainChar);
            } else {
                sb.append(xmlString);
            }
        }

        protected void printLineBegin() {
            this.out.print("out.print(\"\"\"");
            this.out.printIndent();
        }

        protected void printLineEnd(String comment) {
            this.out.print("\\n\"\"\");");
            if (comment != null) {
                this.out.print(" // ");
                this.out.print(comment);
            }
            this.out.print("\n");
        }

        protected boolean printSpecialNode(Node node) {
            QName qn;
            Object name = node.name();
            if (name != null && name instanceof QName && ((qn = (QName)name).getNamespaceURI().equals("http://groovy.codehaus.org/2005/gsp") || qn.getPrefix().equals("gsp"))) {
                String s = qn.getLocalPart();
                if (s.length() == 0) {
                    throw new RuntimeException("No local part after 'gsp:' given in node " + node);
                }
                this.printGroovyTag(s, node.text());
                return true;
            }
            return false;
        }
    }
}

