/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import groovyjarjarasm.asm.Type;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyGeneratorAdapter
extends ClassVisitor
implements Opcodes {
    private static final Map<String, Boolean> EMPTY_DELEGATECLOSURE_MAP = Collections.emptyMap();
    private static final Set<String> EMPTY_STRING_SET = Collections.emptySet();
    private static final String CLOSURES_MAP_FIELD = "$closures$delegate$map";
    private static final String DELEGATE_OBJECT_FIELD = "$delegate";
    private static List<Method> OBJECT_METHODS = ProxyGeneratorAdapter.getInheritedMethods(Object.class, new ArrayList<Method>());
    private static List<Method> GROOVYOBJECT_METHODS = ProxyGeneratorAdapter.getInheritedMethods(GroovyObject.class, new ArrayList<Method>());
    private static final AtomicLong pxyCounter = new AtomicLong();
    private static final Set<String> GROOVYOBJECT_METHOD_NAMESS;
    private static final Object[] EMPTY_ARGS;
    private final Class superClass;
    private final Class delegateClass;
    private final InnerLoader loader;
    private final String proxyName;
    private final List<Class> classList;
    private final Map<String, Boolean> delegatedClosures;
    private final boolean emptyBody;
    private final boolean hasWildcard;
    private final boolean generateDelegateField;
    private final Set<String> objectDelegateMethods;
    private final Set<Object> visitedMethods = new LinkedHashSet<Object>();
    private final Class cachedClass;
    private final Constructor cachedNoArgConstructor;

    public ProxyGeneratorAdapter(Map<Object, Object> closureMap, Class superClass, Class[] interfaces, ClassLoader proxyLoader, boolean emptyBody, Class delegateClass) {
        super(262144, new ClassWriter(0));
        Constructor constructor;
        Class[] classArray;
        this.delegatedClosures = closureMap.isEmpty() ? EMPTY_DELEGATECLOSURE_MAP : new HashMap();
        boolean wildcard = false;
        for (Map.Entry<Object, Object> entry : closureMap.entrySet()) {
            String name = entry.getKey().toString();
            if ("*".equals(name)) {
                wildcard = true;
            }
            this.delegatedClosures.put(name, Boolean.FALSE);
        }
        this.hasWildcard = wildcard;
        this.generateDelegateField = delegateClass != null;
        this.objectDelegateMethods = this.generateDelegateField ? ProxyGeneratorAdapter.createDelegateMethodList(delegateClass, interfaces) : EMPTY_STRING_SET;
        this.delegateClass = delegateClass;
        boolean isSuperClassAnInterface = superClass.isInterface();
        this.superClass = isSuperClassAnInterface ? Object.class : superClass;
        this.classList = new LinkedList<Class>();
        this.classList.add(superClass);
        if (this.generateDelegateField) {
            this.classList.add(delegateClass);
        }
        if (interfaces != null) {
            Collections.addAll(this.classList, interfaces);
        }
        this.proxyName = this.proxyName();
        this.loader = proxyLoader != null ? new InnerLoader(proxyLoader) : this.findClassLoader(superClass);
        this.emptyBody = emptyBody;
        ClassWriter writer = (ClassWriter)this.cv;
        ClassReader cr = this.createClassVisitor(Object.class);
        cr.accept(this, 0);
        byte[] b = writer.toByteArray();
        this.cachedClass = this.loader.defineClass(this.proxyName.replace('/', '.'), b);
        if (this.generateDelegateField) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Map.class;
            classArray = classArray2;
            classArray2[1] = delegateClass;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = Map.class;
        }
        Class[] args = classArray;
        try {
            constructor = this.cachedClass.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        this.cachedNoArgConstructor = constructor;
    }

    private InnerLoader findClassLoader(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return new InnerLoader(cl);
    }

    private static Set<String> createDelegateMethodList(Class superClass, Class[] interfaces) {
        HashSet<String> selectedMethods = new HashSet<String>();
        ArrayList<Method> interfaceMethods = new ArrayList<Method>();
        if (interfaces != null) {
            for (Class thisInterface : interfaces) {
                ProxyGeneratorAdapter.getInheritedMethods(thisInterface, interfaceMethods);
            }
            for (Method method : interfaceMethods) {
                if (ProxyGeneratorAdapter.containsEquivalentMethod(OBJECT_METHODS, method) || ProxyGeneratorAdapter.containsEquivalentMethod(GROOVYOBJECT_METHODS, method)) continue;
                selectedMethods.add(method.getName());
            }
        }
        List<Method> additionalMethods = ProxyGeneratorAdapter.getInheritedMethods(superClass, new ArrayList<Method>());
        for (Method method : additionalMethods) {
            if (method.getName().indexOf(36) != -1 || ProxyGeneratorAdapter.containsEquivalentMethod(interfaceMethods, method) || ProxyGeneratorAdapter.containsEquivalentMethod(OBJECT_METHODS, method) || ProxyGeneratorAdapter.containsEquivalentMethod(GROOVYOBJECT_METHODS, method)) continue;
            selectedMethods.add(method.getName());
        }
        return selectedMethods;
    }

    private static List<Method> getInheritedMethods(Class baseClass, List<Method> methods) {
        Collections.addAll(methods, baseClass.getMethods());
        for (Class currentClass = baseClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] protectedMethods;
            for (Method method : protectedMethods = currentClass.getDeclaredMethods()) {
                if (method.getName().indexOf(36) != -1 || !Modifier.isProtected(method.getModifiers()) || ProxyGeneratorAdapter.containsEquivalentMethod(methods, method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    private static boolean containsEquivalentMethod(Collection<Method> publicAndProtectedMethods, Method candidate) {
        for (Method method : publicAndProtectedMethods) {
            if (!candidate.getName().equals(method.getName()) || !candidate.getReturnType().equals(method.getReturnType()) || !ProxyGeneratorAdapter.hasMatchingParameterTypes(candidate, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMatchingParameterTypes(Method method, Method candidate) {
        Class<?>[] methodParamTypes;
        Class<?>[] candidateParamTypes = candidate.getParameterTypes();
        if (candidateParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (candidateParamTypes[i].equals(methodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private ClassReader createClassVisitor(Class baseClass) {
        try {
            String name = baseClass.getName();
            String path = name.replace('.', '/') + ".class";
            InputStream in = this.loader.getResourceAsStream(path);
            return new ClassReader(in);
        }
        catch (IOException e) {
            throw new GroovyRuntimeException("Unable to generate a proxy for " + baseClass + " from class loader " + this.loader, e);
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean addGroovyObjectSupport;
        LinkedHashSet<String> interfacesSet = new LinkedHashSet<String>();
        if (interfaces != null) {
            Collections.addAll(interfacesSet, interfaces);
        }
        for (Class extraInterface : this.classList) {
            if (!extraInterface.isInterface()) continue;
            interfacesSet.add(BytecodeHelper.getClassInternalName(extraInterface));
        }
        boolean bl = addGroovyObjectSupport = !GroovyObject.class.isAssignableFrom(this.superClass);
        if (addGroovyObjectSupport) {
            interfacesSet.add("groovy/lang/GroovyObject");
        }
        super.visit(49, 1, this.proxyName, signature, BytecodeHelper.getClassInternalName(this.superClass), interfacesSet.toArray(new String[interfacesSet.size()]));
        this.addDelegateFields();
        if (addGroovyObjectSupport) {
            this.createGroovyObjectSupport();
        }
        for (Class clazz : this.classList) {
            this.visitClass(clazz);
        }
    }

    private void visitClass(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?>[] classArray = method.getExceptionTypes();
            String[] exceptions = new String[classArray.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = BytecodeHelper.getClassInternalName(classArray[i]);
            }
            this.visitMethod(method.getModifiers(), method.getName(), BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameterTypes()), null, exceptions);
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (Constructor<?> constructor : constructors) {
            Class<?>[] exceptionTypes = constructor.getExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = BytecodeHelper.getClassInternalName(exceptionTypes[i]);
            }
            this.visitMethod(constructor.getModifiers(), "<init>", BytecodeHelper.getMethodDescriptor(Void.TYPE, constructor.getParameterTypes()), null, exceptions);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            this.visitClass((Class)genericDeclaration);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.visitClass(superclass);
        }
        for (Map.Entry<String, Boolean> entry : this.delegatedClosures.entrySet()) {
            String name;
            Boolean bl = entry.getValue();
            if (bl.booleanValue() || "*".equals(name = entry.getKey())) continue;
            this.visitMethod(1, name, "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        }
    }

    private void createGroovyObjectSupport() {
        this.visitField(130, "metaClass", "Lgroovy/lang/MetaClass;", null, null);
        MethodVisitor mv = super.visitMethod(1, "getMetaClass", "()Lgroovy/lang/MetaClass;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.proxyName, "metaClass", "Lgroovy/lang/MetaClass;");
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", "getMetaClass", "(Ljava/lang/Class;)Lgroovy/lang/MetaClass;");
        mv.visitFieldInsn(181, this.proxyName, "metaClass", "Lgroovy/lang/MetaClass;");
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.proxyName, "metaClass", "Lgroovy/lang/MetaClass;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = super.visitMethod(1, "getProperty", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitIntInsn(25, 0);
        mv.visitMethodInsn(185, "groovy/lang/GroovyObject", "getMetaClass", "()Lgroovy/lang/MetaClass;");
        mv.visitIntInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "groovy/lang/MetaClass", "getProperty", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = super.visitMethod(1, "setProperty", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.proxyName, "getMetaClass", "()Lgroovy/lang/MetaClass;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, "groovy/lang/MetaClass", "setProperty", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        mv = super.visitMethod(1, "invokeMethod", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.proxyName, "getMetaClass", "()Lgroovy/lang/MetaClass;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, "groovy/lang/MetaClass", "invokeMethod", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        mv = super.visitMethod(1, "setMetaClass", "(Lgroovy/lang/MetaClass;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.proxyName, "metaClass", "Lgroovy/lang/MetaClass;");
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void addDelegateFields() {
        this.visitField(18, CLOSURES_MAP_FIELD, "Ljava/util/Map;", null, null);
        if (this.generateDelegateField) {
            this.visitField(18, DELEGATE_OBJECT_FIELD, BytecodeHelper.getTypeDescription(this.delegateClass), null, null);
        }
    }

    private String proxyName() {
        String name = this.delegateClass != null ? this.delegateClass.getName() : this.superClass.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name + pxyCounter.incrementAndGet() + "_groovyProxy";
        }
        return name.substring(index + 1, name.length()) + pxyCounter.incrementAndGet() + "_groovyProxy";
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        List<String> key = Arrays.asList(name, desc);
        if (this.visitedMethods.contains(key)) {
            return null;
        }
        if (Modifier.isPrivate(access) || Modifier.isNative(access) || (access & 0x1000) != 0) {
            return null;
        }
        int accessFlags = access;
        this.visitedMethods.add(key);
        if ((this.objectDelegateMethods.contains(name) || this.delegatedClosures.containsKey(name) || !"<init>".equals(name) && this.hasWildcard) && !Modifier.isStatic(access) && !Modifier.isFinal(access)) {
            if (!GROOVYOBJECT_METHOD_NAMESS.contains(name)) {
                if (Modifier.isAbstract(access)) {
                    accessFlags -= 1024;
                }
                if (this.delegatedClosures.containsKey(name) || !"<init>".equals(name) && this.hasWildcard) {
                    this.delegatedClosures.put(name, Boolean.TRUE);
                    return this.makeDelegateToClosureCall(name, desc, signature, exceptions, accessFlags);
                }
                if (this.generateDelegateField && this.objectDelegateMethods.contains(name)) {
                    return this.makeDelegateCall(name, desc, signature, exceptions, accessFlags);
                }
                this.delegatedClosures.put(name, Boolean.TRUE);
                return this.makeDelegateToClosureCall(name, desc, signature, exceptions, accessFlags);
            }
        } else {
            if ("<init>".equals(name) && (Modifier.isPublic(access) || Modifier.isProtected(access))) {
                return this.createConstructor(access, name, desc, signature, exceptions);
            }
            if (Modifier.isAbstract(access) && !GROOVYOBJECT_METHOD_NAMESS.contains(name)) {
                MethodVisitor mv = super.visitMethod(accessFlags -= 1024, name, desc, signature, exceptions);
                mv.visitCode();
                Type[] args = Type.getArgumentTypes(desc);
                if (this.emptyBody) {
                    Type returnType = Type.getReturnType(desc);
                    if (returnType == Type.VOID_TYPE) {
                        mv.visitInsn(177);
                    } else {
                        int loadIns = ProxyGeneratorAdapter.getLoadInsn(returnType);
                        switch (loadIns) {
                            case 21: {
                                mv.visitInsn(3);
                                break;
                            }
                            case 22: {
                                mv.visitInsn(9);
                                break;
                            }
                            case 23: {
                                mv.visitInsn(11);
                                break;
                            }
                            case 24: {
                                mv.visitInsn(14);
                                break;
                            }
                            default: {
                                mv.visitInsn(1);
                            }
                        }
                        mv.visitInsn(ProxyGeneratorAdapter.getReturnInsn(returnType));
                        mv.visitMaxs(2, this.registerLen(args) + 1);
                    }
                } else {
                    mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V");
                    mv.visitInsn(191);
                    mv.visitMaxs(2, this.registerLen(args) + 1);
                }
                mv.visitEnd();
            }
        }
        return null;
    }

    private int registerLen(Type[] args) {
        int i = 0;
        for (Type arg : args) {
            i += this.registerLen(arg);
        }
        return i;
    }

    private int registerLen(Type arg) {
        return arg == Type.DOUBLE_TYPE || arg == Type.LONG_TYPE ? 2 : 1;
    }

    private MethodVisitor createConstructor(int access, String name, String desc, String signature, String[] exceptions) {
        Type[] args = Type.getArgumentTypes(desc);
        StringBuilder newDesc = new StringBuilder("(");
        for (Type arg : args) {
            newDesc.append(arg.getDescriptor());
        }
        newDesc.append("Ljava/util/Map;");
        if (this.generateDelegateField) {
            newDesc.append(BytecodeHelper.getTypeDescription(this.delegateClass));
        }
        newDesc.append(")V");
        MethodVisitor mv = super.visitMethod(access, name, newDesc.toString(), signature, exceptions);
        mv.visitCode();
        this.initializeDelegateClosure(mv, args);
        if (this.generateDelegateField) {
            this.initializeDelegateObject(mv, args);
        }
        mv.visitVarInsn(25, 0);
        int idx = 1;
        for (Type arg : args) {
            if (this.isPrimitive(arg)) {
                mv.visitIntInsn(ProxyGeneratorAdapter.getLoadInsn(arg), idx);
            } else {
                mv.visitVarInsn(25, idx);
            }
            idx += this.registerLen(arg);
        }
        mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(this.superClass), "<init>", desc);
        mv.visitInsn(177);
        int max = idx + 1 + (this.generateDelegateField ? 1 : 0);
        mv.visitMaxs(max, max);
        mv.visitEnd();
        return null;
    }

    private void initializeDelegateClosure(MethodVisitor mv, Type[] args) {
        int idx = 1;
        for (Type type : args) {
            idx += this.registerLen(type);
        }
        mv.visitIntInsn(25, 0);
        mv.visitIntInsn(25, idx);
        mv.visitFieldInsn(181, this.proxyName, CLOSURES_MAP_FIELD, "Ljava/util/Map;");
    }

    private void initializeDelegateObject(MethodVisitor mv, Type[] args) {
        int idx = 2;
        for (Type type : args) {
            idx += this.registerLen(type);
        }
        mv.visitIntInsn(25, 0);
        mv.visitIntInsn(25, idx);
        mv.visitFieldInsn(181, this.proxyName, DELEGATE_OBJECT_FIELD, BytecodeHelper.getTypeDescription(this.delegateClass));
    }

    protected MethodVisitor makeDelegateCall(String name, String desc, String signature, String[] exceptions, int accessFlags) {
        MethodVisitor mv = super.visitMethod(accessFlags, name, desc, signature, exceptions);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.proxyName, DELEGATE_OBJECT_FIELD, BytecodeHelper.getTypeDescription(this.delegateClass));
        mv.visitLdcInsn(name);
        Type[] args = Type.getArgumentTypes(desc);
        BytecodeHelper.pushConstant(mv, args.length);
        mv.visitTypeInsn(189, "java/lang/Object");
        int size = 3;
        int idx = 1;
        for (int i = 0; i < args.length; ++i) {
            Type arg = args[i];
            mv.visitInsn(89);
            BytecodeHelper.pushConstant(mv, i);
            if (this.isPrimitive(arg)) {
                mv.visitIntInsn(ProxyGeneratorAdapter.getLoadInsn(arg), idx);
                String wrappedType = this.getWrappedClassDescriptor(arg);
                mv.visitMethodInsn(184, wrappedType, "valueOf", "(" + arg.getDescriptor() + ")L" + wrappedType + ";");
            } else {
                mv.visitVarInsn(25, idx);
            }
            size = Math.max(6, 5 + this.registerLen(arg));
            idx += this.registerLen(arg);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", "invokeMethod", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        this.unwrapResult(mv, desc);
        mv.visitMaxs(size, this.registerLen(args) + 1);
        return null;
    }

    protected MethodVisitor makeDelegateToClosureCall(String name, String desc, String signature, String[] exceptions, int accessFlags) {
        MethodVisitor mv = super.visitMethod(accessFlags, name, desc, signature, exceptions);
        mv.visitCode();
        int stackSize = 0;
        Type[] args = Type.getArgumentTypes(desc);
        int arrayStore = args.length + 1;
        BytecodeHelper.pushConstant(mv, args.length);
        mv.visitTypeInsn(189, "java/lang/Object");
        stackSize = 1;
        int idx = 1;
        for (int i = 0; i < args.length; ++i) {
            Type arg = args[i];
            mv.visitInsn(89);
            BytecodeHelper.pushConstant(mv, i);
            stackSize = 3;
            if (this.isPrimitive(arg)) {
                mv.visitIntInsn(ProxyGeneratorAdapter.getLoadInsn(arg), idx);
                String wrappedType = this.getWrappedClassDescriptor(arg);
                mv.visitMethodInsn(184, wrappedType, "valueOf", "(" + arg.getDescriptor() + ")L" + wrappedType + ";");
            } else {
                mv.visitVarInsn(25, idx);
            }
            idx += this.registerLen(arg);
            stackSize = Math.max(4, 3 + this.registerLen(arg));
            mv.visitInsn(83);
        }
        mv.visitVarInsn(58, arrayStore);
        int arrayIndex = arrayStore++;
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.proxyName, CLOSURES_MAP_FIELD, "Ljava/util/Map;");
        mv.visitLdcInsn(name);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitVarInsn(58, arrayStore);
        Label notNull = new Label();
        mv.visitIntInsn(25, arrayStore);
        mv.visitJumpInsn(199, notNull);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.proxyName, CLOSURES_MAP_FIELD, "Ljava/util/Map;");
        mv.visitLdcInsn("*");
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitVarInsn(58, arrayStore);
        mv.visitLabel(notNull);
        mv.visitVarInsn(25, arrayStore);
        mv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(this.getClass()), "ensureClosure", "(Ljava/lang/Object;)Lgroovy/lang/Closure;");
        mv.visitVarInsn(25, arrayIndex);
        mv.visitMethodInsn(182, "groovy/lang/Closure", "call", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.unwrapResult(mv, desc);
        mv.visitMaxs(++stackSize, arrayStore + 1);
        mv.visitEnd();
        return null;
    }

    private void unwrapResult(MethodVisitor mv, String desc) {
        Type returnType = Type.getReturnType(desc);
        if (returnType == Type.VOID_TYPE) {
            mv.visitInsn(87);
            mv.visitInsn(177);
        } else {
            if (this.isPrimitive(returnType)) {
                BytecodeHelper.unbox(mv, ClassHelper.make(returnType.getClassName()));
            } else {
                mv.visitTypeInsn(192, returnType.getInternalName());
            }
            mv.visitInsn(ProxyGeneratorAdapter.getReturnInsn(returnType));
        }
    }

    public GroovyObject proxy(Map<Object, Object> map, Object ... constructorArgs) {
        if (constructorArgs == null && this.cachedNoArgConstructor != null) {
            try {
                return (GroovyObject)this.cachedNoArgConstructor.newInstance(map);
            }
            catch (InstantiationException e) {
                throw new GroovyRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new GroovyRuntimeException(e);
            }
        }
        if (constructorArgs == null) {
            constructorArgs = EMPTY_ARGS;
        }
        Object[] values = new Object[constructorArgs.length + 1];
        System.arraycopy(constructorArgs, 0, values, 0, constructorArgs.length);
        values[values.length - 1] = map;
        return (GroovyObject)DefaultGroovyMethods.newInstance(this.cachedClass, values);
    }

    public GroovyObject delegatingProxy(Object delegate, Map<Object, Object> map, Object ... constructorArgs) {
        if (constructorArgs == null && this.cachedNoArgConstructor != null) {
            try {
                return (GroovyObject)this.cachedNoArgConstructor.newInstance(map, delegate);
            }
            catch (InstantiationException e) {
                throw new GroovyRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new GroovyRuntimeException(e);
            }
        }
        if (constructorArgs == null) {
            constructorArgs = EMPTY_ARGS;
        }
        Object[] values = new Object[constructorArgs.length + 2];
        System.arraycopy(constructorArgs, 0, values, 0, constructorArgs.length);
        values[values.length - 2] = map;
        values[values.length - 1] = delegate;
        return (GroovyObject)DefaultGroovyMethods.newInstance(this.cachedClass, values);
    }

    public static Closure ensureClosure(Object o) {
        if (o == null) {
            throw new UnsupportedOperationException();
        }
        if (o instanceof Closure) {
            return (Closure)o;
        }
        return new ReturnValueWrappingClosure<Object>(o);
    }

    private static int getLoadInsn(Type type) {
        if (type == Type.BOOLEAN_TYPE) {
            return 21;
        }
        if (type == Type.BYTE_TYPE) {
            return 21;
        }
        if (type == Type.CHAR_TYPE) {
            return 21;
        }
        if (type == Type.DOUBLE_TYPE) {
            return 24;
        }
        if (type == Type.FLOAT_TYPE) {
            return 23;
        }
        if (type == Type.INT_TYPE) {
            return 21;
        }
        if (type == Type.LONG_TYPE) {
            return 22;
        }
        if (type == Type.SHORT_TYPE) {
            return 21;
        }
        return 25;
    }

    private static int getReturnInsn(Type type) {
        if (type == Type.BOOLEAN_TYPE) {
            return 172;
        }
        if (type == Type.BYTE_TYPE) {
            return 172;
        }
        if (type == Type.CHAR_TYPE) {
            return 172;
        }
        if (type == Type.DOUBLE_TYPE) {
            return 175;
        }
        if (type == Type.FLOAT_TYPE) {
            return 174;
        }
        if (type == Type.INT_TYPE) {
            return 172;
        }
        if (type == Type.LONG_TYPE) {
            return 173;
        }
        if (type == Type.SHORT_TYPE) {
            return 172;
        }
        return 176;
    }

    private boolean isPrimitive(Type arg) {
        return arg == Type.BOOLEAN_TYPE || arg == Type.BYTE_TYPE || arg == Type.CHAR_TYPE || arg == Type.DOUBLE_TYPE || arg == Type.FLOAT_TYPE || arg == Type.INT_TYPE || arg == Type.LONG_TYPE || arg == Type.SHORT_TYPE;
    }

    private String getWrappedClassDescriptor(Type type) {
        if (type == Type.BOOLEAN_TYPE) {
            return "java/lang/Boolean";
        }
        if (type == Type.BYTE_TYPE) {
            return "java/lang/Byte";
        }
        if (type == Type.CHAR_TYPE) {
            return "java/lang/Character";
        }
        if (type == Type.DOUBLE_TYPE) {
            return "java/lang/Double";
        }
        if (type == Type.FLOAT_TYPE) {
            return "java/lang/Float";
        }
        if (type == Type.INT_TYPE) {
            return "java/lang/Integer";
        }
        if (type == Type.LONG_TYPE) {
            return "java/lang/Long";
        }
        if (type == Type.SHORT_TYPE) {
            return "java/lang/Short";
        }
        throw new IllegalArgumentException("Unexpected type class [" + type + "]");
    }

    static {
        EMPTY_ARGS = new Object[0];
        ArrayList<String> names = new ArrayList<String>();
        for (Method method : GroovyObject.class.getMethods()) {
            names.add(method.getName());
        }
        GROOVYOBJECT_METHOD_NAMESS = new HashSet<String>(names);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReturnValueWrappingClosure<V>
    extends Closure<V> {
        private final V value;

        public ReturnValueWrappingClosure(V returnValue) {
            super(null);
            this.value = returnValue;
        }

        @Override
        public V call(Object ... args) {
            return this.value;
        }
    }

    private static class InnerLoader
    extends ClassLoader {
        protected InnerLoader(ClassLoader parent) {
            super(parent);
        }

        protected Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length);
        }
    }
}

