/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.Canonical;
import java.util.ArrayList;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.EqualsAndHashCodeASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.transform.ToStringASTTransformation;
import org.codehaus.groovy.transform.TupleConstructorASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class CanonicalASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = Canonical.class;
    static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (this.hasAnnotation(cNode, ImmutableASTTransformation.MY_TYPE)) {
                this.addError(MY_TYPE_NAME + " class '" + cNode.getName() + "' can't also be " + ImmutableASTTransformation.MY_TYPE_NAME, parent);
            }
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            if (!this.hasAnnotation(cNode, TupleConstructorASTTransformation.MY_TYPE)) {
                TupleConstructorASTTransformation.createConstructor(cNode, false, true, false, false, false, false, new ArrayList<String>());
            }
            if (!this.hasAnnotation(cNode, EqualsAndHashCodeASTTransformation.MY_TYPE)) {
                EqualsAndHashCodeASTTransformation.createHashCode(cNode, false, false, false, new ArrayList<String>());
                EqualsAndHashCodeASTTransformation.createEquals(cNode, false, false, new ArrayList<String>());
            }
            if (!this.hasAnnotation(cNode, ToStringASTTransformation.MY_TYPE)) {
                ToStringASTTransformation.toStringInit(cNode, ConstantExpression.FALSE);
                ToStringASTTransformation.createToString(cNode, false, false, new ArrayList<String>());
            }
        }
    }
}

