/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.TupleConstructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TupleConstructorASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = TupleConstructor.class;
    static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static Map<Class<?>, Expression> primitivesInitialValues;

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean includeProperties = !this.memberHasValue(anno, "includeProperties", false);
            boolean includeSuperFields = this.memberHasValue(anno, "includeSuperFields", true);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean callSuper = this.memberHasValue(anno, "callSuper", true);
            boolean force = this.memberHasValue(anno, "force", true);
            List<String> excludes = this.tokenize((String)this.getMemberValue(anno, "excludes"));
            TupleConstructorASTTransformation.createConstructor(cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, callSuper, force, excludes);
        }
    }

    public static void createConstructor(ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, boolean callSuper, boolean force, List<String> excludes) {
        String name;
        boolean foundEmpty;
        List<ConstructorNode> constructors = cNode.getDeclaredConstructors();
        if (constructors.size() > 1 && !force) {
            return;
        }
        boolean bl = foundEmpty = constructors.size() == 1 && constructors.get(0).getFirstStatement() == null;
        if (constructors.size() == 1 && !foundEmpty && !force) {
            return;
        }
        if (foundEmpty) {
            constructors.remove(0);
        }
        ArrayList<FieldNode> superList = new ArrayList<FieldNode>();
        if (includeSuperProperties) {
            superList.addAll(AbstractASTTransformUtil.getSuperPropertyFields(cNode.getSuperClass()));
        }
        if (includeSuperFields) {
            superList.addAll(AbstractASTTransformUtil.getSuperNonPropertyFields(cNode.getSuperClass()));
        }
        ArrayList<FieldNode> list = new ArrayList<FieldNode>();
        if (includeProperties) {
            list.addAll(AbstractASTTransformUtil.getInstancePropertyFields(cNode));
        }
        if (includeFields) {
            list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ArrayList<Expression> superParams = new ArrayList<Expression>();
        BlockStatement body = new BlockStatement();
        for (FieldNode fNode : superList) {
            name = fNode.getName();
            if (excludes.contains(name) || name.contains("$")) continue;
            params.add(TupleConstructorASTTransformation.createParam(fNode, name));
            if (callSuper) {
                superParams.add(new VariableExpression(name));
                continue;
            }
            body.addStatement(AbstractASTTransformUtil.assignStatement(new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, name), new VariableExpression(name)));
        }
        if (callSuper) {
            body.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, new ArgumentListExpression(superParams))));
        }
        for (FieldNode fNode : list) {
            name = fNode.getName();
            if (excludes.contains(name) || name.contains("$")) continue;
            params.add(TupleConstructorASTTransformation.createParam(fNode, name));
            body.addStatement(AbstractASTTransformUtil.assignStatement(new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, name), new VariableExpression(name)));
        }
        cNode.addConstructor(new ConstructorNode(1, params.toArray(new Parameter[params.size()]), ClassNode.EMPTY_ARRAY, body));
    }

    private static Parameter createParam(FieldNode fNode, String name) {
        Parameter param = new Parameter(fNode.getType(), name);
        param.setInitialExpression(TupleConstructorASTTransformation.providedOrDefaultInitialValue(fNode));
        return param;
    }

    private static Expression providedOrDefaultInitialValue(FieldNode fNode) {
        Expression initialExp = fNode.getInitialExpression() != null ? fNode.getInitialExpression() : ConstantExpression.NULL;
        ClassNode paramType = fNode.getType();
        if (ClassHelper.isPrimitiveType(paramType) && initialExp.equals(ConstantExpression.NULL)) {
            initialExp = primitivesInitialValues.get(paramType.getTypeClass());
        }
        return initialExp;
    }

    static {
        ConstantExpression zero = new ConstantExpression(0);
        ConstantExpression zeroDecimal = new ConstantExpression(0.0);
        primitivesInitialValues = new HashMap();
        primitivesInitialValues.put(Integer.TYPE, zero);
        primitivesInitialValues.put(Long.TYPE, zero);
        primitivesInitialValues.put(Short.TYPE, zero);
        primitivesInitialValues.put(Byte.TYPE, zero);
        primitivesInitialValues.put(Character.TYPE, zero);
        primitivesInitialValues.put(Float.TYPE, zeroDecimal);
        primitivesInitialValues.put(Double.TYPE, zeroDecimal);
        primitivesInitialValues.put(Boolean.TYPE, ConstantExpression.FALSE);
    }
}

