/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BinaryIntExpressionHelper;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.StatementWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class OptimizingStatementWriter
extends StatementWriter {
    private static final MethodCaller isOrigInt = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "isOrigInt");
    private boolean fastPathBlocked = false;
    private WriterController controller;

    public OptimizingStatementWriter(WriterController controller) {
        super(controller);
        this.controller = controller;
    }

    private boolean canNotDoFastPath(StatementMeta meta) {
        return this.fastPathBlocked || meta == null || !meta.optimize || this.controller.isFastPath();
    }

    private FastPathData writeGuards(StatementMeta meta, Statement statement) {
        if (this.canNotDoFastPath(meta)) {
            return null;
        }
        MethodVisitor mv = this.controller.getMethodVisitor();
        FastPathData fastPathData = new FastPathData();
        if (meta.optimizeInt) {
            isOrigInt.call(mv);
            mv.visitJumpInsn(154, fastPathData.pathStart);
        }
        return fastPathData;
    }

    private void writeFastPathPrelude(FastPathData meta) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitJumpInsn(167, meta.afterPath);
        mv.visitLabel(meta.pathStart);
        this.controller.switchToFastPath();
    }

    private void writeFastPathEpilogue(FastPathData meta) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitLabel(meta.afterPath);
        this.controller.switchToSlowPath();
    }

    public void writeBlockStatement(BlockStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        if (fastPathData == null) {
            super.writeBlockStatement(statement);
        } else {
            boolean oldFastPathBlock = this.fastPathBlocked;
            this.fastPathBlocked = true;
            super.writeBlockStatement(statement);
            this.fastPathBlocked = oldFastPathBlock;
            this.writeFastPathPrelude(fastPathData);
            super.writeBlockStatement(statement);
            this.writeFastPathEpilogue(fastPathData);
        }
    }

    public void writeDoWhileLoop(DoWhileStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        boolean oldFastPathBlock = this.fastPathBlocked;
        this.fastPathBlocked = true;
        super.writeDoWhileLoop(statement);
        this.fastPathBlocked = oldFastPathBlock;
        if (fastPathData == null) {
            return;
        }
        this.writeFastPathPrelude(fastPathData);
        super.writeDoWhileLoop(statement);
        this.writeFastPathEpilogue(fastPathData);
    }

    protected void writeIteratorHasNext(MethodVisitor mv) {
        if (this.controller.isFastPath()) {
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
        } else {
            super.writeIteratorHasNext(mv);
        }
    }

    protected void writeIteratorNext(MethodVisitor mv) {
        if (this.controller.isFastPath()) {
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
        } else {
            super.writeIteratorNext(mv);
        }
    }

    protected void writeForInLoop(ForStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        boolean oldFastPathBlock = this.fastPathBlocked;
        this.fastPathBlocked = true;
        super.writeForInLoop(statement);
        this.fastPathBlocked = oldFastPathBlock;
        if (fastPathData == null) {
            return;
        }
        this.writeFastPathPrelude(fastPathData);
        super.writeForInLoop(statement);
        this.writeFastPathEpilogue(fastPathData);
    }

    protected void writeForLoopWithClosureList(ForStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        boolean oldFastPathBlock = this.fastPathBlocked;
        this.fastPathBlocked = true;
        super.writeForLoopWithClosureList(statement);
        this.fastPathBlocked = oldFastPathBlock;
        if (fastPathData == null) {
            return;
        }
        this.writeFastPathPrelude(fastPathData);
        super.writeForLoopWithClosureList(statement);
        this.writeFastPathEpilogue(fastPathData);
    }

    public void writeWhileLoop(WhileStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        boolean oldFastPathBlock = this.fastPathBlocked;
        this.fastPathBlocked = true;
        super.writeWhileLoop(statement);
        this.fastPathBlocked = oldFastPathBlock;
        if (fastPathData == null) {
            return;
        }
        this.writeFastPathPrelude(fastPathData);
        super.writeWhileLoop(statement);
        this.writeFastPathEpilogue(fastPathData);
    }

    public void writeIfElse(IfStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        FastPathData fastPathData = this.writeGuards(meta, statement);
        boolean oldFastPathBlock = this.fastPathBlocked;
        this.fastPathBlocked = true;
        super.writeIfElse(statement);
        this.fastPathBlocked = oldFastPathBlock;
        if (fastPathData == null) {
            return;
        }
        this.writeFastPathPrelude(fastPathData);
        super.writeIfElse(statement);
        this.writeFastPathEpilogue(fastPathData);
    }

    private boolean isNewPathFork(StatementMeta meta) {
        if (meta == null || !meta.optimize) {
            return false;
        }
        if (this.fastPathBlocked) {
            return false;
        }
        return !this.controller.isFastPath();
    }

    public void writeReturn(ReturnStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        if (this.isNewPathFork(meta) && this.writeDeclarationExtraction(statement)) {
            FastPathData fastPathData = this.writeGuards(meta, statement);
            boolean oldFastPathBlock = this.fastPathBlocked;
            this.fastPathBlocked = true;
            super.writeReturn(statement);
            this.fastPathBlocked = oldFastPathBlock;
            if (fastPathData == null) {
                return;
            }
            this.writeFastPathPrelude(fastPathData);
            super.writeReturn(statement);
            this.writeFastPathEpilogue(fastPathData);
        } else {
            super.writeReturn(statement);
        }
    }

    public void writeExpressionStatement(ExpressionStatement statement) {
        StatementMeta meta = (StatementMeta)statement.getNodeMetaData(StatementMeta.class);
        if (this.isNewPathFork(meta) && this.writeDeclarationExtraction(statement)) {
            FastPathData fastPathData = this.writeGuards(meta, statement);
            boolean oldFastPathBlock = this.fastPathBlocked;
            this.fastPathBlocked = true;
            super.writeExpressionStatement(statement);
            this.fastPathBlocked = oldFastPathBlock;
            if (fastPathData == null) {
                return;
            }
            this.writeFastPathPrelude(fastPathData);
            super.writeExpressionStatement(statement);
            this.writeFastPathEpilogue(fastPathData);
        } else {
            super.writeExpressionStatement(statement);
        }
    }

    private boolean writeDeclarationExtraction(Statement statement) {
        Expression ex = null;
        if (statement instanceof ReturnStatement) {
            ReturnStatement rs = (ReturnStatement)statement;
            ex = rs.getExpression();
        } else if (statement instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)statement;
            ex = es.getExpression();
        } else {
            throw new GroovyBugError("unknown statement type :" + statement.getClass());
        }
        if (!(ex instanceof DeclarationExpression)) {
            return true;
        }
        DeclarationExpression declaration = (DeclarationExpression)ex;
        if ((ex = declaration.getLeftExpression()) instanceof TupleExpression) {
            return false;
        }
        this.controller.getCompileStack().defineVariable(declaration.getVariableExpression(), false);
        BinaryExpression assignment = new BinaryExpression(declaration.getLeftExpression(), declaration.getOperation(), declaration.getRightExpression());
        assignment.setSourcePosition(declaration);
        assignment.copyNodeMetaData(declaration);
        if (statement instanceof ReturnStatement) {
            ReturnStatement rs = (ReturnStatement)statement;
            rs.setExpression(assignment);
        } else if (statement instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)statement;
            es.setExpression(assignment);
        } else {
            throw new GroovyBugError("unknown statement type :" + statement.getClass());
        }
        return true;
    }

    public static void setNodeMeta(ClassNode classNode) {
        new OptVisitor().visitClass(classNode);
    }

    private static StatementMeta addMeta(ASTNode node) {
        StatementMeta metaOld = (StatementMeta)node.getNodeMetaData(StatementMeta.class);
        StatementMeta meta = metaOld;
        if (meta == null) {
            meta = new StatementMeta();
        }
        meta.optimize = true;
        meta.optimizeInt = true;
        if (metaOld == null) {
            node.setNodeMetaData(StatementMeta.class, meta);
        }
        return meta;
    }

    private static ClassNode getType(Expression exp) {
        ClassNode type = exp.getType();
        StatementMeta meta = (StatementMeta)exp.getNodeMetaData(StatementMeta.class);
        if (meta == null || meta.type == null) {
            return type;
        }
        return meta.type;
    }

    private static class OptVisitor
    extends ClassCodeVisitorSupport {
        private boolean optimizeInt;
        private ClassNode node;

        private OptVisitor() {
        }

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public void visitClass(ClassNode node) {
            this.node = node;
            super.visitClass(node);
        }

        public void visitReturnStatement(ReturnStatement statement) {
            if (!this.optimizeInt) {
                super.visitReturnStatement(statement);
            }
            if (this.optimizeInt) {
                OptimizingStatementWriter.addMeta(statement);
            }
        }

        public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
            super.visitUnaryMinusExpression(expression);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.type = ClassHelper.OBJECT_TYPE;
        }

        public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
            super.visitUnaryPlusExpression(expression);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.type = ClassHelper.OBJECT_TYPE;
        }

        public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
            super.visitBitwiseNegationExpression(expression);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.type = ClassHelper.OBJECT_TYPE;
        }

        public void visitPrefixExpression(PrefixExpression expression) {
            super.visitPrefixExpression(expression);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.type = ClassHelper.OBJECT_TYPE;
        }

        public void visitPostfixExpression(PostfixExpression expression) {
            super.visitPostfixExpression(expression);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.type = ClassHelper.OBJECT_TYPE;
        }

        public void visitDeclarationExpression(DeclarationExpression expression) {
            Expression right = expression.getRightExpression();
            right.visit(this);
            boolean rightInt = BinaryIntExpressionHelper.isIntOperand(right, this.node);
            boolean leftInt = BinaryIntExpressionHelper.isIntOperand(expression.getLeftExpression(), this.node);
            if (!this.optimizeInt) {
                boolean bl = this.optimizeInt = leftInt && rightInt && !(right instanceof ConstantExpression);
            }
            if (this.optimizeInt) {
                StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
                if (leftInt && rightInt) {
                    meta.type = ClassHelper.int_TYPE;
                }
            }
        }

        public void visitBinaryExpression(BinaryExpression expression) {
            if (expression.getNodeMetaData(StatementMeta.class) != null) {
                return;
            }
            super.visitBinaryExpression(expression);
            boolean leftInt = BinaryIntExpressionHelper.isIntOperand(expression.getLeftExpression(), this.node);
            boolean rightInt = BinaryIntExpressionHelper.isIntOperand(expression.getRightExpression(), this.node);
            if (!this.optimizeInt) {
                boolean bl = this.optimizeInt = leftInt && rightInt;
            }
            if (this.optimizeInt) {
                switch (expression.getOperation().getType()) {
                    case 202: 
                    case 203: 
                    case 206: 
                    case 250: 
                    case 260: {
                        this.optimizeInt = false;
                        break;
                    }
                    case 120: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 162: 
                    case 164: {
                        expression.setType(ClassHelper.boolean_TYPE);
                        break;
                    }
                    case 340: 
                    case 341: 
                    case 342: {
                        expression.setType(ClassHelper.int_TYPE);
                        break;
                    }
                }
            }
            if (this.optimizeInt) {
                StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
                if (leftInt && rightInt) {
                    meta.type = ClassHelper.int_TYPE;
                }
            }
        }

        public void visitExpressionStatement(ExpressionStatement statement) {
            if (statement.getNodeMetaData(StatementMeta.class) != null) {
                return;
            }
            super.visitExpressionStatement(statement);
            if (this.optimizeInt) {
                OptimizingStatementWriter.addMeta(statement);
            }
        }

        public void visitBlockStatement(BlockStatement block) {
            boolean optAll = true;
            for (Statement statement : block.getStatements()) {
                this.optimizeInt = false;
                statement.visit(this);
                optAll = optAll && this.optimizeInt;
            }
            boolean bl = optAll = optAll && !block.isEmpty();
            if (optAll) {
                OptimizingStatementWriter.addMeta(block);
            }
            this.optimizeInt = optAll;
        }

        public void visitIfElse(IfStatement statement) {
            super.visitIfElse(statement);
            if (this.optimizeInt) {
                OptimizingStatementWriter.addMeta(statement);
            }
        }

        public void visitMethodCallExpression(MethodCallExpression expression) {
            if (expression.getNodeMetaData(StatementMeta.class) != null) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!AsmClassGenerator.isThisExpression(expression.getObjectExpression())) {
                return;
            }
            String name = expression.getMethodAsString();
            if (name == null) {
                return;
            }
            Expression callArgs = expression.getArguments();
            Parameter[] paraTypes = null;
            if (callArgs instanceof ArgumentListExpression) {
                ArgumentListExpression args = (ArgumentListExpression)callArgs;
                int size = args.getExpressions().size();
                paraTypes = new Parameter[size];
                int i = 0;
                for (Expression exp : args.getExpressions()) {
                    ClassNode type = OptimizingStatementWriter.getType(exp);
                    paraTypes[i] = new Parameter(type, "");
                    ++i;
                }
            } else {
                ClassNode type = OptimizingStatementWriter.getType(callArgs);
                paraTypes = new Parameter[]{new Parameter(type, "")};
            }
            MethodNode target = this.node.getMethod(name, paraTypes);
            StatementMeta meta = OptimizingStatementWriter.addMeta(expression);
            meta.target = target;
            if (target != null) {
                meta.type = target.getReturnType().redirect();
            }
            if (!this.optimizeInt) {
                meta.optimizeInt = false;
            }
        }

        public void visitClosureExpression(ClosureExpression expression) {
        }
    }

    public static class StatementMeta {
        private boolean optimize = false;
        private boolean optimizeInt = false;
        protected MethodNode target;
        protected ClassNode type;

        public String toString() {
            return "optimize=" + this.optimize + " optimizeInt=" + this.optimizeInt + " target=" + this.target + " type=" + this.type;
        }
    }

    private static class FastPathData {
        private Label pathStart = new Label();
        private Label afterPath = new Label();

        private FastPathData() {
        }
    }
}

