/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.BytecodeSequence;

public class ReturnAdder {
    public static void addReturnIfNeeded(MethodNode node) {
        Statement statement = node.getCode();
        if (!node.isVoidMethod()) {
            if (statement != null) {
                node.setCode(ReturnAdder.addReturnsIfNeeded(statement, node.getVariableScope()));
            }
        } else if (!node.isAbstract() && !(statement instanceof BytecodeSequence)) {
            BlockStatement newBlock = new BlockStatement();
            newBlock.setVariableScope(node.getVariableScope());
            if (statement instanceof BlockStatement) {
                newBlock.addStatements(((BlockStatement)statement).getStatements());
            } else {
                newBlock.addStatement(statement);
            }
            newBlock.addStatement(ReturnStatement.RETURN_NULL_OR_VOID);
            newBlock.setSourcePosition(statement);
            node.setCode(newBlock);
        }
    }

    private static Statement addReturnsIfNeeded(Statement statement, VariableScope scope) {
        if (statement instanceof ReturnStatement || statement instanceof BytecodeSequence || statement instanceof ThrowStatement) {
            return statement;
        }
        if (statement instanceof EmptyStatement) {
            return new ReturnStatement(ConstantExpression.NULL);
        }
        if (statement instanceof ExpressionStatement) {
            ExpressionStatement expStmt = (ExpressionStatement)statement;
            Expression expr = expStmt.getExpression();
            ReturnStatement ret = new ReturnStatement(expr);
            ret.setSourcePosition(expr);
            ret.setStatementLabel(statement.getStatementLabel());
            return ret;
        }
        if (statement instanceof SynchronizedStatement) {
            SynchronizedStatement sync = (SynchronizedStatement)statement;
            sync.setCode(ReturnAdder.addReturnsIfNeeded(sync.getCode(), scope));
            return sync;
        }
        if (statement instanceof IfStatement) {
            IfStatement ifs = (IfStatement)statement;
            ifs.setIfBlock(ReturnAdder.addReturnsIfNeeded(ifs.getIfBlock(), scope));
            ifs.setElseBlock(ReturnAdder.addReturnsIfNeeded(ifs.getElseBlock(), scope));
            return ifs;
        }
        if (statement instanceof SwitchStatement) {
            SwitchStatement swi = (SwitchStatement)statement;
            for (CaseStatement caseStatement : swi.getCaseStatements()) {
                caseStatement.setCode(ReturnAdder.adjustSwitchCaseCode(caseStatement.getCode(), scope));
            }
            swi.setDefaultStatement(ReturnAdder.adjustSwitchCaseCode(swi.getDefaultStatement(), scope));
            return swi;
        }
        if (statement instanceof TryCatchStatement) {
            TryCatchStatement trys = (TryCatchStatement)statement;
            trys.setTryStatement(ReturnAdder.addReturnsIfNeeded(trys.getTryStatement(), scope));
            int len = trys.getCatchStatements().size();
            for (int i = 0; i != len; ++i) {
                CatchStatement catchStatement = trys.getCatchStatement(i);
                catchStatement.setCode(ReturnAdder.addReturnsIfNeeded(catchStatement.getCode(), scope));
            }
            return trys;
        }
        if (statement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement;
            List<Statement> list = block.getStatements();
            if (!list.isEmpty()) {
                int idx = list.size() - 1;
                Statement last = ReturnAdder.addReturnsIfNeeded(list.get(idx), block.getVariableScope());
                list.set(idx, last);
                if (!ReturnAdder.statementReturns(last)) {
                    list.add(new ReturnStatement(ConstantExpression.NULL));
                }
            } else {
                ReturnStatement ret = new ReturnStatement(ConstantExpression.NULL);
                ret.setSourcePosition(block);
                return ret;
            }
            return new BlockStatement(list, block.getVariableScope());
        }
        if (statement == null) {
            return new ReturnStatement(ConstantExpression.NULL);
        }
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.add(statement);
        list.add(new ReturnStatement(ConstantExpression.NULL));
        return new BlockStatement(list, new VariableScope(scope));
    }

    private static Statement adjustSwitchCaseCode(Statement statement, VariableScope scope) {
        int idx;
        Statement last;
        List<Statement> list;
        if (statement instanceof BlockStatement && !(list = ((BlockStatement)statement).getStatements()).isEmpty() && (last = list.get(idx = list.size() - 1)) instanceof BreakStatement) {
            list.remove(idx);
            return ReturnAdder.addReturnsIfNeeded(statement, scope);
        }
        return statement;
    }

    private static boolean statementReturns(Statement last) {
        return last instanceof ReturnStatement || last instanceof BlockStatement || last instanceof IfStatement || last instanceof ExpressionStatement || last instanceof EmptyStatement || last instanceof TryCatchStatement || last instanceof BytecodeSequence || last instanceof ThrowStatement || last instanceof SynchronizedStatement;
    }
}

