/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.HelpFormatter;
import groovyjarjarcommonscli.OptionBuilder;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.PosixParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class FileSystemCompiler {
    private final CompilationUnit unit;

    public FileSystemCompiler(CompilerConfiguration configuration) throws ConfigurationException {
        this(configuration, null);
    }

    public FileSystemCompiler(CompilerConfiguration configuration, CompilationUnit cu) throws ConfigurationException {
        this.unit = cu != null ? cu : (configuration.getJointCompilationOptions() != null ? new JavaAwareCompilationUnit(configuration) : new CompilationUnit(configuration));
    }

    public void compile(String[] paths) throws Exception {
        this.unit.addSources(paths);
        this.unit.compile();
    }

    public void compile(File[] files) throws Exception {
        this.unit.addSources(files);
        this.unit.compile();
    }

    public static void displayHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "groovyc [options] <source-files>", "options:", options, "");
    }

    public static void displayVersion() {
        String version = InvokerHelper.getVersion();
        System.err.println("Groovy compiler version " + version);
        System.err.println("Copyright 2003-2008 The Codehaus. http://groovy.codehaus.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(filenames[i]);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (file.canRead()) continue;
            System.err.println("error: file not readable: " + file);
            ++errors;
        }
        return errors;
    }

    public static boolean validateFiles(String[] filenames) {
        return FileSystemCompiler.checkFiles(filenames) == 0;
    }

    public static void main(String[] args) {
        boolean displayStackTraceOnError = false;
        try {
            boolean fileNameErrors;
            Options options = FileSystemCompiler.createCompilationOptions();
            PosixParser cliParser = new PosixParser();
            CommandLine cli = cliParser.parse(options, args);
            if (cli.hasOption('h')) {
                FileSystemCompiler.displayHelp(options);
                return;
            }
            if (cli.hasOption('v')) {
                FileSystemCompiler.displayVersion();
                return;
            }
            displayStackTraceOnError = cli.hasOption('e');
            CompilerConfiguration configuration = FileSystemCompiler.generateCompilerConfigurationFromOptions(cli);
            String[] filenames = FileSystemCompiler.generateFileNamesFromOptions(cli);
            boolean bl = fileNameErrors = filenames == null;
            if (!fileNameErrors && filenames.length == 0) {
                FileSystemCompiler.displayHelp(options);
                return;
            }
            boolean bl2 = fileNameErrors = fileNameErrors && !FileSystemCompiler.validateFiles(filenames);
            if (!fileNameErrors) {
                FileSystemCompiler.doCompilation(configuration, null, filenames);
            }
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException();
            if (re.getStackTrace().length > 1) {
                if (e instanceof RuntimeException) {
                    re = (RuntimeException)e;
                } else {
                    re.initCause(e);
                }
            }
            new ErrorReporter(e, displayStackTraceOnError).write(System.err);
            System.exit(1);
        }
    }

    public static void doCompilation(CompilerConfiguration configuration, CompilationUnit unit, String[] filenames) throws Exception {
        File tmpDir = null;
        if (configuration.getJointCompilationOptions() != null && !configuration.getJointCompilationOptions().containsKey("stubDir")) {
            tmpDir = FileSystemCompiler.createTempDir();
            configuration.getJointCompilationOptions().put("stubDir", tmpDir);
        }
        FileSystemCompiler compiler = new FileSystemCompiler(configuration, unit);
        compiler.compile(filenames);
        if (tmpDir != null) {
            FileSystemCompiler.deleteRecursive(tmpDir);
        }
    }

    public static String[] generateFileNamesFromOptions(CommandLine cli) {
        String[] filenames = cli.getArgs();
        ArrayList<String> fileList = new ArrayList<String>(filenames.length);
        boolean errors = false;
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i].startsWith("@")) {
                try {
                    String file;
                    BufferedReader br = new BufferedReader(new FileReader(filenames[i].substring(1)));
                    while ((file = br.readLine()) != null) {
                        fileList.add(file);
                    }
                    continue;
                }
                catch (IOException ioe) {
                    System.err.println("error: file not readable: " + filenames[i].substring(1));
                    errors = true;
                    continue;
                }
            }
            fileList.addAll(Arrays.asList(filenames));
        }
        if (errors) {
            return null;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static CompilerConfiguration generateCompilerConfigurationFromOptions(CommandLine cli) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        if (cli.hasOption("classpath")) {
            configuration.setClasspath(cli.getOptionValue("classpath"));
        }
        if (cli.hasOption('d')) {
            configuration.setTargetDirectory(cli.getOptionValue('d'));
        }
        if (cli.hasOption("encoding")) {
            configuration.setSourceEncoding(cli.getOptionValue("encoding"));
        }
        if (cli.hasOption('j')) {
            HashMap<String, String[]> compilerOptions = new HashMap<String, String[]>();
            String[] opts = cli.getOptionValues("J");
            compilerOptions.put("namedValues", opts);
            opts = cli.getOptionValues("F");
            compilerOptions.put("flags", opts);
            configuration.setJointCompilationOptions(compilerOptions);
        }
        return configuration;
    }

    public static Options createCompilationOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt("classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("Specify where to find the class files.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("sourcepath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("Specify where to find the source files.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("temp");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("temp");
        OptionBuilder.withDescription("");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("encoding");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("encoding");
        OptionBuilder.withDescription("Specify the encoding of the user class files.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Specify where to place generated class files.");
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Print a synopsis of standard options.");
        options.addOption(OptionBuilder.create('h'));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Print the version.");
        options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withLongOpt("exception");
        OptionBuilder.withDescription("Print stack trace on error.");
        options.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("jointCompilation");
        OptionBuilder.withDescription("Attach javac compiler to compile .java files.");
        options.addOption(OptionBuilder.create('j'));
        OptionBuilder.withArgName("property=value");
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs(2);
        OptionBuilder.withDescription("");
        options.addOption(OptionBuilder.create("J"));
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("");
        options.addOption(OptionBuilder.create("F"));
        return options;
    }

    public static File createTempDir() throws IOException {
        File tempFile = File.createTempFile("groovy-generated-", "-java-source");
        tempFile.delete();
        tempFile.mkdirs();
        return tempFile;
    }

    public static void deleteRecursive(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileSystemCompiler.deleteRecursive(files[i]);
            }
            file.delete();
        }
    }
}

