/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.callsite;

import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.MethodHandleFactory;
import org.codehaus.groovy.runtime.callsite.CallSiteClassLoader;
import org.codehaus.groovy.runtime.callsite.GroovySunClassLoader;

public class CallSiteGenerator {
    private static final String[] EXCEPTIONS = new String[]{"java/lang/Throwable"};

    private CallSiteGenerator() {
    }

    public static void genCallWithFixedParams(ClassWriter cw, String name, String superClass, CachedMethod cachedMethod, String receiverType) {
        if (cachedMethod.getParamsCount() <= 4) {
            StringBuilder pdescb = new StringBuilder();
            int pc = cachedMethod.getParamsCount();
            for (int i = 0; i != pc; ++i) {
                pdescb.append("Ljava/lang/Object;");
            }
            String pdesc = pdescb.toString();
            MethodVisitor mv = cw.visitMethod(1, "call" + name, "(L" + receiverType + ";" + pdesc + ")Ljava/lang/Object;", null, EXCEPTIONS);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            for (int i = 0; i != pc; ++i) {
                mv.visitVarInsn(25, i + 2);
            }
            mv.visitMethodInsn(182, superClass, "checkCall", "(Ljava/lang/Object;" + pdesc + ")Z");
            Label l0 = new Label();
            mv.visitJumpInsn(153, l0);
            BytecodeHelper helper = new BytecodeHelper(mv);
            Class callClass = cachedMethod.getDeclaringClass().getTheClass();
            boolean useInterface = callClass.isInterface();
            String type = BytecodeHelper.getClassInternalName(callClass.getName());
            String descriptor = BytecodeHelper.getMethodDescriptor(cachedMethod.getReturnType(), cachedMethod.getNativeParameterTypes());
            if (cachedMethod.isStatic()) {
                MethodHandleFactory.genLoadParametersDirect(2, mv, helper, cachedMethod.setAccessible());
                mv.visitMethodInsn(184, type, cachedMethod.getName(), descriptor);
            } else {
                mv.visitVarInsn(25, 1);
                helper.doCast(callClass);
                MethodHandleFactory.genLoadParametersDirect(2, mv, helper, cachedMethod.setAccessible());
                mv.visitMethodInsn(useInterface ? 185 : 182, type, cachedMethod.getName(), descriptor);
            }
            helper.box(cachedMethod.getReturnType());
            if (cachedMethod.getReturnType() == Void.TYPE) {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            for (int i = 0; i != pc; ++i) {
                mv.visitVarInsn(25, i + 2);
            }
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/ArrayUtil", "createArray", "(" + pdesc + ")[Ljava/lang/Object;");
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/callsite/CallSiteArray", "defaultCall" + name, "(Lorg/codehaus/groovy/runtime/callsite/CallSite;L" + receiverType + ";[Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    public static void getCallXxxWithArray(ClassWriter cw, String name, String superClass, CachedMethod cachedMethod, String receiverType) {
        MethodVisitor mv = cw.visitMethod(1, "call" + name, "(L" + receiverType + ";[Ljava/lang/Object;)Ljava/lang/Object;", null, EXCEPTIONS);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, superClass, "checkCall", "(Ljava/lang/Object;[Ljava/lang/Object;)Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        BytecodeHelper helper = new BytecodeHelper(mv);
        Class callClass = cachedMethod.getDeclaringClass().getTheClass();
        boolean useInterface = callClass.isInterface();
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(cachedMethod.getReturnType(), cachedMethod.getNativeParameterTypes());
        if (cachedMethod.isStatic()) {
            MethodHandleFactory.genLoadParameters(2, mv, helper, cachedMethod.setAccessible());
            mv.visitMethodInsn(184, type, cachedMethod.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 1);
            helper.doCast(callClass);
            MethodHandleFactory.genLoadParameters(2, mv, helper, cachedMethod.setAccessible());
            mv.visitMethodInsn(useInterface ? 185 : 182, type, cachedMethod.getName(), descriptor);
        }
        helper.box(cachedMethod.getReturnType());
        if (cachedMethod.getReturnType() == Void.TYPE) {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/callsite/CallSiteArray", "defaultCall" + name, "(Lorg/codehaus/groovy/runtime/callsite/CallSite;L" + receiverType + ";[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void genConstructor(ClassWriter cw, String superClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, superClass, "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static byte[] genPogoMetaMethodSite(CachedMethod cachedMethod, ClassWriter cw, String name) {
        cw.visit(48, 4097, name.replace('.', '/'), null, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", null);
        CallSiteGenerator.genConstructor(cw, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite");
        CallSiteGenerator.getCallXxxWithArray(cw, "Current", "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", cachedMethod, "groovy/lang/GroovyObject");
        CallSiteGenerator.getCallXxxWithArray(cw, "", "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", cachedMethod, "java/lang/Object");
        CallSiteGenerator.genCallWithFixedParams(cw, "Current", "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", cachedMethod, "groovy/lang/GroovyObject");
        CallSiteGenerator.genCallWithFixedParams(cw, "", "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", cachedMethod, "java/lang/Object");
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] genPojoMetaMethodSite(CachedMethod cachedMethod, ClassWriter cw, String name) {
        cw.visit(48, 4097, name.replace('.', '/'), null, "org/codehaus/groovy/runtime/callsite/PojoMetaMethodSite", null);
        CallSiteGenerator.genConstructor(cw, "org/codehaus/groovy/runtime/callsite/PojoMetaMethodSite");
        CallSiteGenerator.getCallXxxWithArray(cw, "", "org/codehaus/groovy/runtime/callsite/PojoMetaMethodSite", cachedMethod, "java/lang/Object");
        CallSiteGenerator.genCallWithFixedParams(cw, "", "org/codehaus/groovy/runtime/callsite/PojoMetaMethodSite", cachedMethod, "java/lang/Object");
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] genStaticMetaMethodSite(CachedMethod cachedMethod, ClassWriter cw, String name) {
        cw.visit(48, 4097, name.replace('.', '/'), null, "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", null);
        CallSiteGenerator.genConstructor(cw, "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite");
        CallSiteGenerator.getCallXxxWithArray(cw, "", "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", cachedMethod, "java/lang/Object");
        CallSiteGenerator.getCallXxxWithArray(cw, "Static", "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", cachedMethod, "java/lang/Class");
        CallSiteGenerator.genCallWithFixedParams(cw, "", "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", cachedMethod, "java/lang/Object");
        CallSiteGenerator.genCallWithFixedParams(cw, "Static", "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", cachedMethod, "java/lang/Class");
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static Constructor compilePogoMethod(CachedMethod cachedMethod) {
        ClassWriter cw = new ClassWriter(true);
        CachedClass declClass = cachedMethod.getDeclaringClass();
        CallSiteClassLoader callSiteLoader = declClass.getCallSiteLoader();
        String name = callSiteLoader.createClassName(cachedMethod.setAccessible());
        byte[] bytes = CallSiteGenerator.genPogoMetaMethodSite(cachedMethod, cw, name);
        return callSiteLoader.defineClassAndGetConstructor(name, bytes);
    }

    public static Constructor compilePojoMethod(CachedMethod cachedMethod) {
        ClassWriter cw = new ClassWriter(true);
        CachedClass declClass = cachedMethod.getDeclaringClass();
        CallSiteClassLoader callSiteLoader = declClass.getCallSiteLoader();
        String name = callSiteLoader.createClassName(cachedMethod.setAccessible());
        byte[] bytes = CallSiteGenerator.genPojoMetaMethodSite(cachedMethod, cw, name);
        return callSiteLoader.defineClassAndGetConstructor(name, bytes);
    }

    public static Constructor compileStaticMethod(CachedMethod cachedMethod) {
        ClassWriter cw = new ClassWriter(true);
        CachedClass declClass = cachedMethod.getDeclaringClass();
        CallSiteClassLoader callSiteLoader = declClass.getCallSiteLoader();
        String name = callSiteLoader.createClassName(cachedMethod.setAccessible());
        byte[] bytes = CallSiteGenerator.genStaticMetaMethodSite(cachedMethod, cw, name);
        return callSiteLoader.defineClassAndGetConstructor(name, bytes);
    }

    public static boolean isCompilable(CachedMethod method) {
        return GroovySunClassLoader.sunVM != null || Modifier.isPublic(method.cachedClass.getModifiers()) && method.isPublic() && CallSiteGenerator.publicParams(method);
    }

    private static boolean publicParams(CachedMethod method) {
        for (Class nativeParamType : method.getNativeParameterTypes()) {
            if (Modifier.isPublic(nativeParamType.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

