/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.xml.QName;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class XmlNodePrinter {
    protected final IndentPrinter out;
    private String quote;
    private boolean namespaceAware = true;

    public XmlNodePrinter(PrintWriter out) {
        this(out, "  ");
    }

    public XmlNodePrinter(PrintWriter out, String indent) {
        this(out, indent, "\"");
    }

    public XmlNodePrinter(PrintWriter out, String indent, String quote) {
        this(new IndentPrinter(out, indent), quote);
    }

    public XmlNodePrinter(IndentPrinter out, String quote) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 'IndentPrinter out' must not be null!");
        }
        this.out = out;
        this.quote = quote;
    }

    public XmlNodePrinter() {
        this(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public String getNameOfNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        Object name = node.name();
        if (name instanceof QName) {
            QName qname = (QName)name;
            if (!this.namespaceAware) {
                return qname.getLocalPart();
            }
            return qname.getQualifiedName();
        }
        return name.toString();
    }

    public boolean isEmptyElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        if (!node.children().isEmpty()) {
            return false;
        }
        return node.text().length() == 0;
    }

    public void print(Node node) {
        this.print(node, new NamespaceContext());
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    protected void print(Node node, NamespaceContext ctx) {
        if (this.isEmptyElement(node)) {
            this.printLineBegin();
            this.out.print("<");
            this.out.print(this.getNameOfNode(node));
            if (ctx != null) {
                this.printNamespace(node, ctx);
            }
            this.printNameAttributes(node.attributes());
            this.out.print("/>");
            this.printLineEnd();
            this.out.flush();
            return;
        }
        if (this.printSpecialNode(node)) {
            this.out.flush();
            return;
        }
        Object value = node.value();
        if (value instanceof List) {
            this.printName(node, ctx, true);
            this.printList((List)value, ctx);
            this.printName(node, ctx, false);
            this.out.flush();
            return;
        }
        this.printName(node, ctx, true);
        this.printSimpleItemWithIndent(value);
        this.printName(node, ctx, false);
        this.out.flush();
    }

    protected void printLineBegin() {
        this.out.printIndent();
    }

    protected void printLineEnd() {
        this.printLineEnd(null);
    }

    protected void printLineEnd(String comment) {
        if (comment != null) {
            this.out.print(" <!-- ");
            this.out.print(comment);
            this.out.print(" -->");
        }
        this.out.print("\n");
    }

    protected void printList(List list, NamespaceContext ctx) {
        this.out.incrementIndent();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            NamespaceContext context = new NamespaceContext(ctx);
            Object value = iter.next();
            if (value instanceof Node) {
                this.print((Node)value, context);
                continue;
            }
            this.printSimpleItem(value);
        }
        this.out.decrementIndent();
    }

    private void printSimpleItemWithIndent(Object value) {
        this.out.incrementIndent();
        this.printSimpleItem(value);
        this.out.decrementIndent();
    }

    protected void printSimpleItem(Object value) {
        this.printLineBegin();
        this.printEscaped(InvokerHelper.toString(value));
        this.printLineEnd();
    }

    protected void printName(Node node, NamespaceContext ctx, boolean begin) {
        if (node == null) {
            throw new NullPointerException("Node must not be null.");
        }
        Object name = node.name();
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.printLineBegin();
        this.out.print("<");
        if (!begin) {
            this.out.print("/");
        }
        this.out.print(this.getNameOfNode(node));
        if (ctx != null) {
            this.printNamespace(node, ctx);
        }
        if (begin) {
            this.printNameAttributes(node.attributes());
        }
        this.out.print(">");
        this.printLineEnd();
    }

    protected void printNameAttributes(Map attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            this.out.print(" ");
            this.out.print(entry.getKey().toString());
            this.out.print("=");
            Object value = entry.getValue();
            this.out.print(this.quote);
            if (value instanceof String) {
                this.printEscaped((String)value);
            } else {
                this.printEscaped(InvokerHelper.toString(value));
            }
            this.out.print(this.quote);
        }
    }

    private void printEscaped(String s) {
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    this.out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    this.out.print("&gt;");
                    continue block7;
                }
                case '&': {
                    this.out.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    if (this.quote.equals("'")) {
                        this.out.print("&apos;");
                        continue block7;
                    }
                    this.out.print(c);
                    continue block7;
                }
                case '\"': {
                    if (this.quote.equals("\"")) {
                        this.out.print("&quot;");
                        continue block7;
                    }
                    this.out.print(c);
                    continue block7;
                }
                default: {
                    this.out.print(c);
                }
            }
        }
    }

    protected boolean printSpecialNode(Node node) {
        return false;
    }

    protected void printNamespace(Node node, NamespaceContext ctx) {
        QName qname;
        String namespaceUri;
        Object name = node.name();
        if (name instanceof QName && this.namespaceAware && (namespaceUri = (qname = (QName)name).getNamespaceURI()) != null) {
            String prefix = qname.getPrefix();
            if (!ctx.isNamespaceRegistered(namespaceUri)) {
                ctx.registerNamespacePrefix(namespaceUri, prefix);
                this.out.print(" ");
                this.out.print("xmlns");
                if (prefix.length() > 0) {
                    this.out.print(":");
                    this.out.print(prefix);
                }
                this.out.print("=" + this.quote);
                this.out.print(namespaceUri);
                this.out.print(this.quote);
            }
        }
    }

    private class NamespaceContext {
        private final Map namespaceMap = new HashMap();

        private NamespaceContext() {
        }

        private NamespaceContext(NamespaceContext context) {
            this();
            this.namespaceMap.putAll(context.namespaceMap);
        }

        public boolean isNamespaceRegistered(String uri) {
            return this.namespaceMap.containsKey(uri);
        }

        public void registerNamespacePrefix(String uri, String prefix) {
            if (!this.isNamespaceRegistered(uri)) {
                this.namespaceMap.put(uri, prefix);
            }
        }

        public String getNamespacePrefix(String uri) {
            Object prefix = this.namespaceMap.get(uri);
            return prefix == null ? null : prefix.toString();
        }
    }
}

