/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.util.AbstractFactory;
import groovy.util.Factory;
import groovy.util.FactoryInterceptorMetaClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExceptionNoStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FactoryBuilderSupport
extends Binding {
    public static final String CURRENT_FACTORY = "_CURRENT_FACTORY_";
    public static final String PARENT_FACTORY = "_PARENT_FACTORY_";
    public static final String PARENT_NODE = "_PARENT_NODE_";
    public static final String CURRENT_NODE = "_CURRENT_NODE_";
    public static final String PARENT_CONTEXT = "_PARENT_CONTEXT_";
    public static final String PARENT_NAME = "_PARENT_NAME_";
    public static final String CURRENT_NAME = "_CURRENT_NAME_";
    public static final String OWNER = "owner";
    public static final String PARENT_BUILDER = "_PARENT_BUILDER_";
    public static final String CURRENT_BUILDER = "_CURRENT_BUILDER_";
    public static final String CHILD_BUILDER = "_CHILD_BUILDER_";
    private static final Logger LOG = Logger.getLogger(FactoryBuilderSupport.class.getName());
    private LinkedList<Map<String, Object>> contexts = new LinkedList();
    protected LinkedList<Closure> attributeDelegates = new LinkedList();
    private List<Closure> disposalClosures = new ArrayList<Closure>();
    private Map<String, Factory> factories = new HashMap<String, Factory>();
    private Closure nameMappingClosure;
    private FactoryBuilderSupport proxyBuilder;
    protected LinkedList<Closure> preInstantiateDelegates = new LinkedList();
    protected LinkedList<Closure> postInstantiateDelegates = new LinkedList();
    protected LinkedList<Closure> postNodeCompletionDelegates = new LinkedList();
    protected Map<String, Closure[]> explicitProperties = new HashMap<String, Closure[]>();
    protected Map<String, Closure> explicitMethods = new HashMap<String, Closure>();
    protected Map<String, Set<String>> registrationGroup = new HashMap<String, Set<String>>();
    protected String registringGroupName = "";
    protected boolean autoRegistrationRunning = false;
    protected boolean autoRegistrationComplete = false;

    public static void checkValueIsNull(Object value, Object name) {
        if (value != null) {
            throw new RuntimeException("'" + name + "' elements do not accept a value argument.");
        }
    }

    public static boolean checkValueIsType(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName());
        }
        return false;
    }

    public static boolean checkValueIsTypeNotString(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            if (value instanceof String) {
                return false;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName() + " or a String.");
        }
        return false;
    }

    public FactoryBuilderSupport() {
        this(false);
    }

    public FactoryBuilderSupport(boolean init) {
        this.proxyBuilder = this;
        this.registrationGroup.put(this.registringGroupName, new TreeSet());
        if (init) {
            this.autoRegisterNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoRegisterNodes() {
        FactoryBuilderSupport factoryBuilderSupport = this;
        synchronized (factoryBuilderSupport) {
            if (this.autoRegistrationRunning || this.autoRegistrationComplete) {
                return;
            }
        }
        this.autoRegistrationRunning = true;
        try {
            for (Method method : this.getClass().getMethods()) {
                if (!method.getName().startsWith("register") || method.getParameterTypes().length != 0) continue;
                this.registringGroupName = method.getName().substring("register".length());
                this.registrationGroup.put(this.registringGroupName, new TreeSet());
                try {
                    method.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cound not init " + this.getClass().getName() + " because of an access error in " + method.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Cound not init " + this.getClass().getName() + " because of an exception in " + method.getName(), e);
                }
                finally {
                    this.registringGroupName = "";
                }
            }
        }
        finally {
            this.autoRegistrationComplete = true;
            this.autoRegistrationRunning = false;
        }
    }

    @Deprecated
    public FactoryBuilderSupport(Closure nameMappingClosure) {
        this.proxyBuilder = this;
        this.nameMappingClosure = nameMappingClosure;
    }

    @Override
    public Object getVariable(String name) {
        return this.proxyBuilder.doGetVariable(name);
    }

    private Object doGetVariable(String name) {
        return super.getVariable(name);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.proxyBuilder.doSetVariable(name, value);
    }

    private void doSetVariable(String name, Object value) {
        super.setVariable(name, value);
    }

    @Override
    public Map getVariables() {
        return this.proxyBuilder.doGetVariables();
    }

    private Map doGetVariables() {
        return super.getVariables();
    }

    @Override
    public Object getProperty(String property) {
        try {
            return this.proxyBuilder.doGetProperty(property);
        }
        catch (MissingPropertyException mpe) {
            if (this.getContext() != null && this.getContext().containsKey(property)) {
                return this.getContext().get(property);
            }
            return this.getMetaClass().getProperty(this, property);
        }
    }

    private Object doGetProperty(String property) {
        Closure[] accessors = this.resolveExplicitProperty(property);
        if (accessors != null) {
            if (accessors[0] == null) {
                throw new MissingPropertyException(property + " is declared as write only");
            }
            return accessors[0].call();
        }
        return super.getProperty(property);
    }

    @Override
    public void setProperty(String property, Object newValue) {
        this.proxyBuilder.doSetProperty(property, newValue);
    }

    private void doSetProperty(String property, Object newValue) {
        Closure[] accessors = this.resolveExplicitProperty(property);
        if (accessors != null) {
            if (accessors[1] == null) {
                throw new MissingPropertyException(property + " is declared as read only");
            }
            accessors[1].call(newValue);
        } else {
            super.setProperty(property, newValue);
        }
    }

    public Map<String, Factory> getFactories() {
        return Collections.unmodifiableMap(this.proxyBuilder.factories);
    }

    public Map<String, Closure> getExplicitMethods() {
        return Collections.unmodifiableMap(this.proxyBuilder.explicitMethods);
    }

    public Map<String, Closure[]> getExplicitProperties() {
        return Collections.unmodifiableMap(this.proxyBuilder.explicitProperties);
    }

    public Map<String, Factory> getLocalFactories() {
        return Collections.unmodifiableMap(this.factories);
    }

    public Map<String, Closure> getLocalExplicitMethods() {
        return Collections.unmodifiableMap(this.explicitMethods);
    }

    public Map<String, Closure[]> getLocalExplicitProperties() {
        return Collections.unmodifiableMap(this.explicitProperties);
    }

    public Set<String> getRegistrationGroups() {
        return Collections.unmodifiableSet(this.registrationGroup.keySet());
    }

    public Set<String> getRegistrationGroupItems(String group) {
        Set<String> groupSet = this.registrationGroup.get(group);
        if (groupSet != null) {
            return Collections.unmodifiableSet(groupSet);
        }
        return Collections.emptySet();
    }

    public List<Closure> getAttributeDelegates() {
        return Collections.unmodifiableList(this.attributeDelegates);
    }

    public List<Closure> getPreInstantiateDelegates() {
        return Collections.unmodifiableList(this.preInstantiateDelegates);
    }

    public List<Closure> getPostInstantiateDelegates() {
        return Collections.unmodifiableList(this.postInstantiateDelegates);
    }

    public List<Closure> getPostNodeCompletionDelegates() {
        return Collections.unmodifiableList(this.postNodeCompletionDelegates);
    }

    public Map<String, Object> getContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return this.proxyBuilder.contexts.getFirst();
        }
        return null;
    }

    public Object getCurrent() {
        return this.getContextAttribute(CURRENT_NODE);
    }

    public Factory getCurrentFactory() {
        return (Factory)this.getContextAttribute(CURRENT_FACTORY);
    }

    public String getCurrentName() {
        return (String)this.getContextAttribute(CURRENT_NAME);
    }

    public FactoryBuilderSupport getCurrentBuilder() {
        return (FactoryBuilderSupport)this.getContextAttribute(CURRENT_BUILDER);
    }

    public Object getParentNode() {
        return this.getContextAttribute(PARENT_NODE);
    }

    public Factory getParentFactory() {
        return (Factory)this.getContextAttribute(PARENT_FACTORY);
    }

    public Map getParentContext() {
        return (Map)this.getContextAttribute(PARENT_CONTEXT);
    }

    public String getParentName() {
        return (String)this.getContextAttribute(PARENT_NAME);
    }

    public FactoryBuilderSupport getChildBuilder() {
        return (FactoryBuilderSupport)this.getContextAttribute(CHILD_BUILDER);
    }

    public Object getContextAttribute(String key) {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map<String, Object> context = this.proxyBuilder.contexts.getFirst();
            return context.get(key);
        }
        return null;
    }

    public Object invokeMethod(String methodName) {
        return this.proxyBuilder.invokeMethod(methodName, null);
    }

    @Override
    public Object invokeMethod(String methodName, Object args) {
        Object result;
        Object name = this.proxyBuilder.getName(methodName);
        Map<String, Object> previousContext = this.proxyBuilder.getContext();
        try {
            result = this.proxyBuilder.doInvokeMethod(methodName, name, args);
        }
        catch (RuntimeException e) {
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                Map<String, Object> context = this.proxyBuilder.getContext();
                while (context != null && context != previousContext) {
                    this.proxyBuilder.popContext();
                    context = this.proxyBuilder.getContext();
                }
            }
            throw e;
        }
        return result;
    }

    public Closure addAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.addFirst(attrDelegate);
        return attrDelegate;
    }

    public void removeAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.remove(attrDelegate);
    }

    public Closure addPreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.remove(delegate);
    }

    public Closure addPostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.remove(delegate);
    }

    public Closure addPostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.remove(delegate);
    }

    public void registerExplicitProperty(String name, Closure getter, Closure setter) {
        this.registerExplicitProperty(name, this.registringGroupName, getter, setter);
    }

    public void registerExplicitProperty(String name, String groupName, Closure getter, Closure setter) {
        if (getter != null) {
            getter.setDelegate(this);
        }
        if (setter != null) {
            setter.setDelegate(this);
        }
        this.explicitProperties.put(name, new Closure[]{getter, setter});
        String methodNameBase = MetaClassHelper.capitalize(name);
        if (getter != null) {
            this.registrationGroup.get(groupName).add("get" + methodNameBase);
        }
        if (setter != null) {
            this.registrationGroup.get(groupName).add("set" + methodNameBase);
        }
    }

    public void registerExplicitMethod(String name, Closure closure) {
        this.registerExplicitMethod(name, this.registringGroupName, closure);
    }

    public void registerExplicitMethod(String name, String groupName, Closure closure) {
        closure.setDelegate(this);
        this.explicitMethods.put(name, closure);
        this.registrationGroup.get(groupName).add(name);
    }

    public void registerBeanFactory(String theName, Class beanClass) {
        this.registerBeanFactory(theName, this.registringGroupName, beanClass);
    }

    public void registerBeanFactory(String theName, String groupName, final Class beanClass) {
        this.proxyBuilder.registerFactory(theName, new AbstractFactory(){

            public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
                if (FactoryBuilderSupport.checkValueIsTypeNotString(value, name, beanClass)) {
                    return value;
                }
                return beanClass.newInstance();
            }
        });
        this.registrationGroup.get(groupName).add(theName);
    }

    public void registerFactory(String name, Factory factory) {
        this.registerFactory(name, this.registringGroupName, factory);
    }

    public void registerFactory(String name, String groupName, Factory factory) {
        this.proxyBuilder.factories.put(name, factory);
        this.registrationGroup.get(groupName).add(name);
        factory.onFactoryRegistration(this, name, groupName);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object node;
        Factory factory = this.proxyBuilder.resolveFactory(name, attributes, value);
        if (factory == null) {
            LOG.log(Level.WARNING, "Could not find match for name '" + name + "'");
            throw new MissingMethodExceptionNoStack((String)name, Object.class, new Object[]{attributes, value});
        }
        this.proxyBuilder.getContext().put(CURRENT_FACTORY, factory);
        this.proxyBuilder.getContext().put(CURRENT_NAME, String.valueOf(name));
        this.proxyBuilder.preInstantiate(name, attributes, value);
        try {
            node = factory.newInstance(this.proxyBuilder.getChildBuilder(), name, value, attributes);
            if (node == null) {
                LOG.log(Level.WARNING, "Factory for name '" + name + "' returned null");
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("For name: " + name + " created node: " + node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        this.proxyBuilder.postInstantiate(name, attributes, node);
        this.proxyBuilder.handleNodeAttributes(node, attributes);
        return node;
    }

    protected Factory resolveFactory(Object name, Map attributes, Object value) {
        this.proxyBuilder.getContext().put(CHILD_BUILDER, this.proxyBuilder);
        return this.proxyBuilder.factories.get(name);
    }

    protected Closure resolveExplicitMethod(String methodName, Object args) {
        return this.explicitMethods.get(methodName);
    }

    protected Closure[] resolveExplicitProperty(String propertyName) {
        return this.explicitProperties.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInvokeMethod(String methodName, Object name, Object args) {
        Object node;
        Closure explicitMethod = this.resolveExplicitMethod(methodName, args);
        if (explicitMethod != null) {
            if (args instanceof Object[]) {
                return explicitMethod.call((Object[])args);
            }
            return explicitMethod.call(args);
        }
        Closure closure = null;
        List list = InvokerHelper.asList(args);
        LinkedList<Map<String, Object>> linkedList = this.proxyBuilder.contexts;
        synchronized (linkedList) {
            if (this.proxyBuilder.getContexts().isEmpty()) {
                this.proxyBuilder.newContext();
            }
            try {
                Map namedArgs = Collections.EMPTY_MAP;
                if (list.size() > 0 && list.get(0) instanceof LinkedHashMap) {
                    namedArgs = (Map)list.get(0);
                    list = list.subList(1, list.size());
                }
                if (list.size() > 0 && list.get(list.size() - 1) instanceof Closure) {
                    closure = (Closure)list.get(list.size() - 1);
                    list = list.subList(0, list.size() - 1);
                }
                Object arg = list.size() == 0 ? null : (list.size() == 1 ? list.get(0) : list);
                node = this.proxyBuilder.createNode(name, namedArgs, arg);
                Object current = this.proxyBuilder.getCurrent();
                if (current != null) {
                    this.proxyBuilder.setParent(current, node);
                }
                if (closure != null) {
                    Factory parentFactory = this.proxyBuilder.getCurrentFactory();
                    if (parentFactory.isLeaf()) {
                        throw new RuntimeException("'" + name + "' doesn't support nesting.");
                    }
                    boolean processContent = true;
                    if (parentFactory.isHandlesNodeChildren()) {
                        processContent = parentFactory.onNodeChildren(this, node, closure);
                    }
                    if (processContent) {
                        String parentName = this.proxyBuilder.getCurrentName();
                        Map<String, Object> parentContext = this.proxyBuilder.getContext();
                        this.proxyBuilder.newContext();
                        try {
                            this.proxyBuilder.getContext().put(OWNER, closure.getOwner());
                            this.proxyBuilder.getContext().put(CURRENT_NODE, node);
                            this.proxyBuilder.getContext().put(PARENT_FACTORY, parentFactory);
                            this.proxyBuilder.getContext().put(PARENT_NODE, current);
                            this.proxyBuilder.getContext().put(PARENT_CONTEXT, parentContext);
                            this.proxyBuilder.getContext().put(PARENT_NAME, parentName);
                            this.proxyBuilder.getContext().put(PARENT_BUILDER, parentContext.get(CURRENT_BUILDER));
                            this.proxyBuilder.getContext().put(CURRENT_BUILDER, parentContext.get(CHILD_BUILDER));
                            this.proxyBuilder.setClosureDelegate(closure, node);
                            closure.call();
                        }
                        finally {
                            this.proxyBuilder.popContext();
                        }
                    }
                }
                this.proxyBuilder.nodeCompleted(current, node);
                node = this.proxyBuilder.postNodeCompletion(current, node);
            }
            finally {
                if (this.proxyBuilder.getContexts().size() == 1) {
                    this.proxyBuilder.popContext();
                }
            }
        }
        return node;
    }

    public Object getName(String methodName) {
        if (this.proxyBuilder.nameMappingClosure != null) {
            return this.proxyBuilder.nameMappingClosure.call(methodName);
        }
        return methodName;
    }

    protected FactoryBuilderSupport getProxyBuilder() {
        return this.proxyBuilder;
    }

    public Closure getNameMappingClosure() {
        return this.nameMappingClosure;
    }

    public void setNameMappingClosure(Closure nameMappingClosure) {
        this.nameMappingClosure = nameMappingClosure;
    }

    protected void handleNodeAttributes(Object node, Map attributes) {
        if (node == null) {
            return;
        }
        for (Closure attrDelegate : this.proxyBuilder.attributeDelegates) {
            FactoryBuilderSupport builder = this;
            if (attrDelegate.getOwner() instanceof FactoryBuilderSupport) {
                builder = (FactoryBuilderSupport)attrDelegate.getOwner();
            } else if (attrDelegate.getDelegate() instanceof FactoryBuilderSupport) {
                builder = (FactoryBuilderSupport)attrDelegate.getDelegate();
            }
            attrDelegate.call(new Object[]{builder, node, attributes});
        }
        if (this.proxyBuilder.getCurrentFactory().onHandleNodeAttributes(this.proxyBuilder.getChildBuilder(), node, attributes)) {
            this.proxyBuilder.setNodeAttributes(node, attributes);
        }
    }

    protected void newContext() {
        this.proxyBuilder.contexts.addFirst(new HashMap());
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.proxyBuilder.getCurrentFactory().onNodeCompleted(this.proxyBuilder.getChildBuilder(), parent, node);
    }

    protected Map<String, Object> popContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return this.proxyBuilder.contexts.removeFirst();
        }
        return null;
    }

    protected void postInstantiate(Object name, Map attributes, Object node) {
        for (Closure postInstantiateDelegate : this.proxyBuilder.postInstantiateDelegates) {
            postInstantiateDelegate.call(new Object[]{this, attributes, node});
        }
    }

    protected Object postNodeCompletion(Object parent, Object node) {
        for (Closure postNodeCompletionDelegate : this.proxyBuilder.postNodeCompletionDelegates) {
            postNodeCompletionDelegate.call(new Object[]{this, parent, node});
        }
        return node;
    }

    protected void preInstantiate(Object name, Map attributes, Object value) {
        for (Closure preInstantiateDelegate : this.proxyBuilder.preInstantiateDelegates) {
            preInstantiateDelegate.call(new Object[]{this, attributes, value});
        }
    }

    protected void reset() {
        this.proxyBuilder.contexts.clear();
    }

    protected void setClosureDelegate(Closure closure, Object node) {
        closure.setDelegate(this);
    }

    protected void setNodeAttributes(Object node, Map attributes) {
        for (Map.Entry entry : attributes.entrySet()) {
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setProperty(node, property, value);
        }
    }

    protected void setParent(Object parent, Object child) {
        this.proxyBuilder.getCurrentFactory().setParent(this.proxyBuilder.getChildBuilder(), parent, child);
        Factory parentFactory = this.proxyBuilder.getParentFactory();
        if (parentFactory != null) {
            parentFactory.setChild(this.proxyBuilder.getCurrentBuilder(), parent, child);
        }
    }

    protected void setProxyBuilder(FactoryBuilderSupport proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }

    protected LinkedList<? extends Map<String, Object>> getContexts() {
        return this.proxyBuilder.contexts;
    }

    public Object build(Class viewClass) {
        if (Script.class.isAssignableFrom(viewClass)) {
            Script script = InvokerHelper.createScript(viewClass, this);
            return this.build(script);
        }
        throw new RuntimeException("Only scripts can be executed via build(Class)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object build(Script script) {
        Script script2 = script;
        synchronized (script2) {
            MetaClass scriptMetaClass = script.getMetaClass();
            script.setMetaClass(new FactoryInterceptorMetaClass(scriptMetaClass, this));
            script.setBinding(this);
            return script.run();
        }
    }

    public Object build(String script, GroovyClassLoader loader) {
        return this.build(loader.parseClass(script));
    }

    public Object withBuilder(FactoryBuilderSupport builder, Closure closure) {
        if (builder == null || closure == null) {
            return null;
        }
        Object result = null;
        Map<String, Object> previousContext = this.proxyBuilder.getContext();
        FactoryBuilderSupport previousProxyBuilder = this.proxyBuilder;
        try {
            this.proxyBuilder = builder;
            closure.setDelegate(builder);
            result = closure.call();
        }
        catch (RuntimeException e) {
            this.proxyBuilder = previousProxyBuilder;
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                Map<String, Object> context = this.proxyBuilder.getContext();
                while (context != null && context != previousContext) {
                    this.proxyBuilder.popContext();
                    context = this.proxyBuilder.getContext();
                }
            }
            throw e;
        }
        finally {
            this.proxyBuilder = previousProxyBuilder;
        }
        return result;
    }

    public Object withBuilder(FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{result});
    }

    public Object withBuilder(Map attributes, FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{attributes, result});
    }

    public void addDisposalClosure(Closure closure) {
        this.disposalClosures.add(closure);
    }

    public void dispose() {
        for (int i = this.disposalClosures.size() - 1; i >= 0; --i) {
            this.disposalClosures.get(i).call();
        }
    }
}

