/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.syntax.RuntimeParserException;

public class VerifierCodeVisitor
extends CodeVisitorSupport
implements Opcodes {
    private Verifier verifier;

    VerifierCodeVisitor(Verifier verifier) {
        this.verifier = verifier;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
    }

    public void visitForLoop(ForStatement expression) {
        VerifierCodeVisitor.assertValidIdentifier(expression.getVariable().getName(), "for loop variable name", expression);
        super.visitForLoop(expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        super.visitPropertyExpression(expression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (!expression.getField().isSynthetic()) {
            VerifierCodeVisitor.assertValidIdentifier(expression.getFieldName(), "field name", expression);
        }
        super.visitFieldExpression(expression);
    }

    public void visitVariableExpression(VariableExpression expression) {
        VerifierCodeVisitor.assertValidIdentifier(expression.getName(), "variable name", expression);
        super.visitVariableExpression(expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        super.visitBinaryExpression(expression);
    }

    public static void assertValidIdentifier(String name, String message, ASTNode node) {
        int size = name.length();
        if (size <= 0) {
            throw new RuntimeParserException("Invalid " + message + ". Identifier must not be empty", node);
        }
        char firstCh = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstCh) || firstCh == '$') {
            throw new RuntimeParserException("Invalid " + message + ". Must start with a letter but was: " + name, node);
        }
        for (int i = 1; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            throw new RuntimeParserException("Invalid " + message + ". Invalid character at position: " + (i + 1) + " of value:  " + ch + " in name: " + name, node);
        }
    }

    public void visitListExpression(ListExpression expression) {
        List expressions = expression.getExpressions();
        for (Object element : expressions) {
            if (!(element instanceof MapEntryExpression)) continue;
            throw new RuntimeParserException("no map entry allowed at this place", (Expression)element);
        }
        super.visitListExpression(expression);
    }
}

