/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ProxyGenerator {
    public static final ProxyGenerator INSTANCE = new ProxyGenerator();
    private ClassLoader override = null;
    private boolean debug = false;

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ClassLoader getOverride() {
        return this.override;
    }

    public void setOverride(ClassLoader override) {
        this.override = override;
    }

    public Object instantiateAggregateFromBaseClass(Class clazz) {
        return this.instantiateAggregateFromBaseClass(null, clazz);
    }

    public Object instantiateAggregateFromBaseClass(Map map, Class clazz) {
        return this.instantiateAggregateFromBaseClass(map, clazz, null);
    }

    public Object instantiateAggregateFromBaseClass(Map map, Class clazz, Object[] constructorArgs) {
        return this.instantiateAggregate(map, null, clazz, constructorArgs);
    }

    public Object instantiateAggregateFromInterface(Class clazz) {
        return this.instantiateAggregateFromInterface(null, clazz);
    }

    public Object instantiateAggregateFromInterface(Map map, Class clazz) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(clazz);
        return this.instantiateAggregate(map, interfaces);
    }

    public Object instantiateAggregate(List interfaces) {
        return this.instantiateAggregate(null, interfaces);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces) {
        return this.instantiateAggregate(closureMap, interfaces, null);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces, Class clazz) {
        return this.instantiateAggregate(closureMap, interfaces, clazz, null);
    }

    public Object instantiateAggregate(Map closureMap, List interfaces, Class clazz, Object[] constructorArgs) {
        ClassLoader cl;
        int i;
        Map map = new HashMap();
        if (closureMap != null) {
            map = closureMap;
        }
        List interfacesToImplement = new ArrayList();
        if (interfaces != null) {
            interfacesToImplement = interfaces;
        }
        Class baseClass = GroovyObjectSupport.class;
        if (clazz != null) {
            baseClass = clazz;
        }
        boolean hasArgs = constructorArgs != null && constructorArgs.length > 0;
        String name = this.shortName(baseClass.getName()) + "_groovyProxy";
        StringBuffer buffer = new StringBuffer();
        buffer.append("class ").append(name);
        if (clazz != null) {
            buffer.append(" extends ").append(baseClass.getName());
        }
        for (int i2 = 0; i2 < interfacesToImplement.size(); ++i2) {
            Class thisInterface = (Class)interfacesToImplement.get(i2);
            if (i2 == 0) {
                buffer.append(" implements ");
            } else {
                buffer.append(", ");
            }
            buffer.append(thisInterface.getName());
        }
        buffer.append(" {\n").append("    private closureMap\n    ");
        buffer.append(name).append("(map");
        if (hasArgs) {
            buffer.append(", args");
        }
        buffer.append(") {\n");
        buffer.append("        super(");
        if (hasArgs) {
            buffer.append("*args");
        }
        buffer.append(")\n");
        buffer.append("        this.closureMap = map\n");
        buffer.append("    }\n");
        ArrayList<String> selectedMethods = new ArrayList<String>();
        List publicAndProtectedMethods = DefaultGroovyMethods.toList(baseClass.getMethods());
        publicAndProtectedMethods.addAll(this.getInheritedMethods(baseClass));
        for (int i3 = 0; i3 < publicAndProtectedMethods.size(); ++i3) {
            Method method = (Method)publicAndProtectedMethods.get(i3);
            if (method.getName().indexOf(36) != -1 || !map.containsKey(method.getName())) continue;
            selectedMethods.add(method.getName());
            this.addOverridingMapCall(buffer, method);
        }
        ArrayList interfaceMethods = new ArrayList();
        for (i = 0; i < interfacesToImplement.size(); ++i) {
            Class thisInterface = (Class)interfacesToImplement.get(i);
            interfaceMethods.addAll(DefaultGroovyMethods.toList(thisInterface.getMethods()));
            interfaceMethods.addAll(this.getInheritedMethods(thisInterface));
        }
        for (i = 0; i < interfaceMethods.size(); ++i) {
            Method method = (Method)interfaceMethods.get(i);
            if (this.containsEquivalentMethod(publicAndProtectedMethods, method)) continue;
            selectedMethods.add(method.getName());
            this.addMapOrDummyCall(map, buffer, method);
        }
        for (String methodName : map.keySet()) {
            if (methodName.indexOf(36) != -1 || selectedMethods.contains(methodName)) continue;
            this.addNewMapCall(buffer, methodName);
        }
        buffer.append("}\n").append("new ").append(name);
        buffer.append("(map");
        if (hasArgs) {
            buffer.append(", constructorArgs");
        }
        buffer.append(")");
        Binding binding = new Binding();
        binding.setVariable("map", map);
        binding.setVariable("constructorArgs", constructorArgs);
        ClassLoader classLoader = cl = this.override != null ? this.override : baseClass.getClassLoader();
        if (clazz == null && interfacesToImplement.size() > 0) {
            Class c = (Class)interfacesToImplement.get(0);
            cl = c.getClassLoader();
        }
        GroovyShell shell = new GroovyShell(cl, binding);
        if (this.debug) {
            System.out.println("proxy source:\n------------------\n" + buffer.toString() + "\n------------------");
        }
        try {
            return shell.evaluate(buffer.toString());
        }
        catch (MultipleCompilationErrorsException err) {
            throw new GroovyRuntimeException("Error creating proxy: " + err.getMessage());
        }
    }

    public Object instantiateDelegate(Object delegate) {
        return this.instantiateDelegate(null, delegate);
    }

    public Object instantiateDelegate(List interfaces, Object delegate) {
        return this.instantiateDelegate(null, interfaces, delegate);
    }

    public Object instantiateDelegate(Map closureMap, List interfaces, Object delegate) {
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, null);
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate) {
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, delegate.getClass());
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate, Class baseClass) {
        String name = this.shortName(delegate.getClass().getName()) + "_delegateProxy";
        return this.instantiateDelegateWithBaseClass(closureMap, interfaces, delegate, baseClass, name);
    }

    public Object instantiateDelegateWithBaseClass(Map closureMap, List interfaces, Object delegate, Class baseClass, String name) {
        int i;
        Map map = new HashMap();
        if (closureMap != null) {
            map = closureMap;
        }
        ArrayList<String> selectedMethods = new ArrayList<String>();
        List interfacesToImplement = new ArrayList();
        if (interfaces != null) {
            interfacesToImplement = interfaces;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("import org.codehaus.groovy.runtime.InvokerHelper\nclass ").append(name);
        if (baseClass != null) {
            buffer.append(" extends ").append(baseClass.getName());
        }
        for (int i2 = 0; i2 < interfacesToImplement.size(); ++i2) {
            Class thisInterface = (Class)interfacesToImplement.get(i2);
            if (i2 == 0) {
                buffer.append(" implements ");
            } else {
                buffer.append(", ");
            }
            buffer.append(thisInterface.getName());
        }
        buffer.append(" {\n").append("    private delegate\n").append("    private closureMap\n    ");
        buffer.append(name).append("(map, delegate) {\n");
        buffer.append("        this.closureMap = map\n");
        buffer.append("        this.delegate = delegate\n");
        buffer.append("    }\n");
        List objectMethods = DefaultGroovyMethods.toList(Object.class.getMethods());
        objectMethods.addAll(this.getInheritedMethods(Object.class));
        List groovyObjectMethods = DefaultGroovyMethods.toList(GroovyObject.class.getMethods());
        groovyObjectMethods.addAll(this.getInheritedMethods(GroovyObject.class));
        ArrayList interfaceMethods = new ArrayList();
        for (i = 0; i < interfacesToImplement.size(); ++i) {
            Class thisInterface = (Class)interfacesToImplement.get(i);
            interfaceMethods.addAll(DefaultGroovyMethods.toList(thisInterface.getMethods()));
            interfaceMethods.addAll(this.getInheritedMethods(thisInterface));
        }
        for (i = 0; i < interfaceMethods.size(); ++i) {
            Method method = (Method)interfaceMethods.get(i);
            if (this.containsEquivalentMethod(objectMethods, method) || this.containsEquivalentMethod(groovyObjectMethods, method)) continue;
            selectedMethods.add(method.getName());
            this.addWrappedCall(buffer, method, map);
        }
        ArrayList additionalMethods = new ArrayList();
        additionalMethods.addAll(DefaultGroovyMethods.toList(delegate.getClass().getMethods()));
        additionalMethods.addAll(this.getInheritedMethods(delegate.getClass()));
        for (int i3 = 0; i3 < additionalMethods.size(); ++i3) {
            Method method = (Method)additionalMethods.get(i3);
            if (method.getName().indexOf(36) != -1 || this.containsEquivalentMethod(interfaceMethods, method) || this.containsEquivalentMethod(objectMethods, method) || this.containsEquivalentMethod(groovyObjectMethods, method)) continue;
            selectedMethods.add(method.getName());
            this.addWrappedCall(buffer, method, map);
        }
        for (String methodName : map.keySet()) {
            if (selectedMethods.contains(methodName)) continue;
            this.addNewMapCall(buffer, methodName);
        }
        buffer.append("}\n").append("new ").append(name);
        buffer.append("(map, delegate)");
        Binding binding = new Binding();
        binding.setVariable("map", map);
        binding.setVariable("delegate", delegate);
        ClassLoader cl = this.override != null ? this.override : delegate.getClass().getClassLoader();
        GroovyShell shell = new GroovyShell(cl, binding);
        if (this.debug) {
            System.out.println("proxy source:\n------------------\n" + buffer.toString() + "\n------------------");
        }
        try {
            return shell.evaluate(buffer.toString());
        }
        catch (MultipleCompilationErrorsException err) {
            throw new GroovyRuntimeException("Error creating proxy: " + err.getMessage());
        }
    }

    private void addWrappedCall(StringBuffer buffer, Method method, Map map) {
        if (map.containsKey(method.getName())) {
            this.addOverridingMapCall(buffer, method);
        } else {
            Class[] parameterTypes = this.addMethodPrefix(buffer, method);
            this.addWrappedMethodBody(buffer, method, parameterTypes);
            this.addMethodSuffix(buffer);
        }
    }

    private boolean containsEquivalentMethod(List publicAndProtectedMethods, Method candidate) {
        for (int i = 0; i < publicAndProtectedMethods.size(); ++i) {
            Method method = (Method)publicAndProtectedMethods.get(i);
            if (!candidate.getName().equals(method.getName()) || !candidate.getReturnType().equals(method.getReturnType()) || !this.hasMatchingParameterTypes(candidate, method)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchingParameterTypes(Method method, Method candidate) {
        Class<?>[] methodParamTypes;
        Class<?>[] candidateParamTypes = candidate.getParameterTypes();
        if (candidateParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (candidateParamTypes[i].equals(methodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private List getInheritedMethods(Class baseClass) {
        ArrayList<Method> protectedMethodList = new ArrayList<Method>();
        for (Class currentClass = baseClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] protectedMethods = currentClass.getDeclaredMethods();
            for (int i = 0; i < protectedMethods.length; ++i) {
                Method method = protectedMethods[i];
                if (method.getName().indexOf(36) != -1 || !Modifier.isProtected(method.getModifiers()) || this.containsEquivalentMethod(protectedMethodList, method)) continue;
                protectedMethodList.add(method);
            }
        }
        return protectedMethodList;
    }

    private void addNewMapCall(StringBuffer buffer, String methodName) {
        buffer.append("    def ").append(methodName).append("(Object[] args) {\n").append("        this.@closureMap['").append(methodName).append("'] (*args)\n    }\n");
    }

    private void addOverridingMapCall(StringBuffer buffer, Method method) {
        Class[] parameterTypes = this.addMethodPrefix(buffer, method);
        this.addMethodBody(buffer, method, parameterTypes);
        this.addMethodSuffix(buffer);
    }

    private void addMapOrDummyCall(Map map, StringBuffer buffer, Method method) {
        Class[] parameterTypes = this.addMethodPrefix(buffer, method);
        if (map.containsKey(method.getName())) {
            this.addMethodBody(buffer, method, parameterTypes);
        }
        this.addMethodSuffix(buffer);
    }

    private Class[] addMethodPrefix(StringBuffer buffer, Method method) {
        buffer.append("    ").append(this.getSimpleName(method.getReturnType())).append(" ").append(method.getName()).append("(");
        Class[] parameterTypes = method.getParameterTypes();
        for (int parameterTypeIndex = 0; parameterTypeIndex < parameterTypes.length; ++parameterTypeIndex) {
            Class<?> parameter = parameterTypes[parameterTypeIndex];
            if (parameterTypeIndex != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getSimpleName(parameter)).append(" ").append("p").append(parameterTypeIndex);
        }
        buffer.append(") { ");
        return parameterTypes;
    }

    private void addMethodBody(StringBuffer buffer, Method method, Class[] parameterTypes) {
        buffer.append("this.@closureMap['").append(method.getName()).append("'] (");
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append("p").append(j);
        }
        buffer.append(")");
    }

    private void addWrappedMethodBody(StringBuffer buffer, Method method, Class[] parameterTypes) {
        buffer.append("\n        Object[] args = [");
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append("p").append(j);
        }
        buffer.append("]\n        ");
        buffer.append("InvokerHelper.invokeMethod(delegate, '").append(method.getName()).append("', args)\n");
    }

    private void addMethodSuffix(StringBuffer buffer) {
        buffer.append("    }\n");
    }

    public String getSimpleName(Class c) {
        if (c.isArray()) {
            int dimension = 0;
            Class<?> componentClass = c;
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
                ++dimension;
            }
            return componentClass.getName().replaceAll("\\$", "\\.") + DefaultGroovyMethods.multiply("[]", (Number)dimension);
        }
        return c.getName().replaceAll("\\$", "\\.");
    }

    public String shortName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1, name.length());
    }

    private static void setMetaClass(MetaClass metaClass) {
        DelegatingMetaClass newMetaClass = new DelegatingMetaClass(metaClass){

            public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
                return InvokerHelper.invokeMethod(INSTANCE, methodName, arguments);
            }
        };
        GroovySystem.getMetaClassRegistry().setMetaClass(ProxyGenerator.class, newMetaClass);
    }

    static {
        ProxyGenerator.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(ProxyGenerator.class));
    }
}

