/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.Closure;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;

public class ThreadManagedMetaBeanProperty
extends MetaBeanProperty {
    private static final CachedClass[] ZERO_ARGUMENT_LIST = new CachedClass[0];
    private static final ThreadLocal PROPERTY_INSTANCE_HOLDER = new InheritableThreadLocal();
    private Class declaringClass;
    private ThreadBoundGetter getter;
    private ThreadBoundSetter setter;
    private Object initialValue;
    private static final String PROPERTY_SET_PREFIX = "set";
    private Closure initialValueCreator;

    public synchronized Object getInitialValue() {
        return this.getInitialValue(null);
    }

    public synchronized Object getInitialValue(Object object) {
        if (this.initialValueCreator != null) {
            return this.initialValueCreator.call(object);
        }
        return this.initialValue;
    }

    public void setInitialValueCreator(Closure callable) {
        this.initialValueCreator = callable;
    }

    public ThreadManagedMetaBeanProperty(Class declaringClass, String name, Class type, Object iv) {
        super(name, type, null, null);
        this.type = type;
        this.declaringClass = declaringClass;
        this.getter = new ThreadBoundGetter(name);
        this.setter = new ThreadBoundSetter(name);
        this.initialValue = iv;
    }

    public ThreadManagedMetaBeanProperty(Class declaringClass, String name, Class type, Closure initialValueCreator) {
        super(name, type, null, null);
        this.type = type;
        this.declaringClass = declaringClass;
        this.getter = new ThreadBoundGetter(name);
        this.setter = new ThreadBoundSetter(name);
        this.initialValueCreator = initialValueCreator;
    }

    private static Object getThreadBoundPropertyValue(Object obj, String name, Object initialValue) {
        String key;
        Map propertyMap = ThreadManagedMetaBeanProperty.getThreadBoundPropertMap();
        if (propertyMap.containsKey(key = System.identityHashCode(obj) + name)) {
            return propertyMap.get(key);
        }
        propertyMap.put(key, initialValue);
        return initialValue;
    }

    private static Map getThreadBoundPropertMap() {
        WeakHashMap propertyMap = (WeakHashMap)PROPERTY_INSTANCE_HOLDER.get();
        if (propertyMap == null) {
            propertyMap = new WeakHashMap();
            PROPERTY_INSTANCE_HOLDER.set(propertyMap);
        }
        return propertyMap;
    }

    private static Object setThreadBoundPropertyValue(Object obj, String name, Object value) {
        Map propertyMap = ThreadManagedMetaBeanProperty.getThreadBoundPropertMap();
        String key = System.identityHashCode(obj) + name;
        return propertyMap.put(key, value);
    }

    public MetaMethod getGetter() {
        return this.getter;
    }

    public MetaMethod getSetter() {
        return this.setter;
    }

    private String getGetterName(String propertyName, Class type) {
        String prefix = type == Boolean.TYPE || type == Boolean.class ? "is" : "get";
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private class ThreadBoundSetter
    extends MetaMethod {
        private final String name;
        private final String name0;
        private ParameterTypes pt;

        public ThreadBoundSetter(String name) {
            this.pt = new ParameterTypes(new CachedClass[]{ReflectionCache.getCachedClass(ThreadManagedMetaBeanProperty.this.type)});
            this.name = ThreadManagedMetaBeanProperty.this.getSetterName(name);
            this.name0 = name;
        }

        public int getModifiers() {
            return 1;
        }

        public String getName() {
            return this.name;
        }

        public Class getReturnType() {
            return ThreadManagedMetaBeanProperty.this.type;
        }

        public CachedClass getDeclaringClass() {
            return ReflectionCache.getCachedClass(ThreadManagedMetaBeanProperty.this.declaringClass);
        }

        public ParameterTypes getParamTypes() {
            return this.pt;
        }

        public Object invoke(Object object, Object[] arguments) {
            return ThreadManagedMetaBeanProperty.setThreadBoundPropertyValue(object, this.name0, arguments[0]);
        }
    }

    class ThreadBoundGetter
    extends MetaMethod {
        private final String name;
        private final String name0;
        private final ParameterTypes pt = new ParameterTypes(new CachedClass[0]);

        public ThreadBoundGetter(String name) {
            this.name = ThreadManagedMetaBeanProperty.this.getGetterName(name, ThreadManagedMetaBeanProperty.this.type);
            this.name0 = name;
        }

        public int getModifiers() {
            return 1;
        }

        public String getName() {
            return this.name;
        }

        public Class getReturnType() {
            return ThreadManagedMetaBeanProperty.this.type;
        }

        public CachedClass getDeclaringClass() {
            return ReflectionCache.getCachedClass(ThreadManagedMetaBeanProperty.this.declaringClass);
        }

        public ParameterTypes getParamTypes() {
            return this.pt;
        }

        public Object invoke(Object object, Object[] arguments) {
            return ThreadManagedMetaBeanProperty.getThreadBoundPropertyValue(object, this.name0, ThreadManagedMetaBeanProperty.this.getInitialValue());
        }
    }
}

