/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovyjarjarasm.asm.ClassWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.classgen.ReflectorGenerator;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.FastArray;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;
import org.codehaus.groovy.runtime.metaclass.MemoryAwareConcurrentReadMap;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectorLoader;

public class MetaClassRegistryImpl
implements MetaClassRegistry {
    private volatile int constantMetaClassCount = 0;
    private ConcurrentReaderHashMap constantMetaClasses = new ConcurrentReaderHashMap();
    private MemoryAwareConcurrentReadMap weakMetaClasses = new MemoryAwareConcurrentReadMap();
    private MemoryAwareConcurrentReadMap loaderMap = new MemoryAwareConcurrentReadMap();
    private boolean useAccessible;
    private FastArray instanceMethods = new FastArray();
    private FastArray staticMethods = new FastArray();
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;
    private MetaClassRegistry.MetaClassCreationHandle metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();

    public MetaClassRegistryImpl() {
        this(0, true);
    }

    public MetaClassRegistryImpl(int loadDefault) {
        this(loadDefault, true);
    }

    public MetaClassRegistryImpl(boolean useAccessible) {
        this(0, useAccessible);
    }

    public MetaClassRegistryImpl(int loadDefault, boolean useAccessible) {
        this.useAccessible = useAccessible;
        if (loadDefault == 0) {
            HashMap map = new HashMap();
            this.registerMethods(DefaultGroovyMethods.class, true, map);
            this.registerMethods(DefaultGroovyStaticMethods.class, false, map);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CachedClass cls = (CachedClass)e.getKey();
                ArrayList list = (ArrayList)e.getValue();
                cls.setNewMopMethods(list);
            }
        }
        this.installMetaClassCreationHandle();
        MetaClass emcMetaClass = this.getMetaClassFor(ExpandoMetaClass.class);
        emcMetaClass.initialize();
        this.constantMetaClasses.put(ExpandoMetaClass.class, emcMetaClass);
        this.constantMetaClassCount = 1;
    }

    private void installMetaClassCreationHandle() {
        try {
            Class<?> customMetaClassHandle = Class.forName("groovy.runtime.metaclass.CustomMetaClassCreationHandle");
            Constructor<?> customMetaClassHandleConstructor = customMetaClassHandle.getConstructor(new Class[0]);
            this.metaClassCreationHandle = (MetaClassRegistry.MetaClassCreationHandle)customMetaClassHandleConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not instantiate custom Metaclass creation handle: " + e, e);
        }
    }

    private void registerMethods(Class theClass, boolean useInstanceMethods, Map map) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(theClass).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            NewMetaMethod metaMethod;
            CachedClass[] paramTypes;
            CachedMethod method = methods[i];
            int mod = method.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            ArrayList<NewInstanceMetaMethod> arr = (ArrayList<NewInstanceMetaMethod>)map.get(paramTypes[0]);
            if (arr == null) {
                arr = new ArrayList<NewInstanceMetaMethod>(4);
                map.put(paramTypes[0], arr);
            }
            if (useInstanceMethods) {
                metaMethod = new NewInstanceMetaMethod(method);
                arr.add((NewInstanceMetaMethod)metaMethod);
                this.instanceMethods.add(metaMethod);
                continue;
            }
            metaMethod = new NewStaticMetaMethod(method);
            arr.add((NewInstanceMetaMethod)metaMethod);
            this.staticMethods.add(metaMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Class theClass) {
        MetaClass answer = null;
        if (this.constantMetaClassCount != 0) {
            answer = (MetaClass)this.constantMetaClasses.get(theClass);
        }
        if (answer != null) {
            return answer;
        }
        answer = (MetaClass)this.weakMetaClasses.get(theClass);
        if (answer != null) {
            return answer;
        }
        Class clazz = theClass;
        synchronized (clazz) {
            answer = (MetaClass)this.weakMetaClasses.get(theClass);
            if (answer != null) {
                return answer;
            }
            answer = this.getMetaClassFor(theClass);
            answer.initialize();
            if (GroovySystem.isKeepJavaMetaClasses()) {
                ++this.constantMetaClassCount;
                this.constantMetaClasses.put(theClass, answer);
            } else {
                this.weakMetaClasses.put(theClass, answer);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaClass(Class theClass) {
        Object answer = null;
        if (this.constantMetaClassCount != 0) {
            answer = this.constantMetaClasses.remove(theClass);
        }
        if (answer == null) {
            this.weakMetaClasses.remove(theClass);
        } else {
            Class clazz = theClass;
            synchronized (clazz) {
                --this.constantMetaClassCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        Class clazz = theClass;
        synchronized (clazz) {
            ++this.constantMetaClassCount;
            this.constantMetaClasses.put(theClass, theMetaClass);
        }
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    private ReflectorLoader getReflectorLoader(final ClassLoader loader) {
        ReflectorLoader reflectorLoader = (ReflectorLoader)this.loaderMap.get(loader);
        if (reflectorLoader == null) {
            reflectorLoader = (ReflectorLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ReflectorLoader(loader);
                }
            });
            this.loaderMap.put(loader, reflectorLoader);
        }
        return reflectorLoader;
    }

    private MetaClass getMetaClassFor(Class theClass) {
        return this.metaClassCreationHandle.create(theClass, this);
    }

    public MetaClassRegistry.MetaClassCreationHandle getMetaClassCreationHandler() {
        return this.metaClassCreationHandle;
    }

    public void setMetaClassCreationHandle(MetaClassRegistry.MetaClassCreationHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException("Cannot set MetaClassCreationHandle to null value!");
        }
        this.metaClassCreationHandle = handle;
    }

    public static MetaClassRegistry getInstance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistryImpl();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistryImpl(1);
        }
        return instanceExclude;
    }

    public synchronized Reflector loadReflector(final Class theClass, List methods) {
        final String name = this.getReflectorName(theClass);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader loader = theClass.getClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                return loader;
            }
        });
        final ReflectorLoader rloader = this.getReflectorLoader(loader);
        Class ref = rloader.getLoadedClass(name);
        if (ref == null) {
            ReflectorGenerator generator = new ReflectorGenerator(methods);
            ClassWriter cw = new ClassWriter(true);
            generator.generate(cw, name);
            final byte[] bytecode = cw.toByteArray();
            ref = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return rloader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
                }
            });
        }
        try {
            return (Reflector)ref.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getReflectorName(Class theClass) {
        String className = theClass.getName();
        String packagePrefix = "gjdk.";
        String name = packagePrefix + className + "_GroovyReflector";
        if (theClass.isArray()) {
            Class<?> clazz = theClass;
            name = packagePrefix;
            int level = 0;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++level;
            }
            String componentName = clazz.getName();
            name = packagePrefix + componentName + "_GroovyReflectorArray";
            if (level > 1) {
                name = name + level;
            }
        }
        return name;
    }

    public FastArray getInstanceMethods() {
        return this.instanceMethods;
    }

    public FastArray getStaticMethods() {
        return this.staticMethods;
    }
}

