/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.xml.QName;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class XmlNodePrinter {
    protected final IndentPrinter out;
    private final String quote;

    public XmlNodePrinter() {
        this(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public XmlNodePrinter(PrintWriter out) {
        this(out, "  ");
    }

    public XmlNodePrinter(PrintWriter out, String indent) {
        this(out, indent, "\"");
    }

    public XmlNodePrinter(PrintWriter out, String indent, String quote) {
        this(new IndentPrinter(out, indent), quote);
    }

    public XmlNodePrinter(IndentPrinter out, String quote) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 'IndentPrinter out' must not be null!");
        }
        this.out = out;
        this.quote = quote;
    }

    public String getNameOfNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        Object name = node.name();
        if (name instanceof QName) {
            QName qname = (QName)name;
            return qname.getQualifiedName();
        }
        return name.toString();
    }

    public boolean isEmptyElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        if (!node.children().isEmpty()) {
            return false;
        }
        return node.text().length() == 0;
    }

    public void print(Node node) {
        if (this.isEmptyElement(node)) {
            this.printLineBegin();
            this.out.print("<");
            this.out.print(this.getNameOfNode(node));
            this.printNameAttributes(node.attributes());
            this.out.print("/>");
            this.printLineEnd();
            this.out.flush();
            return;
        }
        if (this.printSpecialNode(node)) {
            this.out.flush();
            return;
        }
        Object value = node.value();
        if (value instanceof List) {
            this.printName(node, true);
            this.printList((List)value);
            this.printName(node, false);
            this.out.flush();
            return;
        }
        this.printName(node, true);
        this.printSimpleItemWithIndent(value);
        this.printName(node, false);
        this.out.flush();
    }

    protected void printLineBegin() {
        this.out.printIndent();
    }

    protected void printLineEnd() {
        this.printLineEnd(null);
    }

    protected void printLineEnd(String comment) {
        if (comment != null) {
            this.out.print(" <!-- ");
            this.out.print(comment);
            this.out.print(" -->");
        }
        this.out.print("\n");
    }

    protected void printList(List list) {
        this.out.incrementIndent();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Node) {
                this.print((Node)value);
                continue;
            }
            this.printSimpleItem(value);
        }
        this.out.decrementIndent();
    }

    private void printSimpleItemWithIndent(Object value) {
        this.out.incrementIndent();
        this.printSimpleItem(value);
        this.out.decrementIndent();
    }

    private void printSimpleItem(Object value) {
        this.printLineBegin();
        this.out.print(InvokerHelper.toString(value));
        this.printLineEnd();
    }

    protected void printName(Node node, boolean begin) {
        if (node == null) {
            throw new NullPointerException("Node must not be null.");
        }
        Object name = node.name();
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.printLineBegin();
        this.out.print("<");
        if (!begin) {
            this.out.print("/");
        }
        this.out.print(this.getNameOfNode(node));
        if (begin) {
            this.printNameAttributes(node.attributes());
        }
        this.out.print(">");
        this.printLineEnd();
    }

    protected void printNameAttributes(Map attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.out.print(" ");
            this.out.print(entry.getKey().toString());
            this.out.print("=");
            Object value = entry.getValue();
            this.out.print(this.quote);
            if (value instanceof String) {
                this.out.print((String)value);
            } else {
                this.out.print(InvokerHelper.toString(value));
            }
            this.out.print(this.quote);
        }
    }

    protected boolean printSpecialNode(Node node) {
        return false;
    }
}

