/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;

public class ExpandoMetaClassCreationHandle
extends MetaClassRegistry.MetaClassCreationHandle {
    private final Map modifiedExpandos = new ConcurrentReaderHashMap();

    public MetaClass create(Class theClass, MetaClassRegistry registry) {
        if (theClass != ExpandoMetaClass.class) {
            ExpandoMetaClass emc = new ExpandoMetaClass(theClass);
            emc.setAllowChangesAfterInit(true);
            Set modifiedSuperExpandos = this.retrieveModifiedSuperExpandos(emc);
            emc.refreshInheritedMethods(modifiedSuperExpandos);
            emc.initialize();
            return emc;
        }
        return super.create(theClass, registry);
    }

    private Set retrieveModifiedSuperExpandos(ExpandoMetaClass child) {
        HashSet modifiedSupers = new HashSet();
        LinkedList superClasses = child.getSuperClasses();
        Iterator i = superClasses.iterator();
        while (i.hasNext()) {
            Class c = (Class)i.next();
            Class[] interfaces = c.getInterfaces();
            this.populateSupersFromInterfaces(modifiedSupers, interfaces);
            if (!this.modifiedExpandos.containsKey(c)) continue;
            modifiedSupers.add(this.modifiedExpandos.get(c));
        }
        Class[] interfaces = child.getJavaClass().getInterfaces();
        this.populateSupersFromInterfaces(modifiedSupers, interfaces);
        return modifiedSupers;
    }

    private void populateSupersFromInterfaces(Set modifiedSupers, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            Class[] superInterfaces = anInterface.getInterfaces();
            if (this.modifiedExpandos.containsKey(anInterface)) {
                modifiedSupers.add(this.modifiedExpandos.get(anInterface));
            }
            if (superInterfaces.length <= 0) continue;
            this.populateSupersFromInterfaces(modifiedSupers, superInterfaces);
        }
    }

    public void registerModifiedMetaClass(ExpandoMetaClass emc) {
        this.modifiedExpandos.put(emc.getJavaClass(), emc);
    }

    public boolean hasModifiedMetaClass(ExpandoMetaClass emc) {
        return this.modifiedExpandos.containsKey(emc.getJavaClass());
    }

    public static void enable() {
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle(new ExpandoMetaClassCreationHandle());
    }
}

