/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.AdaptingMetaClass;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultMethodKey;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ThreadManagedMetaBeanProperty;

public class ExpandoMetaClass
extends MetaClassImpl
implements GroovyObject {
    private static final String META_CLASS = "metaClass";
    private static final String CLASS = "class";
    private static final String META_METHODS = "metaMethods";
    private static final String METHODS = "methods";
    private static final String PROPERTIES = "properties";
    public static final String STATIC_QUALIFIER = "static";
    private static final Class[] ZERO_ARGUMENTS = new Class[0];
    private static final String CONSTRUCTOR = "constructor";
    private static final String GET_PROPERTY_METHOD = "getProperty";
    private static final String SET_PROPERTY_METHOD = "setProperty";
    private static final String INVOKE_METHOD_METHOD = "invokeMethod";
    private static final String CLASS_PROPERTY = "class";
    private static final String META_CLASS_PROPERTY = "metaClass";
    private static final String GROOVY_CONSTRUCTOR = "<init>";
    private static final Map CLASS_INHERITANCE_MAPPING = Collections.synchronizedMap(new HashMap());
    private boolean hasCreationHandle;
    private MetaClass myMetaClass;
    private boolean allowChangesAfterInit;
    private boolean initialized;
    private boolean initCalled;
    private boolean modified;
    private boolean inRegistry;
    private final Set inheritedMetaMethods = new HashSet();
    private final Map beanPropertyCache = new HashMap();
    private final Set expandoMethods = new HashSet();
    private final Map expandoProperties = new LinkedHashMap();
    private ClosureMetaMethod getPropertyMethod;
    private ClosureMetaMethod invokeMethodMethod;
    private ClosureMetaMethod setPropertyMethod;

    public static void enableGlobally() {
        ExpandoMetaClassCreationHandle.enable();
    }

    public static void disableGlobally() {
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle(new MetaClassRegistry.MetaClassCreationHandle());
    }

    public void setAllowChangesAfterInit(boolean allowChangesAfterInit) {
        this.allowChangesAfterInit = allowChangesAfterInit;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.inheritSelfTrackedExpandoMethods();
            super.initialize();
            this.initialized = true;
            this.initCalled = true;
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    private void inheritSelfTrackedExpandoMethods() {
        if (!(GroovySystem.getMetaClassRegistry().getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle)) {
            LinkedList superClasses = this.getSuperClasses();
            Iterator i = superClasses.iterator();
            while (i.hasNext()) {
                Class c = (Class)i.next();
                Map methodMap = (Map)CLASS_INHERITANCE_MAPPING.get(c);
                if (methodMap == null) continue;
                Iterator j = methodMap.values().iterator();
                while (j.hasNext()) {
                    List methods = (List)j.next();
                    Iterator k = methods.iterator();
                    while (k.hasNext()) {
                        MetaMethod metaMethodFromSuper = (MetaMethod)k.next();
                        if (metaMethodFromSuper.isStatic()) continue;
                        this.addSuperMethodIfNotOverriden(metaMethodFromSuper);
                    }
                }
            }
        }
    }

    private void addSuperMethodIfNotOverriden(final MetaMethod metaMethodFromSuper) {
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                MetaMethod existing = ExpandoMetaClass.this.pickMethod(metaMethodFromSuper.getName(), metaMethodFromSuper.getParameterTypes());
                if (existing == null) {
                    this.addMethodWithKey(metaMethodFromSuper);
                } else {
                    boolean isGroovyMethod = ExpandoMetaClass.this.getMetaMethods().contains(existing);
                    if (isGroovyMethod) {
                        this.addMethodWithKey(metaMethodFromSuper);
                    } else if (ExpandoMetaClass.this.inheritedMetaMethods.contains(existing)) {
                        ExpandoMetaClass.this.inheritedMetaMethods.remove(existing);
                        this.addMethodWithKey(metaMethodFromSuper);
                    }
                }
            }

            private void addMethodWithKey(MetaMethod metaMethodFromSuper2) {
                ExpandoMetaClass.this.inheritedMetaMethods.add(metaMethodFromSuper2);
                if (metaMethodFromSuper2 instanceof ClosureMetaMethod) {
                    ClosureMetaMethod closureMethod = (ClosureMetaMethod)metaMethodFromSuper2;
                    Closure cloned = (Closure)closureMethod.getClosure().clone();
                    String name = metaMethodFromSuper2.getName();
                    ClosureMetaMethod localMethod = new ClosureMetaMethod(name, ExpandoMetaClass.this.getJavaClass(), cloned);
                    ExpandoMetaClass.this.addMetaMethod(localMethod);
                    DefaultMethodKey key = new DefaultMethodKey(ExpandoMetaClass.this.getJavaClass(), name, localMethod.getParameterTypes(), false);
                    ExpandoMetaClass.this.cacheInstanceMethod(key, localMethod);
                    ExpandoMetaClass.this.checkIfGroovyObjectMethod(localMethod, name, cloned);
                    ExpandoMetaClass.this.expandoMethods.add(localMethod);
                }
            }
        });
    }

    public ExpandoMetaClass(Class theClass) {
        super(InvokerHelper.getInstance().getMetaRegistry(), theClass);
        this.myMetaClass = InvokerHelper.getMetaClass(this);
    }

    public ExpandoMetaClass(Class theClass, boolean register) {
        this(theClass);
        if (register) {
            this.registry.setMetaClass(theClass, this);
            this.inRegistry = true;
        }
    }

    public Object invokeConstructor(Object[] arguments) {
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        MetaMethod method = this.pickMethod(GROOVY_CONSTRUCTOR, argClasses);
        if (method != null && method.getParameterTypes().length == arguments.length) {
            return method.invoke(this.theClass, arguments);
        }
        return super.invokeConstructor(arguments);
    }

    protected LinkedList getSuperClasses() {
        LinkedList<Class> superClasses = new LinkedList<Class>();
        for (Class c = this.theClass; c != null; c = c.getSuperclass()) {
            superClasses.addFirst(c);
        }
        if (this.getJavaClass().isArray() && this.getJavaClass() != Object;.class && !this.getJavaClass().getComponentType().isPrimitive()) {
            superClasses.addFirst(Object;.class);
        }
        return superClasses;
    }

    public MetaClass getMetaClass() {
        return this.myMetaClass;
    }

    public Object getProperty(String property) {
        if (this.isValidExpandoProperty(property)) {
            if (property.equals(STATIC_QUALIFIER)) {
                return new ExpandoMetaProperty(property, true);
            }
            if (property.equals(CONSTRUCTOR)) {
                return new ExpandoMetaConstructor();
            }
            return new ExpandoMetaProperty(property);
        }
        return this.myMetaClass.getProperty(this, property);
    }

    private boolean isValidExpandoProperty(String property) {
        return !property.equals("metaClass") && !property.equals("class") && !property.equals(META_METHODS) && !property.equals(METHODS) && !property.equals(PROPERTIES);
    }

    public Object invokeMethod(String name, Object args) {
        return this.myMetaClass.invokeMethod((Object)this, name, args);
    }

    public void setMetaClass(MetaClass metaClass) {
        this.myMetaClass = metaClass;
    }

    public void setProperty(String property, Object newValue) {
        if (newValue instanceof Closure) {
            if (property.equals(CONSTRUCTOR)) {
                property = GROOVY_CONSTRUCTOR;
            }
            Closure callable = (Closure)newValue;
            this.registerInstanceMethod(property, callable);
        } else if (property.equals("allowChangesAfterInit")) {
            this.allowChangesAfterInit = (Boolean)newValue;
        } else {
            this.registerBeanProperty(property, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performOperationOnMetaClass(Callable c) {
        ExpandoMetaClass expandoMetaClass = this;
        synchronized (expandoMetaClass) {
            try {
                if (this.allowChangesAfterInit) {
                    this.initialized = false;
                }
                c.call();
            }
            finally {
                if (this.initCalled) {
                    this.initialized = true;
                }
            }
        }
    }

    protected void registerBeanProperty(final String property, final Object newValue) {
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                Class clazz = newValue == null ? (class$java$lang$Object == null ? (class$java$lang$Object = ExpandoMetaClass.class$("java.lang.Object")) : class$java$lang$Object) : newValue.getClass();
                Class type = clazz;
                ThreadManagedMetaBeanProperty mbp = new ThreadManagedMetaBeanProperty(ExpandoMetaClass.this.theClass, property, type, newValue);
                ExpandoMetaClass.this.addMetaMethod(((MetaBeanProperty)mbp).getGetter());
                ExpandoMetaClass.this.addMetaMethod(((MetaBeanProperty)mbp).getSetter());
                ExpandoMetaClass.this.expandoMethods.add(((MetaBeanProperty)mbp).getSetter());
                ExpandoMetaClass.this.expandoMethods.add(((MetaBeanProperty)mbp).getGetter());
                ExpandoMetaClass.this.expandoProperties.put(mbp.getName(), mbp);
                ExpandoMetaClass.this.addMetaBeanProperty(mbp);
            }
        });
    }

    protected void registerInstanceMethod(final String methodName, final Closure callable) {
        final boolean inited = this.initCalled;
        this.performOperationOnMetaClass(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                String propertyName;
                ClosureMetaMethod metaMethod = new ClosureMetaMethod(methodName, ExpandoMetaClass.this.theClass, callable);
                ExpandoMetaClass.this.checkIfGroovyObjectMethod(metaMethod, methodName, callable);
                DefaultMethodKey key = new DefaultMethodKey(ExpandoMetaClass.this.theClass, methodName, metaMethod.getParameterTypes(), false);
                ExpandoMetaClass.this.addMetaMethod(metaMethod);
                Set set = ExpandoMetaClass.this.expandoMethods;
                synchronized (set) {
                    ExpandoMetaClass.this.expandoMethods.add(metaMethod);
                }
                ExpandoMetaClass.this.cacheInstanceMethod(key, metaMethod);
                if (inited && ExpandoMetaClass.this.isGetter(methodName, metaMethod.getParameterTypes())) {
                    propertyName = ExpandoMetaClass.this.getPropertyForGetter(methodName);
                    ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, true);
                } else if (inited && ExpandoMetaClass.this.isSetter(methodName, metaMethod.getParameterTypes())) {
                    propertyName = ExpandoMetaClass.this.getPropertyForSetter(methodName);
                    ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, false);
                }
                ExpandoMetaClass.this.performRegistryCallbacks();
                if (!ExpandoMetaClass.this.hasCreationHandle) {
                    ExpandoMetaClass.registerWithInheritenceManager(ExpandoMetaClass.this.theClass, metaMethod);
                }
            }
        });
    }

    private void checkIfGroovyObjectMethod(ClosureMetaMethod metaMethod, String methodName, Closure callable) {
        if (this.isGetPropertyMethod(methodName)) {
            this.getPropertyMethod = metaMethod;
        } else if (this.isInvokeMethod(methodName, callable)) {
            this.invokeMethodMethod = metaMethod;
        } else if (this.isSetPropertyMethod(methodName, metaMethod)) {
            this.setPropertyMethod = metaMethod;
        }
    }

    private boolean isSetPropertyMethod(String methodName, ClosureMetaMethod metaMethod) {
        return SET_PROPERTY_METHOD.equals(methodName) && metaMethod.getParameterTypes().length == 2;
    }

    private boolean isGetPropertyMethod(String methodName) {
        return GET_PROPERTY_METHOD.equals(methodName);
    }

    private boolean isInvokeMethod(String methodName, Closure metaMethod) {
        return INVOKE_METHOD_METHOD.equals(methodName) && metaMethod.getParameterTypes().length == 2;
    }

    private void performRegistryCallbacks() {
        MetaClassRegistry registry = InvokerHelper.getInstance().getMetaRegistry();
        if (!this.modified && !this.inRegistry) {
            this.modified = true;
            MetaClass currMetaClass = registry.getMetaClass(this.theClass);
            if (!(currMetaClass instanceof ExpandoMetaClass) && currMetaClass instanceof AdaptingMetaClass) {
                ((AdaptingMetaClass)currMetaClass).setAdaptee(this);
            } else {
                registry.setMetaClass(this.theClass, this);
            }
            this.inRegistry = true;
        }
        if (registry.getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle) {
            ExpandoMetaClassCreationHandle creationHandler = (ExpandoMetaClassCreationHandle)registry.getMetaClassCreationHandler();
            this.hasCreationHandle = true;
            if (!creationHandler.hasModifiedMetaClass(this)) {
                creationHandler.registerModifiedMetaClass(this);
            }
            creationHandler.notifyOfMetaClassChange(this);
        }
    }

    private static void registerWithInheritenceManager(Class theClass, ClosureMetaMethod metaMethod) {
        LinkedList<ClosureMetaMethod> methodList;
        HashMap<String, LinkedList<ClosureMetaMethod>> methodMap = (HashMap<String, LinkedList<ClosureMetaMethod>>)CLASS_INHERITANCE_MAPPING.get(theClass);
        if (methodMap == null) {
            methodMap = new HashMap<String, LinkedList<ClosureMetaMethod>>();
            CLASS_INHERITANCE_MAPPING.put(theClass, methodMap);
        }
        if ((methodList = (LinkedList<ClosureMetaMethod>)methodMap.get(metaMethod.getName())) == null) {
            methodList = new LinkedList<ClosureMetaMethod>();
            methodMap.put(metaMethod.getName(), methodList);
        }
        methodList.add(metaMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeanPropertyForMethod(ClosureMetaMethod metaMethod, String propertyName, boolean getter) {
        Map map = this.beanPropertyCache;
        synchronized (map) {
            MetaBeanProperty beanProperty = (MetaBeanProperty)this.beanPropertyCache.get(propertyName);
            if (beanProperty == null) {
                beanProperty = getter ? new MetaBeanProperty(propertyName, Object.class, metaMethod, null) : new MetaBeanProperty(propertyName, Object.class, null, metaMethod);
                this.beanPropertyCache.put(propertyName, beanProperty);
            } else if (getter) {
                MetaMethod setterMethod = beanProperty.getSetter();
                Class type = setterMethod != null ? setterMethod.getParameterTypes()[0] : Object.class;
                beanProperty = new MetaBeanProperty(propertyName, type, metaMethod, setterMethod);
                this.beanPropertyCache.put(propertyName, beanProperty);
            } else {
                MetaMethod getterMethod = beanProperty.getGetter();
                beanProperty = new MetaBeanProperty(propertyName, metaMethod.getParameterTypes()[0], getterMethod, metaMethod);
                this.beanPropertyCache.put(propertyName, beanProperty);
            }
            Map map2 = this.expandoProperties;
            synchronized (map2) {
                this.expandoProperties.put(beanProperty.getName(), beanProperty);
            }
            this.addMetaBeanProperty(beanProperty);
        }
    }

    protected void registerStaticMethod(final String methodName, final Closure callable) {
        this.performOperationOnMetaClass(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                ClosureStaticMetaMethod metaMethod = new ClosureStaticMetaMethod(methodName, ExpandoMetaClass.this.theClass, callable);
                DefaultMethodKey key = new DefaultMethodKey(ExpandoMetaClass.this.theClass, methodName, metaMethod.getParameterTypes(), false);
                ExpandoMetaClass.this.addMetaMethod(metaMethod);
                Set set = ExpandoMetaClass.this.expandoMethods;
                synchronized (set) {
                    ExpandoMetaClass.this.expandoMethods.add(metaMethod);
                }
                ExpandoMetaClass.this.cacheStaticMethod(key, metaMethod);
            }
        });
    }

    public Class getJavaClass() {
        return this.theClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInheritedMethods(Set modifiedSuperExpandos) {
        Iterator i = modifiedSuperExpandos.iterator();
        while (i.hasNext()) {
            ExpandoMetaClass superExpando = (ExpandoMetaClass)i.next();
            if (superExpando == this) continue;
            List metaMethods = superExpando.getExpandoMethods();
            Iterator j = metaMethods.iterator();
            while (j.hasNext()) {
                MetaMethod metaMethod = (MetaMethod)j.next();
                this.addSuperMethodIfNotOverriden(metaMethod);
            }
            Collection metaProperties = superExpando.getExpandoProperties();
            Iterator j2 = metaProperties.iterator();
            while (j2.hasNext()) {
                MetaBeanProperty property = (MetaBeanProperty)j2.next();
                Map map = this.expandoProperties;
                synchronized (map) {
                    this.expandoProperties.put(property.getName(), property);
                }
                this.addMetaBeanProperty(property);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExpandoMethods() {
        Set set = this.expandoMethods;
        synchronized (set) {
            return Collections.unmodifiableList(DefaultGroovyMethods.toList(this.expandoMethods));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getExpandoProperties() {
        Map map = this.expandoProperties;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.expandoProperties.values());
        }
    }

    public Object invokeMethod(Class sender, Object object, String methodName, Object[] originalArguments, boolean isCallToSuper, boolean fromInsideClass) {
        if (this.invokeMethodMethod != null) {
            return this.invokeMethodMethod.invoke(object, new Object[]{methodName, originalArguments});
        }
        return super.invokeMethod(sender, object, methodName, originalArguments, isCallToSuper, fromInsideClass);
    }

    public Object getProperty(Class sender, Object object, String name, boolean useSuper, boolean fromInsideClass) {
        if (this.hasOverrideGetProperty(name)) {
            return this.getPropertyMethod.invoke(object, new Object[]{name});
        }
        return super.getProperty(sender, object, name, useSuper, fromInsideClass);
    }

    public Object getProperty(Object object, String name) {
        if (this.hasOverrideGetProperty(name)) {
            return this.getPropertyMethod.invoke(object, new Object[]{name});
        }
        return super.getProperty(object, name);
    }

    private boolean hasOverrideGetProperty(String name) {
        return this.getPropertyMethod != null && !name.equals("metaClass") && !name.equals("class");
    }

    public void setProperty(Class sender, Object object, String name, Object newValue, boolean useSuper, boolean fromInsideClass) {
        if (this.setPropertyMethod != null && !name.equals("metaClass")) {
            this.setPropertyMethod.invoke(object, new Object[]{name, newValue});
            return;
        }
        super.setProperty(sender, object, name, newValue, useSuper, fromInsideClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaProperty getMetaProperty(String name) {
        MetaProperty mp;
        Map map = this.expandoProperties;
        synchronized (map) {
            mp = (MetaProperty)this.expandoProperties.get(name);
        }
        if (mp != null) {
            return mp;
        }
        List properties = super.getProperties();
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            MetaProperty metaProperty = (MetaProperty)i.next();
            if (!name.equals(metaProperty.getName())) continue;
            return metaProperty;
        }
        return null;
    }

    public boolean hasMetaProperty(String name) {
        return this.getMetaProperty(name) != null;
    }

    public MetaMethod getMetaMethod(String name, Class[] args) {
        return super.pickMethod(name, args);
    }

    public MetaMethod getMetaMethod(String name, Object args) {
        if (args instanceof Object[]) {
            Object[] allArgs = (Object[])args;
            Class[] types = new Class[allArgs.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = allArgs[i] != null ? allArgs[i].getClass() : null;
            }
            return this.getMetaMethod(name, types);
        }
        return this.getMetaMethod(name, new Class[]{args.getClass()});
    }

    public boolean hasMetaMethod(String name, Class[] args) {
        return super.pickMethod(name, args) != null;
    }

    private boolean isGetter(String name, Class[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith("is") && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    private String getPropertyForGetter(String getterName) {
        if (getterName == null || getterName.length() == 0) {
            return null;
        }
        if (getterName.startsWith("get")) {
            String prop = getterName.substring(3);
            return this.convertPropertyName(prop);
        }
        if (getterName.startsWith("is")) {
            String prop = getterName.substring(2);
            return this.convertPropertyName(prop);
        }
        return null;
    }

    private String convertPropertyName(String prop) {
        if (Character.isUpperCase(prop.charAt(0)) && Character.isUpperCase(prop.charAt(1))) {
            return prop;
        }
        if (Character.isDigit(prop.charAt(0))) {
            return prop;
        }
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }

    public String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.startsWith("set")) {
            String prop = setterName.substring(3);
            return this.convertPropertyName(prop);
        }
        return null;
    }

    public boolean isSetter(String name, Class[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    protected class ExpandoMetaConstructor
    extends GroovyObjectSupport {
        protected ExpandoMetaConstructor() {
        }

        public Object leftShift(Closure c) {
            if (c != null) {
                Constructor ctor;
                Class[] paramTypes = c.getParameterTypes();
                if (paramTypes == null) {
                    paramTypes = ZERO_ARGUMENTS;
                }
                if ((ctor = ExpandoMetaClass.this.retrieveConstructor(paramTypes)) != null) {
                    throw new GroovyRuntimeException("Cannot add new constructor for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                }
                ExpandoMetaClass.this.registerInstanceMethod(ExpandoMetaClass.GROOVY_CONSTRUCTOR, c);
            }
            return this;
        }
    }

    protected class ExpandoMetaProperty
    extends GroovyObjectSupport {
        String propertyName;
        boolean isStatic;

        protected ExpandoMetaProperty(String name) {
            this(name, false);
        }

        protected ExpandoMetaProperty(String name, boolean isStatic) {
            this.propertyName = name;
            this.isStatic = isStatic;
        }

        public Object leftShift(Object arg) {
            this.registerIfClosure(arg, false);
            return this;
        }

        private void registerIfClosure(Object arg, boolean replace) {
            if (arg instanceof Closure) {
                Closure callable = (Closure)arg;
                Class[] paramTypes = callable.getParameterTypes();
                if (paramTypes == null) {
                    paramTypes = ZERO_ARGUMENTS;
                }
                if (!this.isStatic) {
                    Method foundMethod = this.checkIfMethodExists(ExpandoMetaClass.this.theClass, this.propertyName, paramTypes, false);
                    if (foundMethod != null && !replace) {
                        throw new GroovyRuntimeException("Cannot add new method [" + this.propertyName + "] for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                    }
                    ExpandoMetaClass.this.registerInstanceMethod(this.propertyName, callable);
                } else {
                    Method foundMethod = this.checkIfMethodExists(ExpandoMetaClass.this.theClass, this.propertyName, paramTypes, true);
                    if (foundMethod != null && !replace) {
                        throw new GroovyRuntimeException("Cannot add new static method [" + this.propertyName + "] for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                    }
                    ExpandoMetaClass.this.registerStaticMethod(this.propertyName, callable);
                }
            }
        }

        private Method checkIfMethodExists(Class methodClass, String methodName, Class[] paramTypes, boolean staticMethod) {
            Method foundMethod = null;
            Method[] methods = methodClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || Modifier.isStatic(methods[i].getModifiers()) != staticMethod || !MetaClassHelper.parametersAreCompatible(paramTypes, methods[i].getParameterTypes())) continue;
                foundMethod = methods[i];
                break;
            }
            return foundMethod;
        }

        public Object getProperty(String property) {
            this.propertyName = property;
            return this;
        }

        public void setProperty(String property, Object newValue) {
            this.propertyName = property;
            this.registerIfClosure(newValue, true);
        }
    }

    private static interface Callable {
        public void call();
    }
}

