/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedClass {
    private CachedClass cachedSuperClass;
    private static final MetaMethod[] EMPTY = new MetaMethod[0];
    int hashCode;
    private Reflector reflector;
    private volatile Object metaClassForClass;
    private CachedField[] fields;
    private CachedConstructor[] constructors;
    private CachedMethod[] methods;
    private final Class cachedClass;
    private MetaMethod[] newMetaMethods = EMPTY;
    public CachedMethod[] mopMethods;
    public static final CachedClass[] EMPTY_ARRAY = new CachedClass[0];
    private Object staticMetaClassField;
    private static final Object NONE = new Object();
    private Set ownInterfaces;
    private Set interfaces;
    public final boolean isArray;
    public final boolean isPrimitive;
    public final int modifiers;
    int distance = -1;
    public final boolean isInterface;
    public final boolean isNumber;
    static /* synthetic */ Class class$groovy$lang$MetaClass;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$groovy$lang$GString;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class array$Ljava$lang$Double;
    static /* synthetic */ Class array$Ljava$math$BigDecimal;

    public Set getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new HashSet(0);
            if (this.getCachedClass().isInterface()) {
                this.interfaces.add(this);
            }
            Class<?>[] classes = this.getCachedClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.interfaces.contains(aClass)) continue;
                this.interfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.interfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.interfaces;
    }

    public Set getOwnInterfaces() {
        if (this.ownInterfaces == null) {
            this.ownInterfaces = new HashSet(0);
            if (this.getCachedClass().isInterface()) {
                this.ownInterfaces.add(this);
            }
            Class<?>[] classes = this.getCachedClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.ownInterfaces.contains(aClass)) continue;
                this.ownInterfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.ownInterfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.ownInterfaces;
    }

    CachedClass(Class klazz) {
        this.cachedClass = klazz;
        this.isArray = klazz.isArray();
        this.isPrimitive = klazz.isPrimitive();
        this.modifiers = klazz.getModifiers();
        this.isInterface = klazz.isInterface();
        this.isNumber = Number.class.isAssignableFrom(klazz);
        Iterator it = this.getInterfaces().iterator();
        while (it.hasNext()) {
            CachedClass inf = (CachedClass)it.next();
            ReflectionCache.isAssignableFrom(klazz, inf.cachedClass);
        }
        for (CachedClass cur = this; cur != null; cur = cur.getCachedSuperClass()) {
            ReflectionCache.setAssignableFrom(cur.cachedClass, klazz);
        }
    }

    public synchronized CachedClass getCachedSuperClass() {
        if (this.cachedSuperClass == null) {
            this.cachedSuperClass = !this.isArray ? ReflectionCache.getCachedClass(this.getCachedClass().getSuperclass()) : (this.cachedClass.getComponentType().isPrimitive() || this.cachedClass.getComponentType() == Object.class ? ReflectionCache.OBJECT_CLASS : ReflectionCache.OBJECT_ARRAY_CLASS);
        }
        return this.cachedSuperClass;
    }

    public synchronized CachedMethod[] getMethods() {
        if (this.methods == null) {
            Method[] declaredMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredMethods();
                }
            });
            ArrayList<CachedMethod> methods = new ArrayList<CachedMethod>(declaredMethods.length);
            ArrayList<CachedMethod> mopMethods = new ArrayList<CachedMethod>(declaredMethods.length);
            for (int i = 0; i != declaredMethods.length; ++i) {
                CachedMethod cachedMethod = new CachedMethod(this, declaredMethods[i]);
                String name = cachedMethod.getName();
                if (name.indexOf(43) >= 0) continue;
                if (name.startsWith("this$") || name.startsWith("super$")) {
                    mopMethods.add(cachedMethod);
                    continue;
                }
                methods.add(cachedMethod);
            }
            this.methods = methods.toArray(new CachedMethod[methods.size()]);
            Arrays.sort(this.methods);
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                superClass.getMethods();
                CachedMethod[] superMopMethods = superClass.mopMethods;
                for (int i = 0; i != superMopMethods.length; ++i) {
                    mopMethods.add(superMopMethods[i]);
                }
            }
            this.mopMethods = mopMethods.toArray(new CachedMethod[mopMethods.size()]);
            Arrays.sort(this.mopMethods, CachedMethodComparatorByName.INSTANCE);
        }
        return this.methods;
    }

    public synchronized CachedField[] getFields() {
        if (this.fields == null) {
            Field[] declaredFields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredFields();
                }
            });
            this.fields = new CachedField[declaredFields.length];
            for (int i = 0; i != this.fields.length; ++i) {
                this.fields[i] = new CachedField(this, declaredFields[i]);
            }
        }
        return this.fields;
    }

    public synchronized CachedConstructor[] getConstructors() {
        if (this.constructors == null) {
            Constructor[] declaredConstructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredConstructors();
                }
            });
            this.constructors = new CachedConstructor[declaredConstructors.length];
            for (int i = 0; i != this.constructors.length; ++i) {
                this.constructors[i] = new CachedConstructor(this, declaredConstructors[i]);
            }
        }
        return this.constructors;
    }

    public CachedMethod searchMethods(String name, CachedClass[] parameterTypes) {
        CachedMethod[] methods = this.getMethods();
        CachedMethod res = null;
        for (int i = 0; i < methods.length; ++i) {
            CachedMethod m = methods[i];
            if (!m.getName().equals(name) || !ReflectionCache.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Object coerceArgument(Object argument) {
        return argument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuperClassDistance() {
        Class clazz = this.getCachedClass();
        synchronized (clazz) {
            if (this.distance == -1) {
                int distance = 0;
                for (Class klazz = this.getCachedClass(); klazz != null; klazz = klazz.getSuperclass()) {
                    ++distance;
                }
                this.distance = distance;
            }
            return this.distance;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isVoid() {
        return this.getCachedClass() == Void.TYPE;
    }

    public void box(BytecodeHelper helper) {
        helper.box(this.getCachedClass());
    }

    public void unbox(BytecodeHelper helper) {
        helper.unbox(this.getCachedClass());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void doCast(BytecodeHelper helper) {
        helper.doCast(this.getCachedClass());
    }

    public String getName() {
        return this.getCachedClass().getName();
    }

    public String getTypeDescription() {
        return BytecodeHelper.getTypeDescription(this.getCachedClass());
    }

    public synchronized Reflector getReflector() {
        return this.reflector;
    }

    public final Class getCachedClass() {
        return this.cachedClass;
    }

    public MetaMethod[] getNewMetaMethods() {
        return this.newMetaMethods;
    }

    public void setNewMopMethods(ArrayList arr) {
        this.newMetaMethods = arr.toArray(new MetaMethod[arr.size()]);
    }

    public synchronized void setStaticMetaClassField(MetaClass mc) {
        if (this.staticMetaClassField == NONE) {
            return;
        }
        if (this.staticMetaClassField == null) {
            CachedField[] cachedFields = this.getFields();
            for (int i = 0; i < cachedFields.length; ++i) {
                CachedField cachedField = cachedFields[i];
                if (!cachedField.getName().startsWith("$staticMetaClass") || cachedField.getType() != (class$groovy$lang$MetaClass == null ? CachedClass.class$("groovy.lang.MetaClass") : class$groovy$lang$MetaClass) || !cachedField.isStatic()) continue;
                this.staticMetaClassField = cachedField;
                break;
            }
        }
        if (this.staticMetaClassField == null) {
            this.staticMetaClassField = NONE;
            return;
        }
        ((CachedField)this.staticMetaClassField).setProperty(null, mc);
    }

    public MetaClass getMetaClassForClass() {
        Object cur = this.metaClassForClass;
        if (cur == null) {
            return null;
        }
        if (cur instanceof SoftReference) {
            SoftReference softReference = (SoftReference)cur;
            return (MetaClass)softReference.get();
        }
        return (MetaClass)this.metaClassForClass;
    }

    public void setMetaClassForClass(MetaClass metaClassForClass, boolean isConst) {
        this.metaClassForClass = isConst || metaClassForClass == null ? metaClassForClass : new SoftReference<MetaClass>(metaClassForClass);
        this.setStaticMetaClassField(metaClassForClass);
    }

    public boolean isAssignableFrom(Class argument) {
        return argument == null || ReflectionCache.isAssignableFrom(this.getCachedClass(), argument);
    }

    boolean isDirectlyAssignable(Object argument) {
        return ReflectionCache.isAssignableFrom(this.getCachedClass(), argument.getClass());
    }

    public String toString() {
        return this.cachedClass.toString();
    }

    public static class ArrayCachedClass
    extends CachedClass {
        ArrayCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            Class<?> argumentClass = argument.getClass();
            if (argumentClass.getName().charAt(0) != '[') {
                return argument;
            }
            Class<?> argumentComponent = argumentClass.getComponentType();
            Class<?> paramComponent = this.getCachedClass().getComponentType();
            if (paramComponent.isPrimitive()) {
                if (paramComponent == Boolean.TYPE && argumentClass == (array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = CachedClass.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean)) {
                    argument = DefaultTypeTransformation.convertToBooleanArray(argument);
                } else if (paramComponent == Byte.TYPE && argumentClass == (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = CachedClass.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte)) {
                    argument = DefaultTypeTransformation.convertToByteArray(argument);
                } else if (paramComponent == Character.TYPE && argumentClass == (array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = CachedClass.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character)) {
                    argument = DefaultTypeTransformation.convertToCharArray(argument);
                } else if (paramComponent == Short.TYPE && argumentClass == (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = CachedClass.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short)) {
                    argument = DefaultTypeTransformation.convertToShortArray(argument);
                } else if (paramComponent == Integer.TYPE && argumentClass == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = CachedClass.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
                    argument = DefaultTypeTransformation.convertToIntArray(argument);
                } else if (paramComponent == Long.TYPE && (argumentClass == (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = CachedClass.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long) || argumentClass == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = CachedClass.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer))) {
                    argument = DefaultTypeTransformation.convertToLongArray(argument);
                } else if (paramComponent == Float.TYPE && (argumentClass == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = CachedClass.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float) || argumentClass == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = CachedClass.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer))) {
                    argument = DefaultTypeTransformation.convertToFloatArray(argument);
                } else if (paramComponent == Double.TYPE && (argumentClass == (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = CachedClass.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double) || argumentClass == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = CachedClass.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float) || (array$Ljava$math$BigDecimal == null ? (array$Ljava$math$BigDecimal = CachedClass.class$("[Ljava.math.BigDecimal;")) : array$Ljava$math$BigDecimal).isAssignableFrom(argumentClass))) {
                    argument = DefaultTypeTransformation.convertToDoubleArray(argument);
                }
            } else if (paramComponent == (class$java$lang$String == null ? (class$java$lang$String = CachedClass.class$("java.lang.String")) : class$java$lang$String) && argument instanceof GString[]) {
                GString[] strings = (GString[])argument;
                String[] ret = new String[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    ret[i] = strings[i].toString();
                }
                argument = ret;
            } else if (paramComponent == (class$java$lang$Object == null ? (class$java$lang$Object = CachedClass.class$("java.lang.Object")) : class$java$lang$Object) && argumentComponent.isPrimitive()) {
                argument = DefaultTypeTransformation.primitiveArrayBox(argument);
            }
            return argument;
        }
    }

    public static class CharacterCachedClass
    extends CachedClass {
        public CharacterCachedClass(Class klazz) {
            super(klazz);
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Character == null ? (class$java$lang$Character = CachedClass.class$("java.lang.Character")) : class$java$lang$Character) || classToTransformFrom == Character.TYPE;
        }
    }

    public static class BooleanCachedClass
    extends CachedClass {
        BooleanCachedClass(Class klazz) {
            super(klazz);
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CachedClass.class$("java.lang.Boolean")) : class$java$lang$Boolean) || classToTransformFrom == Boolean.TYPE;
        }
    }

    public static class StringCachedClass
    extends CachedClass {
        private static final Class STRING_CLASS = class$java$lang$String == null ? (class$java$lang$String = CachedClass.class$("java.lang.String")) : class$java$lang$String;
        private static final Class GSTRING_CLASS = class$groovy$lang$GString == null ? (class$groovy$lang$GString = CachedClass.class$("groovy.lang.GString")) : class$groovy$lang$GString;

        StringCachedClass() {
            super(STRING_CLASS);
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof String;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == STRING_CLASS || ReflectionCache.isAssignableFrom(GSTRING_CLASS, classToTransformFrom);
        }

        public Object coerceArgument(Object argument) {
            return argument instanceof GString ? argument.toString() : argument;
        }
    }

    public static class BigDecimalCachedClass
    extends DoubleCachedClass {
        BigDecimalCachedClass(Class klazz) {
            super(klazz);
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof BigDecimal;
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof BigDecimal) {
                return argument;
            }
            return new BigDecimal(((Number)argument).doubleValue());
        }
    }

    public static class DoubleCachedClass
    extends NumberCachedClass {
        DoubleCachedClass(Class klazz) {
            super(klazz);
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof Double;
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Double) {
                return argument;
            }
            Double res = new Double(((Number)argument).doubleValue());
            if (argument instanceof BigDecimal && res.isInfinite()) {
                throw new IllegalArgumentException((class$java$lang$Double == null ? (class$java$lang$Double = CachedClass.class$("java.lang.Double")) : class$java$lang$Double) + " out of range while converting from BigDecimal");
            }
            return res;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Double == null ? (class$java$lang$Double = CachedClass.class$("java.lang.Double")) : class$java$lang$Double) || classToTransformFrom == (class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClass.class$("java.lang.Integer")) : class$java$lang$Integer) || classToTransformFrom == (class$java$lang$Long == null ? (class$java$lang$Long = CachedClass.class$("java.lang.Long")) : class$java$lang$Long) || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == (class$java$lang$Float == null ? (class$java$lang$Float = CachedClass.class$("java.lang.Float")) : class$java$lang$Float) || classToTransformFrom == Double.TYPE || classToTransformFrom == Integer.TYPE || classToTransformFrom == Long.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE || classToTransformFrom == Float.TYPE || classToTransformFrom == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CachedClass.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || classToTransformFrom == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = CachedClass.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        }
    }

    public static class FloatCachedClass
    extends NumberCachedClass {
        FloatCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Float) {
                return argument;
            }
            Float res = new Float(((Number)argument).floatValue());
            if (argument instanceof BigDecimal && res.isInfinite()) {
                throw new IllegalArgumentException((class$java$lang$Float == null ? (class$java$lang$Float = CachedClass.class$("java.lang.Float")) : class$java$lang$Float) + " out of range while converting from BigDecimal");
            }
            return res;
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof Float;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Float == null ? (class$java$lang$Float = CachedClass.class$("java.lang.Float")) : class$java$lang$Float) || classToTransformFrom == (class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClass.class$("java.lang.Integer")) : class$java$lang$Integer) || classToTransformFrom == (class$java$lang$Long == null ? (class$java$lang$Long = CachedClass.class$("java.lang.Long")) : class$java$lang$Long) || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == Float.TYPE || classToTransformFrom == Integer.TYPE || classToTransformFrom == Long.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE;
        }
    }

    public static class LongCachedClass
    extends NumberCachedClass {
        LongCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Long) {
                return argument;
            }
            return new Long(((Number)argument).longValue());
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof Long;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClass.class$("java.lang.Integer")) : class$java$lang$Integer) || classToTransformFrom == (class$java$lang$Long == null ? (class$java$lang$Long = CachedClass.class$("java.lang.Long")) : class$java$lang$Long) || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == Integer.TYPE || classToTransformFrom == Long.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE;
        }
    }

    public static class ShortCachedClass
    extends NumberCachedClass {
        ShortCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Short) {
                return argument;
            }
            return new Short(((Number)argument).shortValue());
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof Short;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE;
        }
    }

    public static class BigIntegerCachedClass
    extends NumberCachedClass {
        BigIntegerCachedClass(Class klazz) {
            super(klazz);
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument instanceof BigInteger;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClass.class$("java.lang.Integer")) : class$java$lang$Integer) || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = CachedClass.class$("java.math.BigInteger")) : class$java$math$BigInteger) || classToTransformFrom == (class$java$lang$Long == null ? (class$java$lang$Long = CachedClass.class$("java.lang.Long")) : class$java$lang$Long) || classToTransformFrom == Integer.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE || classToTransformFrom == Long.TYPE;
        }
    }

    public static class IntegerCachedClass
    extends NumberCachedClass {
        IntegerCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Integer) {
                return argument;
            }
            return new Integer(((Number)argument).intValue());
        }

        boolean isDirectlyAssignable(Object argument) {
            return argument == null || argument instanceof Integer;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || classToTransformFrom == (class$java$lang$Integer == null ? (class$java$lang$Integer = CachedClass.class$("java.lang.Integer")) : class$java$lang$Integer) || classToTransformFrom == (class$java$lang$Short == null ? (class$java$lang$Short = CachedClass.class$("java.lang.Short")) : class$java$lang$Short) || classToTransformFrom == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte) || classToTransformFrom == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = CachedClass.class$("java.math.BigInteger")) : class$java$math$BigInteger) || classToTransformFrom == Integer.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Byte.TYPE;
        }
    }

    public static class NumberCachedClass
    extends CachedClass {
        NumberCachedClass(Class klazz) {
            super(klazz);
        }

        public Object coerceArgument(Object argument) {
            if (argument instanceof Number) {
                return this.coerceNumber(argument);
            }
            return argument;
        }

        public boolean isAssignableFrom(Class classToTransformFrom) {
            return classToTransformFrom == null || (class$java$lang$Number == null ? (class$java$lang$Number = CachedClass.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(classToTransformFrom) || classToTransformFrom == Byte.TYPE || classToTransformFrom == Short.TYPE || classToTransformFrom == Integer.TYPE || classToTransformFrom == Long.TYPE || classToTransformFrom == Float.TYPE || classToTransformFrom == Double.TYPE;
        }

        private Object coerceNumber(Object argument) {
            Class param = this.getCachedClass();
            if (param == (class$java$lang$Byte == null ? (class$java$lang$Byte = CachedClass.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                argument = new Byte(((Number)argument).byteValue());
            } else if (param == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = CachedClass.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                argument = new BigInteger(String.valueOf((Number)argument));
            }
            return argument;
        }
    }

    public static class CachedMethodComparatorWithString
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorWithString();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo((String)o2);
        }
    }

    public static class CachedMethodComparatorByName
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorByName();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo(((CachedMethod)o2).getName());
        }
    }
}

