/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.FastArray;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class MetaClassHelper {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Class[] EMPTY_TYPE_ARRAY = new Class[0];
    public static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    protected static final Logger LOG = Logger.getLogger(MetaClassHelper.class.getName());
    private static final int MAX_ARG_LEN = 12;
    private static final Class[] PRIMITIVES = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, Number.class, Object.class};
    private static final int[][] PRIMITIVE_DISTANCE_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {14, 15, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {14, 15, 12, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {14, 15, 12, 13, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {14, 15, 12, 13, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {14, 15, 12, 13, 10, 11, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9}, {14, 15, 12, 13, 10, 11, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 0, 1, 2, 3, 4, 5, 6}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 1, 0, 2, 3, 4, 5, 6}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 0, 1, 2, 3, 4}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 1, 0, 2, 3, 4}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 0, 1, 2}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 0, 1}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 1, 0}};

    public static boolean accessibleToConstructor(Class at, Constructor constructor) {
        boolean accessible = false;
        int modifiers = constructor.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            accessible = true;
        } else if (Modifier.isPrivate(modifiers)) {
            accessible = at.getName().equals(constructor.getName());
        } else if (Modifier.isProtected(modifiers)) {
            Boolean isAccessible = MetaClassHelper.checkCompatiblePackages(at, constructor);
            if (isAccessible != null) {
                accessible = isAccessible;
            } else {
                boolean flag = false;
                for (Class clazz = at; !flag && clazz != null; clazz = clazz.getSuperclass()) {
                    if (clazz.equals(constructor.getDeclaringClass())) {
                        flag = true;
                        break;
                    }
                    if (clazz.equals(class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) break;
                }
                accessible = flag;
            }
        } else {
            Boolean isAccessible = MetaClassHelper.checkCompatiblePackages(at, constructor);
            if (isAccessible != null) {
                accessible = isAccessible;
            }
        }
        return accessible;
    }

    private static Boolean checkCompatiblePackages(Class at, Constructor constructor) {
        if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
            return Boolean.TRUE;
        }
        if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
            return Boolean.FALSE;
        }
        if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
            return Boolean.FALSE;
        }
        if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static Object[] asWrapperArray(Object parameters, Class componentType) {
        Object[] ret;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        ret = null;
                                        if (componentType != Boolean.TYPE) break block8;
                                        boolean[] array = (boolean[])parameters;
                                        ret = new Object[array.length];
                                        for (int i = 0; i < array.length; ++i) {
                                            ret[i] = new Boolean(array[i]);
                                        }
                                        break block9;
                                    }
                                    if (componentType != Character.TYPE) break block10;
                                    char[] array = (char[])parameters;
                                    ret = new Object[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        ret[i] = new Character(array[i]);
                                    }
                                    break block9;
                                }
                                if (componentType != Byte.TYPE) break block11;
                                byte[] array = (byte[])parameters;
                                ret = new Object[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    ret[i] = new Byte(array[i]);
                                }
                                break block9;
                            }
                            if (componentType != Integer.TYPE) break block12;
                            int[] array = (int[])parameters;
                            ret = new Object[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                ret[i] = new Integer(array[i]);
                            }
                            break block9;
                        }
                        if (componentType != Short.TYPE) break block13;
                        short[] array = (short[])parameters;
                        ret = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            ret[i] = new Short(array[i]);
                        }
                        break block9;
                    }
                    if (componentType != Long.TYPE) break block14;
                    long[] array = (long[])parameters;
                    ret = new Object[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        ret[i] = new Long(array[i]);
                    }
                    break block9;
                }
                if (componentType != Double.TYPE) break block15;
                double[] array = (double[])parameters;
                ret = new Object[array.length];
                for (int i = 0; i < array.length; ++i) {
                    ret[i] = new Double(array[i]);
                }
                break block9;
            }
            if (componentType != Float.TYPE) break block9;
            float[] array = (float[])parameters;
            ret = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = new Float(array[i]);
            }
        }
        return ret;
    }

    public static Object asPrimitiveArray(List list, Class parameterType) {
        Class<?> arrayType = parameterType.getComponentType();
        Object objArray = Array.newInstance(arrayType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (arrayType.isPrimitive()) {
                if (obj instanceof Integer) {
                    Array.setInt(objArray, i, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    Array.setDouble(objArray, i, (Double)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    Array.setBoolean(objArray, i, (Boolean)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    Array.setLong(objArray, i, (Long)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    Array.setFloat(objArray, i, ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Character) {
                    Array.setChar(objArray, i, ((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    Array.setByte(objArray, i, (Byte)obj);
                    continue;
                }
                if (!(obj instanceof Short)) continue;
                Array.setShort(objArray, i, (Short)obj);
                continue;
            }
            Array.set(objArray, i, obj);
        }
        return objArray;
    }

    private static int getPrimitiveIndex(Class c) {
        for (int i = 0; i < PRIMITIVES.length; i = (int)((byte)(i + 1))) {
            if (PRIMITIVES[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static int getPrimitiveDistance(Class from, Class to) {
        int fromIndex = MetaClassHelper.getPrimitiveIndex(from);
        int toIndex = MetaClassHelper.getPrimitiveIndex(to);
        if (fromIndex == -1 || toIndex == -1) {
            return -1;
        }
        return PRIMITIVE_DISTANCE_TABLE[toIndex][fromIndex];
    }

    private static int getMaximumInterfaceDistance(Class c, Class interfaceClass) {
        if (c == null || c == interfaceClass) {
            return 0;
        }
        Class<?>[] interfaces = c.getInterfaces();
        int max = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            int sub = 1 + MetaClassHelper.getMaximumInterfaceDistance(interfaces[i], interfaceClass);
            max = Math.max(max, sub);
        }
        return Math.max(max, MetaClassHelper.getMaximumInterfaceDistance(c.getSuperclass(), interfaceClass));
    }

    private static long calculateParameterDistance(Class argument, Class parameter) {
        if (parameter == argument) {
            return 0L;
        }
        if (parameter.isInterface()) {
            long ret = PRIMITIVES.length;
            ret = ret << 32 | (long)MetaClassHelper.getMaximumInterfaceDistance(argument, parameter);
            return ret;
        }
        long objectDistance = 0L;
        if (argument != null) {
            if (parameter.isArray()) {
                if (argument.isArray()) {
                    return MetaClassHelper.calculateParameterDistance(argument.getComponentType(), parameter.getComponentType());
                }
                parameter = parameter.getComponentType();
                ++objectDistance;
            } else if (argument.isArray()) {
                ++objectDistance;
            }
            long pd = MetaClassHelper.getPrimitiveDistance(parameter, argument);
            if (pd != -1L) {
                return pd << 33;
            }
            objectDistance += (long)(PRIMITIVES.length << 2);
            Class clazz = ReflectionCache.autoboxType(argument);
            while (clazz != null && clazz != parameter) {
                if (clazz == (class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString) && parameter == (class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String)) {
                    objectDistance += 2L;
                    break;
                }
                clazz = clazz.getSuperclass();
                objectDistance += 3L;
            }
        } else {
            --objectDistance;
            Class<?> clazz = parameter;
            if (clazz.isPrimitive()) {
                objectDistance += 2L;
            } else {
                while (clazz != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                    clazz = clazz.getSuperclass();
                    objectDistance += 2L;
                }
            }
        }
        return objectDistance << 32;
    }

    public static long calculateParameterDistance(Class[] arguments, Class[] parameters) {
        long ret = 0L;
        for (int i = 0; i < arguments.length; ++i) {
            ret += MetaClassHelper.calculateParameterDistance(arguments[i], parameters[i]);
        }
        return ret;
    }

    public static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    public static Object chooseEmptyMethodParams(FastArray methods) {
        Object vargsMethod = null;
        int len = methods.size();
        Object[] data = methods.getArray();
        for (int i = 0; i != len; ++i) {
            Object method = data[i];
            ParameterTypes pt = MetaClassHelper.getParameterTypes(method);
            CachedClass[] paramTypes = pt.getParameterTypes();
            int paramLength = paramTypes.length;
            if (paramLength == 0) {
                return method;
            }
            if (paramLength != 1 || !pt.isVargsMethod(EMPTY_ARRAY)) continue;
            vargsMethod = method;
        }
        return vargsMethod;
    }

    public static Object chooseMostGeneralMethodWith1NullParam(FastArray methods) {
        CachedClass closestClass = null;
        CachedClass closestVargsClass = null;
        Object answer = null;
        int closestDist = -1;
        int len = methods.size();
        for (int i = 0; i != len; ++i) {
            int newDist;
            Object[] data = methods.getArray();
            Object method = data[i];
            ParameterTypes pt = MetaClassHelper.getParameterTypes(method);
            CachedClass[] paramTypes = pt.getParameterTypes();
            int paramLength = paramTypes.length;
            if (paramLength == 0 || paramLength > 2) continue;
            CachedClass theType = paramTypes[0];
            if (theType.isPrimitive) continue;
            if (paramLength == 2) {
                if (!pt.isVargsMethod(ARRAY_WITH_NULL)) continue;
                if (closestClass == null) {
                    closestVargsClass = paramTypes[1];
                    closestClass = theType;
                    answer = method;
                    continue;
                }
                if (closestClass.getCachedClass() == theType.getCachedClass()) {
                    if (closestVargsClass == null) continue;
                    CachedClass newVargsClass = paramTypes[1];
                    if (closestVargsClass != null && !MetaClassHelper.isAssignableFrom(newVargsClass.getCachedClass(), closestVargsClass.getCachedClass())) continue;
                    closestVargsClass = newVargsClass;
                    answer = method;
                    continue;
                }
                if (!MetaClassHelper.isAssignableFrom(theType.getCachedClass(), closestClass.getCachedClass())) continue;
                closestVargsClass = paramTypes[1];
                closestClass = theType;
                answer = method;
                continue;
            }
            if (closestClass == null || MetaClassHelper.isAssignableFrom(theType.getCachedClass(), closestClass.getCachedClass())) {
                closestVargsClass = null;
                closestClass = theType;
                answer = method;
                closestDist = -1;
                continue;
            }
            if (closestDist == -1) {
                closestDist = closestClass.getSuperClassDistance();
            }
            if ((newDist = theType.getSuperClassDistance()) >= closestDist) continue;
            closestDist = newDist;
            closestVargsClass = null;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    private static int calculateSimplifiedClassDistanceToObject(Class clazz) {
        int objectDistance = 0;
        while (clazz != null) {
            clazz = clazz.getSuperclass();
            ++objectDistance;
        }
        return objectDistance;
    }

    public static boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CachedClass[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            CachedClass[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static Class[] convertToTypeArray(Object[] args) {
        if (args == null) {
            return null;
        }
        int s = args.length;
        Class[] ans = new Class[s];
        for (int i = 0; i < s; ++i) {
            Object o = args[i];
            ans[i] = o == null ? null : (o instanceof Wrapper ? ((Wrapper)o).getType() : o.getClass());
        }
        return ans;
    }

    public static Object doConstructorInvoke(CachedConstructor constructor, Object[] argumentArray) {
        Constructor constr = constructor.cachedConstructor;
        if (LOG.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(constr.getDeclaringClass(), constr.getName(), argumentArray);
        }
        argumentArray = constructor.coerceArgumentsToClasses(argumentArray);
        try {
            return constr.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e, false);
        }
        catch (IllegalAccessException e) {
            throw MetaClassHelper.createExceptionText("could not access constructor: ", constr, argumentArray, e, false);
        }
        catch (Exception e) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e, true);
        }
    }

    private static GroovyRuntimeException createExceptionText(String init, Constructor constructor, Object[] argumentArray, Throwable e, boolean setReason) {
        throw new GroovyRuntimeException(init + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, setReason ? e : null);
    }

    public static Object makeCommonArray(Object[] arguments, int offset, Class fallback) {
        Class<?> baseClass = null;
        for (int i = offset; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            Class<?> argClass = arguments[i].getClass();
            if (baseClass == null) {
                baseClass = argClass;
                continue;
            }
            while (baseClass != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object) && !baseClass.isAssignableFrom(argClass)) {
                baseClass = baseClass.getSuperclass();
            }
        }
        if (baseClass == null) {
            baseClass = fallback;
        }
        Object result = MetaClassHelper.makeArray(null, baseClass, arguments.length - offset);
        System.arraycopy(arguments, offset, result, 0, arguments.length - offset);
        return result;
    }

    public static Object makeArray(Object obj, Class secondary, int length) {
        Class<?> baseClass = secondary;
        if (obj != null) {
            baseClass = obj.getClass();
        }
        return Array.newInstance(baseClass, length);
    }

    private static GroovyRuntimeException createExceptionText(String init, MetaMethod method, Object object, Object[] args, Throwable reason, boolean setReason) {
        return new GroovyRuntimeException(init + method + " on: " + object + " with arguments: " + InvokerHelper.toString(args) + " reason: " + reason, setReason ? reason : null);
    }

    public static Object doMethodInvoke(Object object, MetaMethod method, Object[] argumentArray) {
        argumentArray = method.getParamTypes().coerceArgumentsToClasses(argumentArray);
        try {
            return method.invoke(object, argumentArray);
        }
        catch (IllegalArgumentException e) {
            boolean setReason = e.getClass() != IllegalArgumentException.class;
            throw MetaClassHelper.createExceptionText("failed to invoke method: ", method, object, argumentArray, e, setReason);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw MetaClassHelper.createExceptionText("failed to invoke method: ", method, object, argumentArray, e, true);
        }
    }

    protected static String getClassName(Object object) {
        if (object == null) {
            return null;
        }
        return object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        return new MethodClosure(object, methodName);
    }

    public static ParameterTypes getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof ParameterTypes) {
            return (ParameterTypes)methodOrConstructor;
        }
        if (methodOrConstructor instanceof MetaMethod) {
            return ((MetaMethod)methodOrConstructor).getParamTypes();
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return CachedMethod.find(method);
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return CachedConstructor.find(constructor);
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    public static boolean isAssignableFrom(Class classToTransformTo, Class classToTransformFrom) {
        if (classToTransformFrom == null) {
            return true;
        }
        if ((classToTransformTo = ReflectionCache.autoboxType(classToTransformTo)) == (classToTransformFrom = ReflectionCache.autoboxType(classToTransformFrom))) {
            return true;
        }
        if (classToTransformTo == Integer.class ? classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Double.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigDecimal.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigInteger.class ? classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Long.class ? classToTransformFrom == Long.class || classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Float.class ? classToTransformFrom == Float.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Short.class ? classToTransformFrom == Short.class || classToTransformFrom == Byte.class : classToTransformTo == String.class && (classToTransformFrom == String.class || GString.class.isAssignableFrom(classToTransformFrom))))))))) {
            return true;
        }
        return ReflectionCache.isAssignableFrom(classToTransformTo, classToTransformFrom);
    }

    public static boolean isGenericSetMethod(MetaMethod method) {
        return method.getName().equals("set") && method.getParameterTypes().length == 2;
    }

    protected static boolean isSuperclass(Class claszz, Class superclass) {
        while (claszz != null) {
            if (claszz == superclass) {
                return true;
            }
            claszz = claszz.getSuperclass();
        }
        return false;
    }

    public static boolean isValidMethod(ParameterTypes pt, Class[] arguments, boolean includeCoerce) {
        if (arguments == null) {
            return true;
        }
        int size = arguments.length;
        CachedClass[] paramTypes = pt.getParameterTypes();
        if ((size >= paramTypes.length || size == paramTypes.length - 1) && paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray) {
            for (int i = 0; i < paramTypes.length - 1; ++i) {
                if (MetaClassHelper.isAssignableFrom(paramTypes[i].getCachedClass(), arguments[i])) continue;
                return false;
            }
            Class<?> clazz = paramTypes[paramTypes.length - 1].getCachedClass().getComponentType();
            for (int i = paramTypes.length; i < size; ++i) {
                if (MetaClassHelper.isAssignableFrom(clazz, arguments[i])) continue;
                return false;
            }
            return true;
        }
        if (paramTypes.length == size) {
            for (int i = 0; i < size; ++i) {
                if (MetaClassHelper.isAssignableFrom(paramTypes[i].getCachedClass(), arguments[i])) continue;
                return false;
            }
            return true;
        }
        return paramTypes.length == 1 && size == 0;
    }

    public static boolean isValidMethod(Object method, Class[] arguments, boolean includeCoerce) {
        return MetaClassHelper.isValidMethod(MetaClassHelper.getParameterTypes(method), arguments, includeCoerce);
    }

    public static void logMethodCall(Object object, String methodName, Object[] arguments) {
        String className = MetaClassHelper.getClassName(object);
        String logname = "methodCalls." + className + "." + methodName;
        Logger objLog = Logger.getLogger(logname);
        if (!objLog.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer msg = new StringBuffer(methodName);
        msg.append("(");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                msg.append(MetaClassHelper.normalizedValue(arguments[i]));
                if (++i >= arguments.length) continue;
                msg.append(",");
            }
        }
        msg.append(")");
        objLog.logp(Level.FINER, className, msg.toString(), "called from MetaClass.invokeMethod");
    }

    protected static String normalizedValue(Object argument) {
        String value;
        try {
            value = argument.toString();
            if (value.length() > 12) {
                value = value.substring(0, 10) + "..";
            }
            if (argument instanceof String) {
                value = "'" + value + "'";
            }
        }
        catch (Exception e) {
            value = MetaClassHelper.shortName(argument);
        }
        return value;
    }

    public static boolean parametersAreCompatible(Class[] arguments, Class[] parameters) {
        if (arguments.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (MetaClassHelper.isAssignableFrom(parameters[i], arguments[i])) continue;
            return false;
        }
        return true;
    }

    protected static String shortName(Object object) {
        if (object == null || object.getClass() == null) {
            return "unknownClass";
        }
        String name = MetaClassHelper.getClassName(object);
        if (name == null) {
            return "unknownClassName";
        }
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos < 0 || lastDotPos >= name.length() - 1) {
            return name;
        }
        return name.substring(lastDotPos + 1);
    }

    public static Class[] wrap(Class[] classes) {
        Class[] wrappedArguments = new Class[classes.length];
        for (int i = 0; i < wrappedArguments.length; ++i) {
            Class c = classes[i];
            if (c == null) continue;
            if (c.isPrimitive()) {
                if (c == Integer.TYPE) {
                    c = class$java$lang$Integer == null ? MetaClassHelper.class$("java.lang.Integer") : class$java$lang$Integer;
                } else if (c == Byte.TYPE) {
                    c = class$java$lang$Byte == null ? MetaClassHelper.class$("java.lang.Byte") : class$java$lang$Byte;
                } else if (c == Long.TYPE) {
                    c = class$java$lang$Long == null ? MetaClassHelper.class$("java.lang.Long") : class$java$lang$Long;
                } else if (c == Double.TYPE) {
                    c = class$java$lang$Double == null ? MetaClassHelper.class$("java.lang.Double") : class$java$lang$Double;
                } else if (c == Float.TYPE) {
                    c = class$java$lang$Float == null ? MetaClassHelper.class$("java.lang.Float") : class$java$lang$Float;
                }
            } else if (MetaClassHelper.isSuperclass(c, class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString)) {
                c = class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String;
            }
            wrappedArguments[i] = c;
        }
        return wrappedArguments;
    }
}

