/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.metaclass.MethodHelper;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;

public class CachedMethod
extends ParameterTypes
implements Comparable {
    public final CachedClass cachedClass;
    public final Method cachedMethod;
    private boolean alreadySetAccessible;
    private int methodIndex;
    private int hashCode;
    private MetaMethod reflectionMetaMethod;

    public CachedMethod(CachedClass clazz, Method method) {
        this.cachedMethod = method;
        this.cachedClass = clazz;
        this.alreadySetAccessible = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public CachedMethod(Method method) {
        this(ReflectionCache.getCachedClass(method.getDeclaringClass()), method);
    }

    public static CachedMethod find(Method method) {
        Object[] methods = ReflectionCache.getCachedClass(method.getDeclaringClass()).getMethods();
        int i = Arrays.binarySearch(methods, method);
        if (i < 0) {
            return null;
        }
        return methods[i];
    }

    Class[] getPT() {
        return this.cachedMethod.getParameterTypes();
    }

    public String getName() {
        return this.cachedMethod.getName();
    }

    public String getDescriptor() {
        return BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
    }

    public Class getDeclaringClass() {
        return this.cachedClass.getCachedClass();
    }

    public Class getReturnType() {
        return this.cachedMethod.getReturnType();
    }

    public int getParamsCount() {
        return this.getParameterTypes().length;
    }

    public int getModifiers() {
        return this.cachedMethod.getModifiers();
    }

    public String getSignature() {
        return this.getName() + this.getDescriptor();
    }

    public Method setAccessible() {
        if (!this.alreadySetAccessible) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CachedMethod.this.cachedMethod.setAccessible(true);
                    return null;
                }
            });
        }
        this.alreadySetAccessible = true;
        return this.cachedMethod;
    }

    public boolean isStatic() {
        return MethodHelper.isStatic(this.cachedMethod);
    }

    public void setMethodIndex(int i) {
        this.methodIndex = i;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public boolean canBeCalledByReflector() {
        if (!Modifier.isPublic(this.cachedClass.getModifiers())) {
            return false;
        }
        if (!Modifier.isPublic(this.getModifiers())) {
            return false;
        }
        this.getParameterTypes();
        for (int i = 0; i != this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].isPrimitive || Modifier.isPublic(this.parameterTypes[i].getModifiers())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof CachedMethod) {
            return this.compareToCachedMethod((CachedMethod)o);
        }
        return this.compareToMethod((Method)o);
    }

    private int compareToCachedMethod(CachedMethod m) {
        CachedClass[] mparams;
        if (m == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i = 0; i != params.length; ++i) {
            int nameComp = params[i].getName().compareTo(mparams[i].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        throw new RuntimeException("Should never happen");
    }

    private int compareToMethod(Method m) {
        Class<?>[] mparams;
        if (m == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i = 0; i != params.length; ++i) {
            int nameComp = params[i].getName().compareTo(mparams[i].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof CachedMethod && this.cachedMethod.equals(((CachedMethod)o).cachedMethod) || o instanceof Method && this.cachedMethod.equals(o);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.cachedMethod.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return this.cachedMethod.toString();
    }

    public MetaMethod getReflectionMetaMethod() {
        if (this.reflectionMetaMethod == null) {
            this.reflectionMetaMethod = new ReflectionMetaMethod(this);
        }
        return this.reflectionMetaMethod;
    }
}

