/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.reflect.Array;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class ParameterTypes {
    private Class[] nativeParamTypes;
    private CachedClass[] parameterTypes;

    public ParameterTypes() {
    }

    public ParameterTypes(Class[] pt) {
        this.nativeParamTypes = pt;
    }

    public ParameterTypes(CachedClass[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public CachedClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            if (this.nativeParamTypes == null) {
                this.nativeParamTypes = this.getPT();
            }
            this.parameterTypes = new CachedClass[this.nativeParamTypes.length];
            for (int i = 0; i != this.nativeParamTypes.length; ++i) {
                this.parameterTypes[i] = ReflectionCache.getCachedClass(this.nativeParamTypes[i]);
            }
        }
        return this.parameterTypes;
    }

    public Class[] getNativeParameterTypes() {
        if (this.nativeParamTypes == null) {
            if (this.parameterTypes != null) {
                this.nativeParamTypes = new Class[this.parameterTypes.length];
                for (int i = 0; i != this.parameterTypes.length; ++i) {
                    this.nativeParamTypes[i] = this.parameterTypes[i].cachedClass;
                }
            } else {
                this.nativeParamTypes = this.getPT();
            }
        }
        return this.nativeParamTypes;
    }

    Class[] getPT() {
        return null;
    }

    public boolean isVargsMethod(Object[] arguments) {
        this.getParameterTypes();
        if (this.parameterTypes.length == 0) {
            return false;
        }
        int lenMinus1 = this.parameterTypes.length - 1;
        if (!this.parameterTypes[lenMinus1].isArray) {
            return false;
        }
        if (lenMinus1 == arguments.length) {
            return true;
        }
        if (lenMinus1 > arguments.length) {
            return false;
        }
        if (arguments.length > this.parameterTypes.length) {
            return true;
        }
        Object last = arguments[arguments.length - 1];
        if (last == null) {
            return true;
        }
        Class<?> clazz = last.getClass();
        return !clazz.equals(this.parameterTypes[lenMinus1].cachedClass);
    }

    public Object[] coerceArgumentsToClasses(Object[] argumentArray) {
        this.getParameterTypes();
        if (argumentArray == null) {
            argumentArray = MetaClassHelper.EMPTY_ARRAY;
        } else if (this.parameterTypes.length == 1 && argumentArray.length == 0) {
            argumentArray = this.isVargsMethod(argumentArray) ? new Object[]{Array.newInstance(this.parameterTypes[0].cachedClass.getComponentType(), 0)} : MetaClassHelper.ARRAY_WITH_NULL;
        } else if (this.isVargsMethod(argumentArray)) {
            argumentArray = ParameterTypes.fitToVargs(argumentArray, this.parameterTypes);
        }
        for (int i = 0; i < argumentArray.length; ++i) {
            Object argument = argumentArray[i];
            if (argument == null) continue;
            CachedClass parameterType = this.parameterTypes[i];
            if (ReflectionCache.isAssignableFrom(parameterType.cachedClass, argument.getClass())) continue;
            argument = parameterType.coerceGString(argument);
            argument = parameterType.coerceNumber(argument);
            argumentArray[i] = argument = parameterType.coerceArray(argument);
        }
        return argumentArray;
    }

    private static Object[] fitToVargs(Object[] argumentArray, CachedClass[] paramTypes) {
        Class vargsClass = ReflectionCache.autoboxType(paramTypes[paramTypes.length - 1].cachedClass.getComponentType());
        if (argumentArray.length == paramTypes.length - 1) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, argumentArray.length);
            newArgs[newArgs.length - 1] = vargs = MetaClassHelper.makeArray(null, vargsClass, 0);
            return newArgs;
        }
        if (argumentArray.length == paramTypes.length) {
            Object lastArgument = argumentArray[argumentArray.length - 1];
            if (lastArgument != null && !lastArgument.getClass().isArray()) {
                Object vargs = MetaClassHelper.makeArray(lastArgument, vargsClass, 1);
                System.arraycopy(argumentArray, argumentArray.length - 1, vargs, 0, 1);
                argumentArray[argumentArray.length - 1] = vargs;
                return argumentArray;
            }
            return argumentArray;
        }
        if (argumentArray.length > paramTypes.length) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, paramTypes.length - 1);
            int numberOfVargs = argumentArray.length - paramTypes.length;
            newArgs[newArgs.length - 1] = vargs = MetaClassHelper.makeCommonArray(argumentArray, paramTypes.length - 1, vargsClass);
            return newArgs;
        }
        throw new GroovyBugError("trying to call a vargs method without enough arguments");
    }
}

