/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ObjectRange
extends AbstractList
implements Range {
    private Comparable from;
    private Comparable to;
    private int size = -1;
    private final boolean reverse;

    public ObjectRange(Comparable from, Comparable to) {
        if (from == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'from' index in a Range");
        }
        if (to == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'to' index in a Range");
        }
        this.reverse = ScriptBytecodeAdapter.compareGreaterThan(from, to);
        if (this.reverse) {
            this.constructorHelper(to, from);
        } else {
            this.constructorHelper(from, to);
        }
    }

    public ObjectRange(Comparable from, Comparable to, boolean reverse) {
        this.constructorHelper(from, to);
        this.reverse = reverse;
    }

    private void constructorHelper(Comparable from, Comparable to) {
        if (from instanceof Short) {
            from = new Integer(((Short)from).intValue());
        }
        if (to instanceof Short) {
            to = new Integer(((Short)to).intValue());
        }
        if (from instanceof Float) {
            from = new Double(((Float)from).doubleValue());
        }
        if (to instanceof Float) {
            to = new Double(((Float)to).doubleValue());
        }
        if (from.getClass() == to.getClass()) {
            this.from = from;
            this.to = to;
        } else {
            this.from = ObjectRange.normaliseStringType(from);
            this.to = ObjectRange.normaliseStringType(to);
        }
        if (from instanceof String || to instanceof String) {
            int i;
            String start = from.toString();
            String end = to.toString();
            if (start.length() > end.length()) {
                throw new IllegalArgumentException("Incompatible Strings for Range: starting String is longer than ending string");
            }
            int length = Math.min(start.length(), end.length());
            for (i = 0; i < length && start.charAt(i) == end.charAt(i); ++i) {
            }
            if (i < length - 1) {
                throw new IllegalArgumentException("Incompatible Strings for Range: String#next() will not reach the expected value");
            }
        }
    }

    public boolean equals(Object that) {
        return that instanceof ObjectRange ? this.equals((ObjectRange)that) : super.equals(that);
    }

    public boolean equals(ObjectRange that) {
        return that != null && this.reverse == that.reverse && DefaultTypeTransformation.compareEqual(this.from, that.from) && DefaultTypeTransformation.compareEqual(this.to, that.to);
    }

    public Comparable getFrom() {
        return this.from;
    }

    public Comparable getTo() {
        return this.to;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public Object get(int index) {
        Object value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " is too big for range: " + this);
        }
        if (this.reverse) {
            value = this.to;
            for (int i = 0; i < index; ++i) {
                value = this.decrement(value);
            }
        } else {
            value = this.from;
            for (int i = 0; i < index; ++i) {
                value = this.increment(value);
            }
        }
        return value;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private Object value;
            {
                this.value = ObjectRange.this.reverse ? ObjectRange.this.to : ObjectRange.this.from;
            }

            public boolean hasNext() {
                return this.index < ObjectRange.this.size();
            }

            public Object next() {
                if (this.index++ > 0) {
                    this.value = this.index > ObjectRange.this.size() ? null : (ObjectRange.this.reverse ? ObjectRange.this.decrement(this.value) : ObjectRange.this.increment(this.value));
                }
                return this.value;
            }

            public void remove() {
                ObjectRange.this.remove(this.index);
            }
        };
    }

    public boolean containsWithinBounds(Object value) {
        if (value instanceof Comparable) {
            int result = this.from.compareTo(value);
            return result == 0 || result < 0 && this.to.compareTo(value) >= 0;
        }
        return this.contains(value);
    }

    public int size() {
        if (this.size == -1) {
            if (this.from instanceof Integer && this.to instanceof Integer || this.from instanceof Long && this.to instanceof Long) {
                this.size = 0;
                int fromNum = ((Number)((Object)this.from)).intValue();
                int toNum = ((Number)((Object)this.to)).intValue();
                this.size = toNum - fromNum + 1;
            } else if (this.from instanceof Character && this.to instanceof Character) {
                this.size = 0;
                char fromNum = ((Character)this.from).charValue();
                char toNum = ((Character)this.to).charValue();
                this.size = toNum - fromNum + 1;
            } else if (this.from instanceof BigDecimal || this.to instanceof BigDecimal) {
                this.size = 0;
                BigDecimal fromNum = new BigDecimal("" + this.from);
                BigDecimal toNum = new BigDecimal("" + this.to);
                BigInteger sizeNum = toNum.subtract(fromNum).add(new BigDecimal(1.0)).toBigInteger();
                this.size = sizeNum.intValue();
            } else {
                this.size = 0;
                Object value = this.from;
                while (this.to.compareTo(value) >= 0) {
                    value = this.increment(value);
                    ++this.size;
                }
            }
        }
        return this.size;
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange(this.from);
        }
        return new ObjectRange((Comparable)this.get(fromIndex), (Comparable)this.get(--toIndex), this.reverse);
    }

    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    public String inspect() {
        String toText = InvokerHelper.inspect(this.to);
        String fromText = InvokerHelper.inspect(this.from);
        return this.reverse ? "" + toText + ".." + fromText : "" + fromText + ".." + toText;
    }

    public boolean contains(Object value) {
        Iterator it = this.iterator();
        if (value == null) {
            return false;
        }
        while (it.hasNext()) {
            try {
                if (!DefaultTypeTransformation.compareEqual(value, it.next())) continue;
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public void step(int step, Closure closure) {
        if (this.reverse) {
            step = -step;
        }
        if (step >= 0) {
            Comparable value = this.from;
            while (value.compareTo(this.to) <= 0) {
                closure.call(value);
                for (int i = 0; i < step; ++i) {
                    value = (Comparable)this.increment(value);
                }
            }
        } else {
            step = -step;
            Comparable value = this.to;
            while (value.compareTo(this.from) >= 0) {
                closure.call(value);
                for (int i = 0; i < step; ++i) {
                    value = (Comparable)this.decrement(value);
                }
            }
        }
    }

    public List step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    protected Object increment(Object value) {
        return InvokerHelper.invokeMethod(value, "next", null);
    }

    protected Object decrement(Object value) {
        return InvokerHelper.invokeMethod(value, "previous", null);
    }

    private static Comparable normaliseStringType(Comparable operand) {
        if (operand instanceof Character) {
            return new Integer(((Character)operand).charValue());
        }
        if (operand instanceof String) {
            String string = (String)((Object)operand);
            if (string.length() == 1) {
                return new Integer(string.charAt(0));
            }
            return string;
        }
        return operand;
    }
}

