/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class FileSystemCompiler {
    private CompilationUnit unit;

    public FileSystemCompiler(CompilerConfiguration configuration) throws ConfigurationException {
        this.unit = configuration.getJointCompilationOptions() != null ? new JavaAwareCompilationUnit(configuration) : new CompilationUnit(configuration);
    }

    public void compile(String[] paths) throws Exception {
        this.unit.addSources(paths);
        this.unit.compile();
    }

    public void compile(File[] files) throws Exception {
        this.unit.addSources(files);
        this.unit.compile();
    }

    public static void displayHelp() {
        System.err.println("Usage: groovyc <options> <source files>");
        System.err.println("where possible options include: ");
        System.err.println("  --classpath <path>        Specify where to find user class files");
        System.err.println("  -d <directory>            Specify where to place generated class files");
        System.err.println("  --encoding <encoding>     Specify the encoding of the user class files");
        System.err.println("  --version                 Print the verion");
        System.err.println("  --help                    Print a synopsis of standard options");
        System.err.println("  --exception               Print stack trace on error");
        System.err.println("  --jointCompilation        attach javac compiler to compile .java files");
        System.err.println("");
    }

    public static void displayVersion() {
        System.err.println("Groovy compiler version 1.1-beta-2");
        System.err.println("Copyright 2003-2007 The Codehaus. http://groovy.codehaus.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(filenames[i]);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (file.canRead()) continue;
            System.err.println("error: file not readable: " + file);
            ++errors;
        }
        return errors;
    }

    public static void main(String[] args) {
        boolean displayStackTraceOnError = false;
        boolean jointCompilation = false;
        try {
            String[] filenames;
            Options options = new Options();
            OptionBuilder.withLongOpt((String)"classpath");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"classpath");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"sourcepath");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"sourcepath");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"temp");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"temp");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"encoding");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"encoding");
            options.addOption(OptionBuilder.create());
            OptionBuilder.hasArg();
            options.addOption(OptionBuilder.create((char)'d'));
            OptionBuilder.withLongOpt((String)"help");
            options.addOption(OptionBuilder.create((char)'h'));
            OptionBuilder.withLongOpt((String)"version");
            options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"exception");
            options.addOption(OptionBuilder.create((char)'e'));
            OptionBuilder.withLongOpt((String)"jointCompilation");
            options.addOption(OptionBuilder.create((char)'j'));
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            options.addOption(OptionBuilder.create((String)"J"));
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.hasArg();
            options.addOption(OptionBuilder.create((String)"F"));
            PosixParser cliParser = new PosixParser();
            CommandLine cli = cliParser.parse(options, args);
            if (cli.hasOption('h')) {
                FileSystemCompiler.displayHelp();
                return;
            }
            if (cli.hasOption('v')) {
                FileSystemCompiler.displayVersion();
            }
            CompilerConfiguration configuration = new CompilerConfiguration();
            if (cli.hasOption("classpath")) {
                configuration.setClasspath(cli.getOptionValue("classpath"));
            }
            if (cli.hasOption('d')) {
                configuration.setTargetDirectory(cli.getOptionValue('d'));
            }
            if (cli.hasOption("encoding")) {
                configuration.setSourceEncoding(cli.getOptionValue("encoding"));
            }
            displayStackTraceOnError = cli.hasOption('e');
            jointCompilation = cli.hasOption('j');
            if (jointCompilation) {
                HashMap<String, String[]> compilerOptions = new HashMap<String, String[]>();
                String[] opts = cli.getOptionValues("J");
                compilerOptions.put("namedValues", opts);
                opts = cli.getOptionValues("F");
                compilerOptions.put("flags", opts);
                configuration.setJointCompilationOptions(compilerOptions);
            }
            if ((filenames = cli.getArgs()).length == 0) {
                FileSystemCompiler.displayHelp();
                return;
            }
            int errors = FileSystemCompiler.checkFiles(filenames);
            if (errors == 0) {
                if (jointCompilation) {
                    File tmpDir = FileSystemCompiler.createTempDir();
                    configuration.getJointCompilationOptions().put("stubDir", tmpDir);
                }
                FileSystemCompiler compiler = new FileSystemCompiler(configuration);
                compiler.compile(filenames);
            }
        }
        catch (Throwable e) {
            new ErrorReporter(e, displayStackTraceOnError).write(System.err);
        }
    }

    private static File createTempDir() throws IOException {
        File tempFile = File.createTempFile("generated-", "java-source");
        tempFile.delete();
        tempFile.mkdirs();
        return tempFile;
    }
}

