/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import java.util.Map;
import java.util.WeakHashMap;

public class ThreadManagedMetaBeanProperty
extends MetaBeanProperty {
    private static final Class[] ZERO_ARGUMENT_LIST = new Class[0];
    private static final ThreadLocal propertyInstanceHolder = new InheritableThreadLocal();
    private Class declaringClass;
    private ThreadBoundGetter getter;
    private ThreadBoundSetter setter;
    private Object initialValue;
    private static final String PROPERTY_SET_PREFIX = "set";

    public synchronized Object getInitialValue() {
        return this.initialValue;
    }

    public ThreadManagedMetaBeanProperty(Class declaringClass, String name, Class type, Object iv) {
        super(name, type, null, null);
        this.type = type;
        this.declaringClass = declaringClass;
        this.getter = new ThreadBoundGetter(name);
        this.setter = new ThreadBoundSetter(name);
        this.initialValue = iv;
    }

    private static Object getThreadBoundPropertyValue(Object obj, String name, Object initialValue) {
        String key;
        Map propertyMap = ThreadManagedMetaBeanProperty.getThreadBoundPropertMap();
        if (propertyMap.containsKey(key = System.identityHashCode(obj) + name)) {
            return propertyMap.get(key);
        }
        propertyMap.put(key, initialValue);
        return initialValue;
    }

    private static Map getThreadBoundPropertMap() {
        WeakHashMap propertyMap = (WeakHashMap)propertyInstanceHolder.get();
        if (propertyMap == null) {
            propertyMap = new WeakHashMap();
            propertyInstanceHolder.set(propertyMap);
        }
        return propertyMap;
    }

    private static Object setThreadBoundPropertyValue(Object obj, String name, Object value) {
        Map propertyMap = ThreadManagedMetaBeanProperty.getThreadBoundPropertMap();
        String key = System.identityHashCode(obj) + name;
        return propertyMap.put(key, value);
    }

    public MetaMethod getGetter() {
        return this.getter;
    }

    public MetaMethod getSetter() {
        return this.setter;
    }

    private String getGetterName(String propertyName, Class type) {
        String prefix = type == Boolean.TYPE || type == Boolean.class ? "is" : "get";
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private class ThreadBoundSetter
    extends MetaMethod {
        private String setterName;

        public ThreadBoundSetter(String name) {
            super(name, ThreadManagedMetaBeanProperty.this.declaringClass, new Class[]{ThreadManagedMetaBeanProperty.this.type}, ThreadManagedMetaBeanProperty.this.type, 1);
            this.setterName = ThreadManagedMetaBeanProperty.this.getSetterName(name);
        }

        public String getName() {
            return this.setterName;
        }

        public Object invoke(Object object, Object[] arguments) {
            return ThreadManagedMetaBeanProperty.setThreadBoundPropertyValue(object, ThreadManagedMetaBeanProperty.this.name, arguments[0]);
        }
    }

    class ThreadBoundGetter
    extends MetaMethod {
        private String getterName;

        public ThreadBoundGetter(String name) {
            super(name, ThreadManagedMetaBeanProperty.this.declaringClass, ZERO_ARGUMENT_LIST, ThreadManagedMetaBeanProperty.this.type, 1);
            this.getterName = ThreadManagedMetaBeanProperty.this.getGetterName(name, ThreadManagedMetaBeanProperty.this.type);
        }

        public String getName() {
            return this.getterName;
        }

        public Object invoke(Object object, Object[] arguments) {
            return ThreadManagedMetaBeanProperty.getThreadBoundPropertyValue(object, ThreadManagedMetaBeanProperty.this.name, ThreadManagedMetaBeanProperty.this.getInitialValue());
        }
    }
}

