/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import groovyjarjarbackport.java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.util.ManagedReference;
import org.codehaus.groovy.util.ReferenceBundle;
import org.codehaus.groovy.util.ReferenceType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyReference<T>
extends ReentrantLock {
    private static final ManagedReference INIT = new ManagedReference(ReferenceType.HARD, null, (Object)null){};
    private static final ManagedReference NULL_REFERENCE = new ManagedReference(ReferenceType.HARD, null, (Object)null){};
    private ManagedReference<T> reference = INIT;
    private final ReferenceBundle bundle;

    public LazyReference(ReferenceBundle bundle) {
        this.bundle = bundle;
    }

    public T get() {
        ManagedReference<T> resRef = this.reference;
        if (resRef == INIT) {
            return this.getLocked(false);
        }
        if (resRef == NULL_REFERENCE) {
            return null;
        }
        T res = resRef.get();
        if (res == null) {
            return this.getLocked(true);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getLocked(boolean force) {
        this.lock();
        try {
            ManagedReference<T> resRef = this.reference;
            if (!force && resRef != INIT) {
                T t = resRef.get();
                return t;
            }
            T res = this.initValue();
            this.reference = res == null ? NULL_REFERENCE : new ManagedReference<T>(this.bundle, res);
            T t = res;
            return t;
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.reference = INIT;
    }

    public abstract T initValue();

    @Override
    public String toString() {
        T res = this.reference.get();
        if (res == null) {
            return "<null>";
        }
        return res.toString();
    }
}

