/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarretroruntime.impl;

import groovyjarjarbackport.java.util.concurrent.ConcurrentHashMap;
import groovyjarjarbackport.java.util.concurrent.ConcurrentMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityTable<K, V> {
    private final ConcurrentMap<IdentityKey<K>, V> map = new ConcurrentHashMap();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    public V lookup(K key) {
        return this.map.get(new StrongKey<K>(key));
    }

    public V obtain(K key) {
        Object currentValue = this.map.get(new StrongKey<K>(key));
        if (currentValue != null) {
            return currentValue;
        }
        this.cleanup();
        V newValue = this.initialValue();
        Object previousValue = this.map.putIfAbsent(new WeakKey<K>(key, this.queue), newValue);
        return (V)(previousValue != null ? previousValue : newValue);
    }

    public void putIfAbsent(K key, V value) {
        this.cleanup();
        this.map.putIfAbsent(new WeakKey<K>(key, this.queue), value);
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    protected V initialValue() {
        return null;
    }

    private void cleanup() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakKey<T>
    extends WeakReference<T>
    implements IdentityKey<T> {
        private int hashCode;

        public WeakKey(T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            if (referent == null) {
                throw new NullPointerException();
            }
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityKey && ((IdentityKey)obj).get() == this.get();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongKey<T>
    implements IdentityKey<T> {
        private T referent;

        public StrongKey(T referent) {
            if (referent == null) {
                throw new NullPointerException();
            }
            this.referent = referent;
        }

        @Override
        public T get() {
            return this.referent;
        }

        public int hashCode() {
            return System.identityHashCode(this.referent);
        }

        public boolean equals(Object obj) {
            return obj instanceof IdentityKey && ((IdentityKey)obj).get() == this.referent;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IdentityKey<T> {
        public T get();
    }
}

