/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarretroruntime.format;

import groovyjarjarretroruntime.format.Conversion;
import groovyjarjarretroruntime.format.FormatContext;

abstract class GeneralConversion
extends Conversion {
    GeneralConversion() {
    }

    protected void printf(FormatContext context, Object argument) {
        context.assertNoFlag('#');
        context.checkWidth();
        context.writeRestricted(String.valueOf(argument));
    }

    public static class StringConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            if (!context.writeFormattable()) {
                context.checkWidth();
                context.writeRestricted(String.valueOf(context.getArgument()));
            }
        }
    }

    public static class HashConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            Object argument = context.getArgument();
            this.printf(context, argument == null ? null : Integer.toHexString(argument.hashCode()));
        }
    }

    public static class BooleanConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            Object argument = context.getArgument();
            this.printf(context, argument instanceof Boolean ? argument : Boolean.valueOf(argument != null));
        }
    }
}

