/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.sql.Sql;
import groovy.sql.SqlOrderByVisitor;
import groovy.sql.SqlWhereVisitor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.Statement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
extends Sql {
    private Closure where;
    private Closure sort;
    private boolean reversed = false;
    private DataSet parent;
    private String table;
    private SqlWhereVisitor visitor;
    private SqlOrderByVisitor sortVisitor;
    private String sql;
    private List params;

    public DataSet(Sql sql, Class type) {
        super(sql);
        String table = type.getName();
        int idx = table.lastIndexOf(46);
        if (idx > 0) {
            table = table.substring(idx + 1);
        }
        this.table = table.toLowerCase();
    }

    public DataSet(Sql sql, String table) {
        super(sql);
        this.table = table;
    }

    private DataSet(DataSet parent, Closure where) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.where = where;
    }

    private DataSet(DataSet parent, Closure where, Closure sort) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.where = where;
        this.sort = sort;
    }

    private DataSet(DataSet parent) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.reversed = true;
    }

    public void add(Map<String, Object> map) throws SQLException {
        StringBuffer buffer = new StringBuffer("insert into ");
        buffer.append(this.table);
        buffer.append(" (");
        StringBuffer paramBuffer = new StringBuffer();
        boolean first = true;
        for (String column : map.keySet()) {
            if (first) {
                first = false;
                paramBuffer.append("?");
            } else {
                buffer.append(", ");
                paramBuffer.append(", ?");
            }
            buffer.append(column);
        }
        buffer.append(") values (");
        buffer.append(paramBuffer.toString());
        buffer.append(")");
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(buffer.toString());
            int i = 1;
            for (Object value : map.values()) {
                this.setObject(statement, i++, value);
            }
            int answer = statement.executeUpdate();
            if (answer != 1) {
                this.log.log(Level.WARNING, new StringBuffer().append("Should have updated 1 row not ").append(answer).append(" when trying to add: ").append(map).toString());
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, new StringBuffer().append("Failed to add row for: ").append(map).toString(), e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public DataSet findAll(Closure where) {
        return new DataSet(this, where);
    }

    public DataSet sort(Closure sort) {
        return new DataSet(this, null, sort);
    }

    public DataSet reverse() {
        if (this.sort == null) {
            throw new GroovyRuntimeException("reverse() only allowed immediately after a sort()");
        }
        return new DataSet(this);
    }

    public void each(Closure closure) throws SQLException {
        this.eachRow(this.getSql(), this.getParameters(), closure);
    }

    private String getSqlWhere() {
        String whereClaus = "";
        String parentClaus = "";
        if (this.parent != null) {
            parentClaus = this.parent.getSqlWhere();
        }
        if (this.where != null) {
            whereClaus = new StringBuffer().append(whereClaus).append(this.getSqlWhereVisitor().getWhere()).toString();
        }
        if (parentClaus.length() == 0) {
            return whereClaus;
        }
        if (whereClaus.length() == 0) {
            return parentClaus;
        }
        return new StringBuffer().append(parentClaus).append(" and ").append(whereClaus).toString();
    }

    private String getSqlOrderBy() {
        String sortByClaus = "";
        String parentClaus = "";
        if (this.parent != null) {
            parentClaus = this.parent.getSqlOrderBy();
        }
        if (this.reversed && parentClaus.length() > 0) {
            parentClaus = new StringBuffer().append(parentClaus).append(" DESC").toString();
        }
        if (this.sort != null) {
            sortByClaus = new StringBuffer().append(sortByClaus).append(this.getSqlOrderByVisitor().getOrderBy()).toString();
        }
        if (parentClaus.length() == 0) {
            return sortByClaus;
        }
        if (sortByClaus.length() == 0) {
            return parentClaus;
        }
        return new StringBuffer().append(parentClaus).append(", ").append(sortByClaus).toString();
    }

    public String getSql() {
        if (this.sql == null) {
            String orerByClaus;
            this.sql = new StringBuffer().append("select * from ").append(this.table).toString();
            String whereClaus = this.getSqlWhere();
            if (whereClaus.length() > 0) {
                this.sql = new StringBuffer().append(this.sql).append(" where ").append(whereClaus).toString();
            }
            if ((orerByClaus = this.getSqlOrderBy()).length() > 0) {
                this.sql = new StringBuffer().append(this.sql).append(" order by ").append(orerByClaus).toString();
            }
        }
        return this.sql;
    }

    public List getParameters() {
        if (this.params == null) {
            this.params = new ArrayList();
            if (this.parent != null) {
                this.params.addAll(this.parent.getParameters());
            }
            this.params.addAll(this.getSqlWhereVisitor().getParameters());
        }
        return this.params;
    }

    protected SqlWhereVisitor getSqlWhereVisitor() {
        if (this.visitor == null) {
            this.visitor = new SqlWhereVisitor();
            this.visit(this.where, this.visitor);
        }
        return this.visitor;
    }

    protected SqlOrderByVisitor getSqlOrderByVisitor() {
        if (this.sortVisitor == null) {
            this.sortVisitor = new SqlOrderByVisitor();
            this.visit(this.sort, this.sortVisitor);
        }
        return this.sortVisitor;
    }

    private void visit(Closure closure, CodeVisitorSupport visitor) {
        if (closure != null) {
            Statement statement;
            MethodNode method;
            ClassNode classNode = closure.getMetaClass().getClassNode();
            if (classNode == null) {
                throw new GroovyRuntimeException(new StringBuffer().append("Could not find the ClassNode for MetaClass: ").append(closure.getMetaClass()).toString());
            }
            List methods = classNode.getDeclaredMethods("doCall");
            if (!methods.isEmpty() && (method = (MethodNode)methods.get(0)) != null && (statement = method.getCode()) != null) {
                statement.visit(visitor);
            }
        }
    }

    public DataSet createView(Closure criteria) {
        return new DataSet(this, criteria);
    }

    public List rows() throws SQLException {
        return this.rows(this.getSql(), this.getParameters());
    }

    public Object firstRow() throws SQLException {
        List rows = this.rows();
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }
}

