/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarbackport.java.util.concurrent;

import groovyjarjarbackport.java.util.concurrent.TimeUnit;
import groovyjarjarbackport.java.util.concurrent.helpers.FIFOWaitQueue;
import groovyjarjarbackport.java.util.concurrent.helpers.Utils;
import groovyjarjarbackport.java.util.concurrent.helpers.WaitQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int permits) {
        this.sync = new NonfairSync(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.sync = fair ? new FairSync(permits) : new NonfairSync(permits);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquire(1);
    }

    public void acquireUninterruptibly() {
        this.sync.acquireUninterruptibly(1);
    }

    public boolean tryAcquire() {
        return this.sync.attempt(1);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.attempt(1, unit.toNanos(timeout));
    }

    public void release() {
        this.sync.release(1);
    }

    public void acquire(int permits) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquire(permits);
    }

    public void acquireUninterruptibly(int permits) {
        this.sync.acquireUninterruptibly(permits);
    }

    public boolean tryAcquire(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.attempt(permits);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.attempt(permits, unit.toNanos(timeout));
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permits);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drain();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reduce(reduction);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync(int initialPermits) {
            super(initialPermits);
        }

        public void acquireUninterruptibly(int n) {
            if (this.precheck(n)) {
                return;
            }
            Node w = new Node(n);
            w.doWaitUninterruptibly(this);
        }

        public void acquire(int n) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck(n)) {
                return;
            }
            Node w = new Node(n);
            w.doWait(this);
        }

        public boolean attempt(int n, long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck(n)) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            Node w = new Node(n);
            return w.doTimedWait(this, nanos);
        }

        protected synchronized boolean precheck(int n) {
            boolean pass;
            boolean bl = pass = this.permits_ >= n;
            if (pass) {
                this.permits_ -= n;
            }
            return pass;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode w) {
            boolean pass;
            Node node = (Node)w;
            boolean bl = pass = this.permits_ >= node.requests;
            if (pass) {
                this.permits_ -= node.requests;
            } else {
                this.wq_.insert(w);
            }
            return pass;
        }

        public void takeOver(WaitQueue.WaitNode n) {
        }

        protected synchronized Node getSignallee(int n) {
            Node w = (Node)this.wq_.extract();
            this.permits_ += n;
            if (w == null) {
                return null;
            }
            if (w.requests > this.permits_) {
                this.wq_.putBack(w);
                return null;
            }
            this.permits_ -= w.requests;
            return w;
        }

        public void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            Node w;
            while ((w = this.getSignallee(n)) != null) {
                if (w.signal(this)) {
                    return;
                }
                n = w.requests;
            }
            return;
        }

        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
            }
        }

        static final class Node
        extends WaitQueue.WaitNode {
            final int requests;

            Node(int requests) {
                this.requests = requests;
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        protected NonfairSync(int initialPermits) {
            super(initialPermits);
        }

        private static void checkAgainstMultiacquire(int n) {
            if (n != 1) {
                throw new UnsupportedOperationException("Atomic multi-acquire supported only in FAIR semaphores");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquireUninterruptibly(int n) {
            if (n == 0) {
                return;
            }
            NonfairSync.checkAgainstMultiacquire(n);
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            wasInterrupted = true;
                        }
                    } while (this.permits_ <= 0);
                    --this.permits_;
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(int n) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (n == 0) {
                return;
            }
            NonfairSync.checkAgainstMultiacquire(n);
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                while (this.permits_ <= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
                --this.permits_;
            }
        }

        public boolean attempt(int n, long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (n == 0) {
                return true;
            }
            NonfairSync.checkAgainstMultiacquire(n);
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                try {
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        if (this.permits_ <= 0) continue;
                        --this.permits_;
                        return true;
                    } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            for (int i = 0; i < n; ++i) {
                this.notify();
            }
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        protected Sync(int permits) {
            this.permits_ = permits;
        }

        abstract void acquireUninterruptibly(int var1);

        abstract void acquire(int var1) throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(int n) {
            Sync sync = this;
            synchronized (sync) {
                if (this.permits_ >= n) {
                    this.permits_ -= n;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(int var1, long var2) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int acquired = this.permits_;
            this.permits_ = 0;
            return acquired;
        }

        public synchronized void reduce(int reduction) {
            this.permits_ -= reduction;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();
    }
}

