/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.util;

import griffon.util.ConfigReader;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroovyScriptResourceBundle
extends ResourceBundle {
    private static final String ERROR_READER_NULL = "Argument 'reader' must not be null";
    private final ConfigObject config;
    private final Set<String> keys = new LinkedHashSet<String>();
    private final String source;

    public GroovyScriptResourceBundle(@Nonnull ConfigReader reader, @Nonnull URL location) {
        this(Objects.requireNonNull(reader, ERROR_READER_NULL).parse(Objects.requireNonNull(location, "Argument 'location' must not be null")), location.toString());
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader reader, @Nonnull Script script) {
        this(Objects.requireNonNull(reader, ERROR_READER_NULL).parse(Objects.requireNonNull(script, "Argument 'script' must not be null")), script.getClass().getName());
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader reader, @Nonnull String script) {
        this(Objects.requireNonNull(reader, ERROR_READER_NULL).parse(GriffonNameUtils.requireNonBlank((String)script, (String)"Argument 'script' must not be blank")), "<<INLINE SCRIPT>>");
    }

    public GroovyScriptResourceBundle(@Nonnull ConfigReader reader, @Nonnull Class<? extends Script> scriptClass) {
        this(Objects.requireNonNull(reader, ERROR_READER_NULL).parse(Objects.requireNonNull(scriptClass, "Argument 'scriptClass' must not be null")), scriptClass.getName());
    }

    private GroovyScriptResourceBundle(@Nonnull ConfigObject config, @Nonnull String source) {
        this.config = Objects.requireNonNull(config, "Argument 'config' must not be null");
        this.source = source;
        this.keys.addAll(this.config.flatten(new LinkedHashMap()).keySet());
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    public String toString() {
        return super.toString() + "[" + this.source + "]";
    }

    @Override
    @Nullable
    protected Object handleGetObject(@Nonnull String key) {
        Object value = ConfigUtils.getConfigValue((Map)this.config, (String)GriffonNameUtils.requireNonBlank((String)key, (String)"Argument 'key' must not be blank"), null);
        if (null == value) {
            return null;
        }
        if (value instanceof ConfigObject) {
            return ((ConfigObject)value).isEmpty() ? null : value;
        }
        return value;
    }

    @Override
    @Nonnull
    public Enumeration<String> getKeys() {
        final Iterator<String> keysIterator = this.keys.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return keysIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)keysIterator.next();
            }
        };
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.keys);
    }
}

