/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.util;

import griffon.core.resources.ResourceHandler;
import griffon.util.ConfigReader;
import groovy.lang.Script;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.groovy.util.GroovyScriptResourceBundle;
import org.codehaus.griffon.runtime.util.DefaultCompositeResourceBundleBuilder;

public class GroovyAwareCompositeResourceBundleBuilder
extends DefaultCompositeResourceBundleBuilder {
    protected static final String GROOVY_SUFFIX = ".groovy";
    private final ConfigReader configReader;

    @Inject
    public GroovyAwareCompositeResourceBundleBuilder(@Nonnull ResourceHandler resourceHandler, @Nonnull ConfigReader configReader) {
        super(resourceHandler);
        this.configReader = Objects.requireNonNull(configReader, "Argument 'reader' must not be null");
    }

    @Nonnull
    protected Collection<ResourceBundle> loadBundleFromClass(@Nonnull String fileName) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        URL resource = this.getResourceAsURL(fileName, GROOVY_SUFFIX);
        if (null != resource) {
            bundles.add(new GroovyScriptResourceBundle(this.configReader, resource));
            return bundles;
        }
        resource = this.getResourceAsURL(fileName, ".class");
        if (null != resource) {
            String className = fileName.replace('/', '.');
            try {
                Class klass = this.loadClass(className);
                if (Script.class.isAssignableFrom(klass)) {
                    bundles.add(new GroovyScriptResourceBundle(this.configReader, klass));
                    return bundles;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadBundleFromClass(fileName);
    }
}

