/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.util.FactoryBuilderSupport;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BindUtils {
    @Nonnull
    public static BindingBuilder binding() {
        return new BindingBuilder();
    }

    public static class BindingBuilder {
        private Object source;
        private Object target;
        private String sourceProperty;
        private String targetProperty;
        private CallableWithArgs<?> converter;
        private CallableWithArgs<?> validator;
        private boolean mutual;

        @Nonnull
        public BindingBuilder withSource(@Nullable Object source) {
            this.source = source;
            return this;
        }

        @Nonnull
        public BindingBuilder withTarget(@Nullable Object target) {
            this.target = target;
            return this;
        }

        @Nonnull
        public BindingBuilder withSourceProperty(@Nullable String sourceProperty) {
            this.sourceProperty = sourceProperty;
            return this;
        }

        @Nonnull
        public BindingBuilder withTargetProperty(@Nullable String targetProperty) {
            this.targetProperty = targetProperty;
            return this;
        }

        @Nonnull
        public BindingBuilder withConverter(@Nullable CallableWithArgs<?> converter) {
            this.converter = converter;
            return this;
        }

        @Nonnull
        public BindingBuilder withValidator(@Nullable CallableWithArgs<?> validator) {
            this.validator = validator;
            return this;
        }

        @Nonnull
        public BindingBuilder withMutual(boolean mutual) {
            this.mutual = mutual;
            return this;
        }

        public void make(@Nonnull FactoryBuilderSupport builder) {
            Objects.requireNonNull(builder, "Cannot make binding with a null builder!");
            Objects.requireNonNull(this.source, "Unspecified value for: source");
            Objects.requireNonNull(this.target, "Unspecified value for: target");
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                this.sourceProperty = this.targetProperty;
            }
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                throw new IllegalArgumentException("Unspecified values for: sourceProperty, targetProperty");
            }
            if (GriffonNameUtils.isBlank((String)this.targetProperty)) {
                this.targetProperty = this.sourceProperty;
            }
            attributes.put("source", this.source);
            attributes.put("target", this.target);
            attributes.put("sourceProperty", this.sourceProperty);
            attributes.put("targetProperty", this.targetProperty);
            attributes.put("mutual", this.mutual);
            if (this.converter != null) {
                attributes.put("converter", this.makeClosure(builder, this.converter));
            }
            if (this.validator != null) {
                attributes.put("validator", this.makeClosure(builder, this.validator));
            }
            builder.invokeMethod("bind", attributes);
        }

        private Closure<?> makeClosure(@Nonnull FactoryBuilderSupport builder, final @Nonnull CallableWithArgs<?> callback) {
            if (callback instanceof Closure) {
                return (Closure)callback;
            }
            return new Closure<Object>((Object)builder){
                private static final long serialVersionUID = -4108869890482462552L;

                public Object call(Object ... args) {
                    return callback.call(args);
                }

                public Object call(Object args) {
                    return callback.call(new Object[]{args});
                }
            };
        }
    }
}

