/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.gmavenplus.mojo.GroovyDocMojo;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="groovydoc-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GroovyDocJarMojo
extends GroovyDocMojo {
    @Parameter(property="project.build.finalName")
    protected String finalName;
    @Parameter(property="project.build.directory")
    protected String jarOutputDirectory;
    @Component(role=Archiver.class, hint="jar")
    protected JarArchiver jarArchiver;
    @Parameter
    protected final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="attach", defaultValue="true")
    protected boolean attach;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    protected File defaultManifestFile;
    @Parameter(defaultValue="false")
    private boolean useDefaultManifestFile;
    @Parameter(defaultValue="groovydoc")
    private String classifier;
    @Parameter(defaultValue="javadoc")
    private String artifactType;
    @Parameter(defaultValue="true")
    protected boolean invokeGroovyDoc;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.invokeGroovyDoc) {
            super.execute();
        }
        try {
            File outputFile = this.generateArchive(this.groovyDocOutputDirectory, this.finalName + "-" + this.classifier + ".jar");
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, this.artifactType, this.classifier, outputFile);
            } else {
                this.getLog().info((CharSequence)"Not adding GroovyDoc jar to attached artifacts list.");
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException: Error while creating archive", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: Error while creating archive", (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("RuntimeException: Error while creating archive", (Exception)e);
        }
    }

    protected File generateArchive(File groovydocFiles, String jarFileName) throws ArchiverException, IOException {
        File groovydocJar = new File(this.jarOutputDirectory, jarFileName);
        if (groovydocJar.exists()) {
            groovydocJar.delete();
        }
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(groovydocJar);
        if (!groovydocFiles.exists()) {
            this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
        } else {
            archiver.getArchiver().addDirectory(groovydocFiles);
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
            }
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ManifestException e) {
            throw new ArchiverException("ManifestException: " + e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ArchiverException("DependencyResolutionRequiredException: " + e.getMessage(), (Throwable)e);
        }
        return groovydocJar;
    }
}

